/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc.task;

import java.util.Set;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.service.IControllerService;

public class LocalStorageCleanupTask
implements INCLifecycleTask {
    private static final long serialVersionUID = 1L;
    private final int metadataPartitionId;

    public LocalStorageCleanupTask(int metadataPartitionId) {
        this.metadataPartitionId = metadataPartitionId;
    }

    public void perform(CcId ccId, IControllerService cs) throws HyracksDataException {
        INcApplicationContext appContext = (INcApplicationContext)cs.getApplicationContext();
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)appContext.getLocalResourceRepository();
        this.deleteInvalidMetadataIndexes(localResourceRepository);
        Set nodePartitions = appContext.getReplicaManager().getPartitions();
        localResourceRepository.deleteCorruptedResources();
        for (Integer partition : nodePartitions) {
            localResourceRepository.cleanup(partition.intValue());
        }
    }

    private void deleteInvalidMetadataIndexes(PersistentLocalResourceRepository localResourceRepository) throws HyracksDataException {
        localResourceRepository.deleteInvalidIndexes(r -> {
            DatasetLocalResource lr = (DatasetLocalResource)r.getResource();
            return MetadataIndexImmutableProperties.isMetadataDataset((int)lr.getDatasetId()) && lr.getPartition() != this.metadataPartitionId;
        });
    }

    public String toString() {
        return "LocalStorageCleanupTask{metadataPartitionId=" + this.metadataPartitionId + "}";
    }
}

