/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.util.InvokeUtil;
import org.apache.hyracks.control.common.base.IClusterController;
import org.apache.hyracks.control.common.controllers.NodeParameters;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcConnection {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long REGISTRATION_RESPONSE_POLL_PERIOD = TimeUnit.SECONDS.toMillis(1L);
    private final IClusterController ccs;
    private final InetSocketAddress ccAddress;
    private boolean registrationPending;
    private boolean registrationCompleted;
    private Exception registrationException;
    private NodeParameters nodeParameters;

    CcConnection(IClusterController ccs, InetSocketAddress ccAddress) {
        this.ccs = ccs;
        this.ccAddress = ccAddress;
    }

    public String toString() {
        return this.ccs.toString();
    }

    public CcId getCcId() {
        return this.getNodeParameters().getClusterControllerInfo().getCcId();
    }

    synchronized void setNodeRegistrationResult(NodeParameters parameters, Exception exception) {
        this.nodeParameters = parameters;
        this.registrationException = exception;
        this.registrationPending = false;
        this.notifyAll();
    }

    public synchronized CcId registerNode(NodeRegistration nodeRegistration, int registrationId) throws Exception {
        this.registrationPending = true;
        this.ccs.registerNode(nodeRegistration, registrationId);
        try {
            InvokeUtil.runWithTimeout(() -> this.wait(REGISTRATION_RESPONSE_POLL_PERIOD), () -> !this.registrationPending, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        }
        catch (Exception e) {
            this.registrationException = e;
        }
        if (this.registrationException != null) {
            LOGGER.fatal("Registering with {} failed with exception", (Object)this, (Object)this.registrationException);
            ExitUtil.halt((int)15);
        }
        return this.getCcId();
    }

    public IClusterController getClusterControllerService() {
        return this.ccs;
    }

    public NodeParameters getNodeParameters() {
        return this.nodeParameters;
    }

    public synchronized void forceReregister(NodeControllerService ncs) throws InterruptedException {
        this.registrationCompleted = false;
        ncs.getExecutor().submit(() -> {
            try {
                return ncs.registerNode(this);
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Failed registering with cc", (Throwable)e);
                throw new IllegalStateException(e);
            }
        });
        while (!this.registrationCompleted) {
            this.wait();
        }
    }

    public synchronized void notifyRegistrationCompleted() {
        this.registrationCompleted = true;
        this.notifyAll();
    }

    public InetSocketAddress getCcAddress() {
        return this.ccAddress;
    }
}

