/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.PropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class InsertDeleteUpsertOperator
extends AbstractLogicalOperator {
    private final IDataSource<?> dataSource;
    private final Mutable<ILogicalExpression> payloadExpr;
    private final List<Mutable<ILogicalExpression>> primaryKeyExprs;
    private final Kind operation;
    private final boolean bulkload;
    private List<Mutable<ILogicalExpression>> additionalFilteringExpressions;
    private final List<Mutable<ILogicalExpression>> additionalNonFilteringExpressions;
    private LogicalVariable prevRecordVar;
    private Object prevRecordType;
    private LogicalVariable prevFilterVar;
    private Object prevFilterType;
    private List<LogicalVariable> prevAdditionalNonFilteringVars;
    private List<Object> prevAdditionalNonFilteringTypes;
    private LogicalVariable upsertIndicatorVar;
    private Object upsertIndicatorVarType;

    public InsertDeleteUpsertOperator(IDataSource<?> dataSource, Mutable<ILogicalExpression> payloadExpr, List<Mutable<ILogicalExpression>> primaryKeyExprs, List<Mutable<ILogicalExpression>> additionalNonFilteringExpressions, Kind operation, boolean bulkload) {
        this.dataSource = dataSource;
        this.payloadExpr = payloadExpr;
        this.primaryKeyExprs = primaryKeyExprs;
        this.operation = operation;
        this.bulkload = bulkload;
        this.additionalNonFilteringExpressions = additionalNonFilteringExpressions;
    }

    public InsertDeleteUpsertOperator(IDataSource<?> dataSource, Mutable<ILogicalExpression> payloadExpr, List<Mutable<ILogicalExpression>> primaryKeyExprs, Kind operation, boolean bulkload) {
        this.dataSource = dataSource;
        this.payloadExpr = payloadExpr;
        this.primaryKeyExprs = primaryKeyExprs;
        this.operation = operation;
        this.bulkload = bulkload;
        this.additionalNonFilteringExpressions = null;
    }

    @Override
    public void recomputeSchema() throws AlgebricksException {
        this.schema = new ArrayList();
        if (this.operation == Kind.UPSERT) {
            this.schema.add(this.upsertIndicatorVar);
            this.schema.add(this.prevRecordVar);
            if (this.additionalNonFilteringExpressions != null) {
                this.schema.addAll(this.prevAdditionalNonFilteringVars);
            }
            if (this.prevFilterVar != null) {
                this.schema.add(this.prevFilterVar);
            }
        }
        this.schema.addAll(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
    }

    public void getProducedVariables(Collection<LogicalVariable> producedVariables) {
        if (this.upsertIndicatorVar != null) {
            producedVariables.add(this.upsertIndicatorVar);
        }
        if (this.prevRecordVar != null) {
            producedVariables.add(this.prevRecordVar);
        }
        if (this.prevAdditionalNonFilteringVars != null) {
            producedVariables.addAll(this.prevAdditionalNonFilteringVars);
        }
        if (this.prevFilterVar != null) {
            producedVariables.add(this.prevFilterVar);
        }
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform transform) throws AlgebricksException {
        boolean changed = false;
        changed = transform.transform(this.payloadExpr);
        for (Mutable<ILogicalExpression> e : this.primaryKeyExprs) {
            changed |= transform.transform(e);
        }
        if (this.additionalFilteringExpressions != null) {
            for (Mutable<ILogicalExpression> e : this.additionalFilteringExpressions) {
                changed |= transform.transform(e);
            }
        }
        if (this.additionalNonFilteringExpressions != null) {
            for (Mutable<ILogicalExpression> e : this.additionalNonFilteringExpressions) {
                changed |= transform.transform(e);
            }
        }
        return changed;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitInsertDeleteUpsertOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) throws AlgebricksException {
                if (InsertDeleteUpsertOperator.this.operation == Kind.UPSERT) {
                    target.addVariable(InsertDeleteUpsertOperator.this.upsertIndicatorVar);
                    target.addVariable(InsertDeleteUpsertOperator.this.prevRecordVar);
                    if (InsertDeleteUpsertOperator.this.prevAdditionalNonFilteringVars != null) {
                        for (LogicalVariable var : InsertDeleteUpsertOperator.this.prevAdditionalNonFilteringVars) {
                            target.addVariable(var);
                        }
                    }
                    if (InsertDeleteUpsertOperator.this.prevFilterVar != null) {
                        target.addVariable(InsertDeleteUpsertOperator.this.prevFilterVar);
                    }
                }
                target.addAllVariables(sources[0]);
            }
        };
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.INSERT_DELETE_UPSERT;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        PropagatingTypeEnvironment env = this.createPropagatingAllInputsTypeEnvironment(ctx);
        if (this.operation == Kind.UPSERT) {
            env.setVarType(this.upsertIndicatorVar, this.upsertIndicatorVarType);
            env.setVarType(this.prevRecordVar, this.prevRecordType);
            if (this.prevAdditionalNonFilteringVars != null) {
                for (int i = 0; i < this.prevAdditionalNonFilteringVars.size(); ++i) {
                    env.setVarType(this.prevAdditionalNonFilteringVars.get(i), this.prevAdditionalNonFilteringTypes.get(i));
                }
            }
            if (this.prevFilterVar != null) {
                env.setVarType(this.prevFilterVar, this.prevFilterType);
            }
        }
        return env;
    }

    public List<Mutable<ILogicalExpression>> getPrimaryKeyExpressions() {
        return this.primaryKeyExprs;
    }

    public IDataSource<?> getDataSource() {
        return this.dataSource;
    }

    public Mutable<ILogicalExpression> getPayloadExpression() {
        return this.payloadExpr;
    }

    public Kind getOperation() {
        return this.operation;
    }

    public boolean isBulkload() {
        return this.bulkload;
    }

    public List<Mutable<ILogicalExpression>> getAdditionalNonFilteringExpressions() {
        return this.additionalNonFilteringExpressions;
    }

    public void setAdditionalFilteringExpressions(List<Mutable<ILogicalExpression>> additionalFilteringExpressions) {
        this.additionalFilteringExpressions = additionalFilteringExpressions;
    }

    public List<Mutable<ILogicalExpression>> getAdditionalFilteringExpressions() {
        return this.additionalFilteringExpressions;
    }

    public LogicalVariable getBeforeOpRecordVar() {
        return this.prevRecordVar;
    }

    public void setPrevRecordVar(LogicalVariable prevRecordVar) {
        this.prevRecordVar = prevRecordVar;
    }

    public LogicalVariable getUpsertIndicatorVar() {
        return this.upsertIndicatorVar;
    }

    public void setUpsertIndicatorVar(LogicalVariable upsertIndicatorVar) {
        this.upsertIndicatorVar = upsertIndicatorVar;
    }

    public Object getUpsertIndicatorVarType() {
        return this.upsertIndicatorVarType;
    }

    public void setUpsertIndicatorVarType(Object upsertIndicatorVarType) {
        this.upsertIndicatorVarType = upsertIndicatorVarType;
    }

    public void setPrevRecordType(Object recordType) {
        this.prevRecordType = recordType;
    }

    public LogicalVariable getBeforeOpFilterVar() {
        return this.prevFilterVar;
    }

    public void setPrevFilterVar(LogicalVariable prevFilterVar) {
        this.prevFilterVar = prevFilterVar;
    }

    public Object getPrevFilterType() {
        return this.prevFilterType;
    }

    public void setPrevFilterType(Object prevFilterType) {
        this.prevFilterType = prevFilterType;
    }

    public List<LogicalVariable> getBeforeOpAdditionalNonFilteringVars() {
        return this.prevAdditionalNonFilteringVars;
    }

    public void setPrevAdditionalNonFilteringVars(List<LogicalVariable> prevAdditionalNonFilteringVars) {
        this.prevAdditionalNonFilteringVars = prevAdditionalNonFilteringVars;
    }

    public List<Object> getPrevAdditionalNonFilteringTypes() {
        return this.prevAdditionalNonFilteringTypes;
    }

    public void setPrevAdditionalNonFilteringTypes(List<Object> prevAdditionalNonFilteringTypes) {
        this.prevAdditionalNonFilteringTypes = prevAdditionalNonFilteringTypes;
    }

    public static enum Kind {
        INSERT,
        DELETE,
        UPSERT;

    }
}

