/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.HeaderFactory;
import org.apache.aries.subsystem.core.archive.ManifestVersionHeader;
import org.apache.aries.util.manifest.ManifestProcessor;

public abstract class Manifest {
    protected final Map<String, Header> headers = Collections.synchronizedMap(new HashMap());
    protected final java.util.jar.Manifest manifest;

    public Manifest(InputStream in) throws IOException {
        this(ManifestProcessor.parseManifest((InputStream)in));
    }

    public Manifest(java.util.jar.Manifest manifest) {
        this.manifest = manifest;
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            Header<?> header = HeaderFactory.createHeader(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            this.headers.put(header.getName(), header);
        }
        if (this.headers.get(ManifestVersionHeader.NAME) == null) {
            this.headers.put(ManifestVersionHeader.NAME, ManifestVersionHeader.DEFAULT);
        }
    }

    public Manifest(File manifestFile) throws IOException {
        this(new FileInputStream(manifestFile));
    }

    protected Manifest() {
        this.manifest = null;
    }

    public Header getHeader(String name) {
        return this.headers.get(name);
    }

    public Collection<Header> getHeaders() {
        return Collections.unmodifiableCollection(this.headers.values());
    }

    public java.util.jar.Manifest getManifest() {
        return this.manifest;
    }

    public Header getManifestVersion() {
        return this.getHeader(Attributes.Name.MANIFEST_VERSION.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getClass().getName()).append(": ");
        if (!this.headers.values().isEmpty()) {
            for (Header header : this.headers.values()) {
                sb.append(header.getName()).append('=').append(header.getValue()).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
        return sb.toString();
    }

    public void write(OutputStream out) throws IOException {
        java.util.jar.Manifest m = new java.util.jar.Manifest();
        Attributes attributes = m.getMainAttributes();
        for (Header header : this.headers.values()) {
            attributes.putValue(header.getName(), header.getValue());
        }
        m.write(out);
    }
}

