/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.scp.SCPEngine;

public final class SCPUploadClient {
    private final SCPEngine engine;
    private LocalFileFilter uploadFilter;

    SCPUploadClient(SCPEngine engine) {
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int copy(LocalSourceFile sourceFile, String remotePath) throws IOException {
        this.engine.cleanSlate();
        try {
            this.startCopy(sourceFile, remotePath);
        }
        finally {
            this.engine.exit();
        }
        return this.engine.getExitStatus();
    }

    public void setUploadFilter(LocalFileFilter uploadFilter) {
        this.uploadFilter = uploadFilter;
    }

    private synchronized void startCopy(LocalSourceFile sourceFile, String targetPath) throws IOException {
        LinkedList<SCPEngine.Arg> args = new LinkedList<SCPEngine.Arg>();
        args.add(SCPEngine.Arg.SINK);
        args.add(SCPEngine.Arg.RECURSIVE);
        if (sourceFile.providesAtimeMtime()) {
            args.add(SCPEngine.Arg.PRESERVE_TIMES);
        }
        this.engine.execSCPWith(args, targetPath);
        this.engine.check("Start status OK");
        this.process(sourceFile);
    }

    private void process(LocalSourceFile f) throws IOException {
        if (f.isDirectory()) {
            this.engine.startedDir(f.getName());
            this.sendDirectory(f);
            this.engine.finishedDir();
        } else if (f.isFile()) {
            this.engine.startedFile(f.getName(), f.getLength());
            this.sendFile(f);
            this.engine.finishedFile();
        } else {
            throw new IOException(f + " is not a regular file or directory");
        }
    }

    private void sendDirectory(LocalSourceFile f) throws IOException {
        this.preserveTimeIfPossible(f);
        this.engine.sendMessage("D0" + this.getPermString(f) + " 0 " + f.getName());
        for (LocalSourceFile localSourceFile : f.getChildren(this.uploadFilter)) {
            this.process(localSourceFile);
        }
        this.engine.sendMessage("E");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(LocalSourceFile f) throws IOException {
        this.preserveTimeIfPossible(f);
        InputStream src = f.getInputStream();
        try {
            this.engine.sendMessage("C0" + this.getPermString(f) + " " + f.getLength() + " " + f.getName());
            this.engine.transferToRemote(src, f.getLength());
            this.engine.signal("Transfer done");
            this.engine.check("Remote agrees transfer done");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(src);
            throw throwable;
        }
        IOUtils.closeQuietly(src);
    }

    private void preserveTimeIfPossible(LocalSourceFile f) throws IOException {
        if (f.providesAtimeMtime()) {
            this.engine.sendMessage("T" + f.getLastModifiedTime() + " 0 " + f.getLastAccessTime() + " 0");
        }
    }

    private String getPermString(LocalSourceFile f) throws IOException {
        return Integer.toOctalString(f.getPermissions() & 0xFFF);
    }
}

