/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client.authn;

import eu.unicore.security.wsutil.client.authn.ServiceIdentityResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CachingIdentityResolver
implements ServiceIdentityResolver {
    protected Map<String, String> cachedIdentities = new HashMap<String, String>(10);

    @Override
    public synchronized String resolveIdentity(String serviceURL) throws IOException {
        String containerAddr = this.getContainerAddress(serviceURL);
        String ret = this.cachedIdentities.get(containerAddr);
        if (ret == null) {
            throw new IOException("Identity not known");
        }
        return ret;
    }

    @Override
    public void registerIdentity(String serviceURL, String identity) {
        String containerAddr = this.getContainerAddress(serviceURL);
        this.cachedIdentities.put(containerAddr, identity);
    }

    protected String getContainerAddress(String serviceURL) {
        int end = serviceURL.indexOf("/services");
        if (end != -1) {
            return serviceURL.substring(0, end);
        }
        return serviceURL;
    }
}

