/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.BaseUASClient;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import org.apache.log4j.Logger;
import org.unigrids.x2006.x04.services.fts.FileTransferPropertiesDocument;
import org.unigrids.x2006.x04.services.fts.SizeDocument;
import org.unigrids.x2006.x04.services.fts.StatusDocument;
import org.unigrids.x2006.x04.services.fts.SummaryType;
import org.unigrids.x2006.x04.services.fts.TransferredBytesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TransferControllerClient
extends BaseUASClient {
    private static final Logger logger = Log.getLogger("unicore.client", TransferControllerClient.class);
    private long size = -1L;

    public TransferControllerClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
    }

    public TransferControllerClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(epr.getAddress().getStringValue(), epr, sec);
    }

    public TransferControllerClient(String url, EndpointReferenceType epr) throws Exception {
        this(url, epr, (IClientConfiguration)null);
    }

    public FileTransferPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return FileTransferPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public long getTransferredBytes() {
        try {
            TransferredBytesDocument rp = this.getSingleResourceProperty(TransferredBytesDocument.class);
            return rp.getTransferredBytes();
        }
        catch (Exception e) {
            Log.logException("Can't get transferred bytes information.", e, logger);
            return 0L;
        }
    }

    public long getRate() {
        try {
            return this.getResourcePropertiesDocument().getFileTransferProperties().getTransferRate();
        }
        catch (Exception e) {
            Log.logException("Can't get transfer rate information.", e, logger);
            return -1L;
        }
    }

    public synchronized long getSize() {
        if (this.size == -1L) {
            try {
                SizeDocument sd = this.getSingleResourceProperty(SizeDocument.class);
                this.size = sd.getSize();
            }
            catch (Exception ex) {
                Log.logException("Can't get size information.", ex, logger);
            }
        }
        return this.size;
    }

    public String getStatus() {
        try {
            StatusDocument status = this.getSingleResourceProperty(StatusDocument.class);
            return status.getStatus().getSummary().toString() + " [" + status.getStatus().getDescription() + "]";
        }
        catch (Exception e) {
            Log.logException("Could not get status.", e, logger);
            return "n/a (Error getting status)";
        }
    }

    public SummaryType.Enum getStatusSummary() throws Exception {
        StatusDocument status = this.getSingleResourceProperty(StatusDocument.class);
        return status.getStatus().getSummary();
    }

    public boolean isComplete() {
        try {
            return ((Object)((Object)SummaryType.DONE)).equals((Object)this.getStatusSummary());
        }
        catch (Exception e) {
            logger.error("Can't get information.", e);
            return false;
        }
    }

    public boolean hasFailed() {
        try {
            return ((Object)((Object)SummaryType.FAILED)).equals((Object)this.getStatusSummary());
        }
        catch (Exception ex) {
            return true;
        }
    }
}

