/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.fts.FiletransferOptions;
import de.fzj.unicore.uas.fts.ProgressListener;
import eu.unicore.util.Log;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;

public class ReliableFileTransferClient
implements FiletransferOptions.IMonitorable {
    private static final Logger logger = Log.getLogger("unicore.services", ReliableFileTransferClient.class);
    private final FiletransferOptions.SupportsPartialRead ftc;
    private final Store storage;
    private volatile boolean aborted = false;
    private int errorCount = 0;
    private int maxErrors = 42;
    private boolean ok = true;
    private String statusMessage = "OK.";
    private ProgressListener<Long> listener;

    public ReliableFileTransferClient(FiletransferOptions.SupportsPartialRead ftc, Store storage) {
        this.ftc = ftc;
        this.storage = storage;
    }

    @Override
    public void setProgressListener(ProgressListener<Long> listener) {
        this.listener = listener;
    }

    protected void checkCancelled() throws ProgressListener.CancelledException {
        if (this.listener != null && this.listener.isCancelled()) {
            throw new ProgressListener.CancelledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws ProgressListener.CancelledException {
        FiletransferOptions.SupportsPartialRead srr = this.ftc;
        this.statusMessage = "RUNNING";
        while (!this.aborted) {
            try {
                List<Chunk> chunks = this.storage.getChunks();
                if (chunks.size() == 0) {
                    this.storage.finish();
                    this.statusMessage = "FINISHED";
                    this.ok = true;
                    break;
                }
                for (Chunk chunk : chunks) {
                    this.checkCancelled();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Downloading chunk : " + chunk);
                    }
                    OutputStream os = chunk.newOutputStream();
                    try {
                        long read = srr.readPartial(chunk.getOffset(), chunk.getLength(), os);
                        this.storage.ack(chunk);
                        if (this.listener == null) continue;
                        this.listener.notifyProgress(read);
                    }
                    finally {
                        os.close();
                    }
                }
            }
            catch (ProgressListener.CancelledException ce) {
                throw ce;
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug(Log.createFaultMessage("Error", ex));
                }
                ++this.errorCount;
                if (this.errorCount <= this.maxErrors) continue;
                this.statusMessage = "FAILED: max error count of <" + this.maxErrors + "> exceeded";
                this.ok = false;
                break;
            }
        }
    }

    public void abort() {
        this.aborted = true;
    }

    public boolean ok() {
        return this.ok;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public static interface Chunk {
        public OutputStream newOutputStream() throws Exception;

        public long getOffset();

        public long getLength();

        public int getIndex();

        public void setOffset(long var1);

        public void setLength(long var1);

        public String getPath();

        public void setAppend(boolean var1);
    }

    public static interface Store {
        public List<Chunk> getChunks() throws Exception;

        public void ack(Chunk var1) throws Exception;

        public void finish() throws Exception;
    }
}

