/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.util.stax.WrappedTextNodeStreamReader;

public class WrappedTextNodeOMDataSourceFromReader
extends OMDataSourceExtBase {
    private final QName wrapperElementName;
    private final Reader reader;

    public WrappedTextNodeOMDataSourceFromReader(QName wrapperElementName, Reader reader) {
        this.wrapperElementName = wrapperElementName;
        this.reader = reader;
    }

    @Override
    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter xmlWriter = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter(writer));
        xmlWriter.setOutputFormat(format);
        this.serialize(xmlWriter);
        xmlWriter.flush();
    }

    @Override
    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        StreamingOMSerializer serializer = new StreamingOMSerializer();
        serializer.serialize(this.getReader(), xmlWriter);
    }

    @Override
    public XMLStreamReader getReader() throws XMLStreamException {
        return new WrappedTextNodeStreamReader(this.wrapperElementName, this.reader);
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public boolean isDestructiveRead() {
        return true;
    }

    @Override
    public boolean isDestructiveWrite() {
        return true;
    }

    @Override
    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public OMDataSourceExt copy() {
        throw new UnsupportedOperationException();
    }
}

