/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.api.service.messaging;

import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.model.dbevent.DBEventMessage;
import org.apache.airavata.model.dbevent.DBEventPublisherContext;
import org.apache.airavata.model.error.DuplicateEntryException;
import org.apache.airavata.model.user.UserProfile;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.registry.api.RegistryService;
import org.apache.airavata.registry.api.client.RegistryServiceClientFactory;
import org.apache.airavata.registry.api.exception.RegistryServiceException;
import org.apache.airavata.registry.api.service.messaging.RegistryServiceDBEventMessagingFactory;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryServiceDBEventHandler
implements MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(RegistryServiceDBEventHandler.class);
    private final RegistryService.Client registryClient;

    public RegistryServiceDBEventHandler() throws ApplicationSettingsException, RegistryServiceException {
        int serverPort = Integer.parseInt(ServerSettings.getSetting((String)"regserver.server.port", (String)"8960"));
        String serverHost = ServerSettings.getSetting((String)"regserver.server.host");
        this.registryClient = RegistryServiceClientFactory.createRegistryClient((String)serverHost, (int)serverPort);
    }

    public void onMessage(MessageContext messageContext) {
        logger.info("RegistryServiceDBEventHandler | Received a new message!");
        try {
            byte[] bytes = ThriftUtils.serializeThriftObject((TBase)messageContext.getEvent());
            DBEventMessage dbEventMessage = new DBEventMessage();
            ThriftUtils.createThriftFromBytes((byte[])bytes, (TBase)dbEventMessage);
            logger.info("RegistryService received db-event-message from publisher: " + dbEventMessage.getPublisherService());
            DBEventPublisherContext publisherContext = dbEventMessage.getMessageContext().getPublisher().getPublisherContext();
            logger.info("RegistryService, Replicated Entity: " + publisherContext.getEntityType());
            try {
                block2 : switch (publisherContext.getEntityType()) {
                    case TENANT: {
                        Gateway gateway = new Gateway();
                        ThriftUtils.createThriftFromBytes((byte[])publisherContext.getEntityDataModel(), (TBase)gateway);
                        switch (publisherContext.getCrudType()) {
                            case CREATE: {
                                logger.info("Replicating addGateway in Registry.");
                                this.registryClient.addGateway(gateway);
                                logger.info("addGateway Replication Success!");
                                break block2;
                            }
                            case UPDATE: {
                                logger.info("Replicating updateGateway in Registry.");
                                if (!this.registryClient.isGatewayExist(gateway.getGatewayId())) {
                                    logger.info("Gateway doesn't exist so adding instead of updating.");
                                    this.registryClient.addGateway(gateway);
                                } else {
                                    this.registryClient.updateGateway(gateway.getGatewayId(), gateway);
                                }
                                logger.info("updateGateway Replication Success!");
                                break block2;
                            }
                            case DELETE: {
                                logger.info("Replicating deleteGateway in Registry.");
                                this.registryClient.deleteGateway(gateway.getGatewayId());
                                logger.info("deleteGateway Replication Success!");
                            }
                        }
                        break;
                    }
                    case USER_PROFILE: {
                        UserProfile userProfile = new UserProfile();
                        ThriftUtils.createThriftFromBytes((byte[])publisherContext.getEntityDataModel(), (TBase)userProfile);
                        switch (publisherContext.getCrudType()) {
                            case CREATE: {
                                logger.info("Replicating addUser in Registry.");
                                this.registryClient.addUser(userProfile);
                                logger.info("addUser Replication Success!");
                                break block2;
                            }
                            case UPDATE: {
                                logger.info("Replicating updateGateway in Registry.");
                                break block2;
                            }
                            case DELETE: {
                                logger.info("Replicating deleteGateway in Registry.");
                            }
                        }
                        break;
                    }
                    default: {
                        logger.error("Handler not defined for Entity: " + publisherContext.getEntityType());
                        break;
                    }
                }
            }
            catch (DuplicateEntryException ex) {
                logger.warn("DuplicateEntryException while consuming db-event message, ex: " + ex.getMessage(), (Throwable)ex);
            }
            logger.info("RegistryServiceDBEventHandler | Sending ack. Message Delivery Tag: " + messageContext.getDeliveryTag());
            RegistryServiceDBEventMessagingFactory.getDBEventSubscriber().sendAck(messageContext.getDeliveryTag());
        }
        catch (TException ex) {
            logger.error("Error processing message: " + (Object)((Object)ex), (Throwable)ex);
        }
        catch (ApplicationSettingsException ex) {
            logger.error("Error fetching application settings: " + (Object)((Object)ex), (Throwable)ex);
        }
        catch (AiravataException ex) {
            logger.error("Error sending ack. Message Delivery Tag: " + messageContext.getDeliveryTag(), (Throwable)ex);
        }
    }
}

