/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.db.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.sharing.registry.db.utils.DatabaseCreator;
import org.apache.airavata.sharing.registry.db.utils.JdbcStorage;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.derby.drda.NetworkServerControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAUtils {
    private static final Logger logger = LoggerFactory.getLogger(JPAUtils.class);
    public static final String PERSISTENCE_UNIT_NAME = "airavata-sharing-registry";
    public static final String SHARING_REG_JDBC_DRIVER = "sharingcatalog.jdbc.driver";
    public static final String SHARING_REG_JDBC_URL = "sharingcatalog.jdbc.url";
    public static final String SHARING_REG_JDBC_USER = "sharingcatalog.jdbc.user";
    public static final String SHARING_REG_JDBC_PWD = "sharingcatalog.jdbc.password";
    public static final String SHARING_REG_VALIDATION_QUERY = "sharingcatalog.validationQuery";
    public static final String JPA_CACHE_SIZE = "jpa.cache.size";
    public static final String JPA_CACHE_ENABLED = "cache.enable";
    public static final String CONFIGURATION = "CONFIGURATION";
    public static final String START_DERBY_ENABLE = "start.derby.server.mode";
    public static final String DERBY_SERVER_MODE_SYS_PROPERTY = "derby.drda.startNetworkServer";
    private static NetworkServerControl server;
    private static JdbcStorage db;
    private static String jdbcURl;
    private static String jdbcDriver;
    private static String jdbcUser;
    private static String jdbcPassword;
    @PersistenceUnit(unitName="airavata-sharing-registry")
    protected static EntityManagerFactory factory;
    @PersistenceContext(unitName="airavata-sharing-registry")
    private static EntityManager entityManager;

    public static synchronized EntityManager getEntityManager() throws SharingRegistryException {
        if (factory == null) {
            String connectionProperties = "DriverClassName=" + JPAUtils.readServerProperties(SHARING_REG_JDBC_DRIVER) + ",Url=" + JPAUtils.readServerProperties(SHARING_REG_JDBC_URL) + "?autoReconnect=true,Username=" + JPAUtils.readServerProperties(SHARING_REG_JDBC_USER) + ",Password=" + JPAUtils.readServerProperties(SHARING_REG_JDBC_PWD) + ",validationQuery=" + JPAUtils.readServerProperties(SHARING_REG_VALIDATION_QUERY);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("openjpa.ConnectionDriverName", "org.apache.commons.dbcp.BasicDataSource");
            properties.put("openjpa.ConnectionProperties", connectionProperties);
            properties.put("openjpa.DynamicEnhancementAgent", "true");
            properties.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
            properties.put("openjpa.RemoteCommitProvider", "sjvm");
            properties.put("openjpa.Log", "DefaultLevel=INFO, Runtime=INFO, Tool=INFO, SQL=INFO");
            properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
            properties.put("openjpa.jdbc.QuerySQLCache", "false");
            properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72, PrintParameters=true, MaxActive=10, MaxIdle=5, MinIdle=2, MaxWait=31536000,  autoReconnect=true");
            properties.put("openjpa.RuntimeUnenhancedClasses", "warn");
            factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, properties);
        }
        entityManager = factory.createEntityManager();
        return entityManager;
    }

    public static void initializeDB() throws SharingRegistryException {
        jdbcDriver = JPAUtils.readServerProperties(SHARING_REG_JDBC_DRIVER);
        jdbcURl = JPAUtils.readServerProperties(SHARING_REG_JDBC_URL);
        jdbcUser = JPAUtils.readServerProperties(SHARING_REG_JDBC_USER);
        jdbcPassword = JPAUtils.readServerProperties(SHARING_REG_JDBC_PWD);
        if (JPAUtils.getDBType(jdbcURl = jdbcURl + "?user=" + jdbcUser + "&password=" + jdbcPassword).equals("derby") && JPAUtils.isDerbyStartEnabled()) {
            JPAUtils.startDerbyInServerMode();
        }
        db = new JdbcStorage(10, 50, jdbcURl, jdbcDriver, true);
        Connection conn = null;
        try {
            conn = db.connect();
            if (!DatabaseCreator.isDatabaseStructureCreated(CONFIGURATION, conn)) {
                DatabaseCreator.createRegistryDatabase("database_scripts/sharing-registry", conn);
                logger.info("New Database created for Sharing Catalog !!! ");
            } else {
                logger.info("Database already created for Sharing Catalog !!!");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Database failure", e);
        }
        finally {
            db.closeConnection(conn);
            try {
                if (conn != null) {
                    if (!conn.getAutoCommit()) {
                        conn.commit();
                    }
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("Error while closing database connection...", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static String getDBType(String jdbcUrl) {
        try {
            String cleanURI = jdbcUrl.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getScheme();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isDerbyStartEnabled() {
        try {
            String s = ServerSettings.getSetting((String)START_DERBY_ENABLE);
            if ("true".equals(s)) {
                return true;
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error("Unable to read airavata server properties", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return false;
    }

    public static void startDerbyInServerMode() {
        try {
            System.setProperty(DERBY_SERVER_MODE_SYS_PROPERTY, "true");
            server = new NetworkServerControl(InetAddress.getByName("0.0.0.0"), JPAUtils.getPort(jdbcURl), jdbcUser, jdbcPassword);
            PrintWriter consoleWriter = new PrintWriter(System.out, true);
            server.start(consoleWriter);
        }
        catch (IOException e) {
            logger.error("Unable to start Apache derby in the server mode! Check whether specified port is available");
        }
        catch (Exception e) {
            logger.error("Unable to start Apache derby in the server mode! Check whether specified port is available");
        }
    }

    public static void stopDerbyInServerMode() {
        System.setProperty(DERBY_SERVER_MODE_SYS_PROPERTY, "false");
        if (server != null) {
            try {
                server.shutdown();
            }
            catch (Exception e) {
                logger.error("Error when stopping the derby server : " + e.getLocalizedMessage());
            }
        }
    }

    public static int getPort(String jdbcURL) {
        try {
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getPort();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static String readServerProperties(String propertyName) throws SharingRegistryException {
        try {
            return ServerSettings.getSetting((String)propertyName);
        }
        catch (ApplicationSettingsException e) {
            logger.error("Unable to read airavata-server.properties...", (Throwable)e);
            throw new SharingRegistryException("Unable to read airavata-server.properties...");
        }
    }
}

