/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.jaxws.description.builder.ActionAnnot;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderUtils;
import org.apache.axis2.jaxws.description.builder.HandlerChainAnnot;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.RequestWrapperAnnot;
import org.apache.axis2.jaxws.description.builder.ResponseWrapperAnnot;
import org.apache.axis2.jaxws.description.builder.SoapBindingAnnot;
import org.apache.axis2.jaxws.description.builder.TMAnnotationComposite;
import org.apache.axis2.jaxws.description.builder.TMFAnnotationComposite;
import org.apache.axis2.jaxws.description.builder.WebEndpointAnnot;
import org.apache.axis2.jaxws.description.builder.WebMethodAnnot;
import org.apache.axis2.jaxws.description.builder.WebResultAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescriptionComposite
implements TMAnnotationComposite,
TMFAnnotationComposite {
    private String methodName;
    private String returnType;
    private String[] exceptions;
    private String declaringClass;
    private boolean staticModifier = false;
    private boolean finalModifier = false;
    boolean oneWayAnnotated;
    private boolean isListType = false;
    private WebMethodAnnot webMethodAnnot;
    private WebResultAnnot webResultAnnot;
    private HandlerChainAnnot handlerChainAnnot;
    private SoapBindingAnnot soapBindingAnnot;
    private WebServiceRefAnnot webServiceRefAnnot;
    private WebEndpointAnnot webEndpointAnnot;
    private RequestWrapperAnnot requestWrapperAnnot;
    private ResponseWrapperAnnot responseWrapperAnnot;
    private List<ParameterDescriptionComposite> parameterDescriptions;
    private DescriptionBuilderComposite parentDBC;
    private ActionAnnot actionAnnot;

    public MethodDescriptionComposite() {
        this.parameterDescriptions = new ArrayList<ParameterDescriptionComposite>();
    }

    public MethodDescriptionComposite(String methodName, String returnType, WebMethodAnnot webMethodAnnot, WebResultAnnot webResultAnnot, boolean oneWayAnnotated, HandlerChainAnnot handlerChainAnnot, SoapBindingAnnot soapBindingAnnot, WebServiceRefAnnot webServiceRefAnnot, WebEndpointAnnot webEndpointAnnot, RequestWrapperAnnot requestWrapperAnnot, ResponseWrapperAnnot responseWrapperAnnot) {
        this.methodName = methodName;
        this.returnType = returnType;
        this.webMethodAnnot = webMethodAnnot;
        this.webResultAnnot = webResultAnnot;
        this.oneWayAnnotated = oneWayAnnotated;
        this.handlerChainAnnot = handlerChainAnnot;
        this.soapBindingAnnot = soapBindingAnnot;
        this.webServiceRefAnnot = webServiceRefAnnot;
        this.webEndpointAnnot = webEndpointAnnot;
        this.requestWrapperAnnot = requestWrapperAnnot;
        this.responseWrapperAnnot = responseWrapperAnnot;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Class getReturnTypeClass() {
        Class returnTypeClass = null;
        String fullReturnType = this.getReturnType();
        if (fullReturnType != null && (returnTypeClass = DescriptionBuilderUtils.getPrimitiveClass(fullReturnType)) == null) {
            String classToLoad = null;
            classToLoad = DescriptionBuilderUtils.getRawType(fullReturnType) != null ? DescriptionBuilderUtils.getRawType(fullReturnType) : fullReturnType;
            returnTypeClass = this.loadClassFromMDC(classToLoad);
        }
        return returnTypeClass;
    }

    private Class loadClassFromMDC(String classToLoad) {
        Class returnClass = null;
        ClassLoader classLoader = null;
        if (this.getDescriptionBuilderCompositeRef() != null) {
            classLoader = this.getDescriptionBuilderCompositeRef().getClassLoader();
        }
        returnClass = DescriptionBuilderUtils.loadClassFromComposite(classToLoad, classLoader);
        return returnClass;
    }

    public boolean isOneWay() {
        return this.oneWayAnnotated;
    }

    public WebEndpointAnnot getWebEndpointAnnot() {
        return this.webEndpointAnnot;
    }

    public RequestWrapperAnnot getRequestWrapperAnnot() {
        return this.requestWrapperAnnot;
    }

    public ResponseWrapperAnnot getResponseWrapperAnnot() {
        return this.responseWrapperAnnot;
    }

    public HandlerChainAnnot getHandlerChainAnnot() {
        return this.handlerChainAnnot;
    }

    public SoapBindingAnnot getSoapBindingAnnot() {
        return this.soapBindingAnnot;
    }

    public WebMethodAnnot getWebMethodAnnot() {
        return this.webMethodAnnot;
    }

    public WebResultAnnot getWebResultAnnot() {
        return this.webResultAnnot;
    }

    public WebServiceRefAnnot getWebServiceRefAnnot() {
        return this.webServiceRefAnnot;
    }

    public ActionAnnot getActionAnnot() {
        return this.actionAnnot;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public Class[] getExceptionTypes() {
        Class[] classes = new Class[]{};
        return classes;
    }

    public String getDeclaringClass() {
        if (this.declaringClass == null && this.parentDBC != null) {
            return this.parentDBC.getClassName();
        }
        return this.declaringClass;
    }

    public DescriptionBuilderComposite getDescriptionBuilderCompositeRef() {
        return this.parentDBC;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setOneWayAnnot(boolean oneWayAnnotated) {
        this.oneWayAnnotated = oneWayAnnotated;
    }

    public void setWebEndpointAnnot(WebEndpointAnnot webEndpointAnnot) {
        this.webEndpointAnnot = webEndpointAnnot;
    }

    public void setRequestWrapperAnnot(RequestWrapperAnnot requestWrapperAnnot) {
        this.requestWrapperAnnot = requestWrapperAnnot;
    }

    public void setResponseWrapperAnnot(ResponseWrapperAnnot responseWrapperAnnot) {
        this.responseWrapperAnnot = responseWrapperAnnot;
    }

    @Override
    public void setHandlerChainAnnot(HandlerChainAnnot handlerChainAnnot) {
        this.handlerChainAnnot = handlerChainAnnot;
    }

    @Override
    public void setSoapBindingAnnot(SoapBindingAnnot soapBindingAnnot) {
        this.soapBindingAnnot = soapBindingAnnot;
    }

    public void setWebMethodAnnot(WebMethodAnnot webMethodAnnot) {
        this.webMethodAnnot = webMethodAnnot;
    }

    public void setWebResultAnnot(WebResultAnnot webResultAnnot) {
        this.webResultAnnot = webResultAnnot;
    }

    @Override
    public void setWebServiceRefAnnot(WebServiceRefAnnot webServiceRefAnnot) {
        this.webServiceRefAnnot = webServiceRefAnnot;
    }

    public void setActionAnnot(ActionAnnot actionAnnot) {
        this.actionAnnot = actionAnnot;
    }

    public void addParameterDescriptionComposite(ParameterDescriptionComposite parameterDescription) {
        this.parameterDescriptions.add(parameterDescription);
    }

    public void addParameterDescriptionComposite(ParameterDescriptionComposite parameterDescription, int index) {
        parameterDescription.setListOrder(index);
        this.parameterDescriptions.add(index, parameterDescription);
    }

    public void setParameterDescriptionCompositeList(List<ParameterDescriptionComposite> parameterDescriptionList) {
        this.parameterDescriptions = parameterDescriptionList;
    }

    public ParameterDescriptionComposite getParameterDescriptionComposite(int index) {
        return this.parameterDescriptions.get(index);
    }

    public List<ParameterDescriptionComposite> getParameterDescriptionCompositeList() {
        return this.parameterDescriptions;
    }

    public void setExceptions(String[] exceptions) {
        this.exceptions = exceptions;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public void setDescriptionBuilderCompositeRef(DescriptionBuilderComposite dbc) {
        this.parentDBC = dbc;
    }

    public boolean isStatic() {
        return this.staticModifier;
    }

    public void setStaticModifier(boolean staticModifier) {
        this.staticModifier = staticModifier;
    }

    public boolean isFinal() {
        return this.finalModifier;
    }

    public void setFinalModifier(boolean finalModifier) {
        this.finalModifier = finalModifier;
    }

    public boolean compare(Object obj) {
        if (obj instanceof MethodDescriptionComposite) {
            MethodDescriptionComposite mdc = (MethodDescriptionComposite)obj;
            if (!this.methodName.equals(mdc.getMethodName())) {
                return false;
            }
            List<ParameterDescriptionComposite> thisParamList = this.parameterDescriptions;
            List<ParameterDescriptionComposite> paramList = mdc.getParameterDescriptionCompositeList();
            if (thisParamList.size() != paramList.size()) {
                return false;
            }
            for (int i = 0; i < thisParamList.size(); ++i) {
                if (thisParamList.get(i).compare(paramList.get(i))) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public void setIsListType(boolean isListType) {
        this.isListType = isListType;
    }

    public boolean isListType() {
        return this.isListType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String newLine = "\n";
        String sameLine = "; ";
        sb.append(super.toString());
        sb.append("\n");
        sb.append("Name: " + this.methodName);
        sb.append("; ");
        sb.append("ReturnType: " + this.returnType);
        sb.append("\n");
        sb.append("Exceptions: ");
        if (this.exceptions != null) {
            for (int i = 0; i < this.exceptions.length; ++i) {
                sb.append(this.exceptions[i]);
                sb.append("; ");
            }
        }
        if (this.oneWayAnnotated) {
            sb.append("\n");
            sb.append("OneWay");
        }
        if (this.webMethodAnnot != null) {
            sb.append("\n");
            sb.append("WebMethod: ");
            sb.append(this.webMethodAnnot.toString());
        }
        if (this.requestWrapperAnnot != null) {
            sb.append("\n");
            sb.append("RequestWrapper: ");
            sb.append(this.requestWrapperAnnot.toString());
        }
        if (this.responseWrapperAnnot != null) {
            sb.append("\n");
            sb.append("ResponsetWrapper: ");
            sb.append(this.responseWrapperAnnot.toString());
        }
        if (this.soapBindingAnnot != null) {
            sb.append("\n");
            sb.append("SOAPBinding: ");
            sb.append(this.soapBindingAnnot.toString());
        }
        if (this.webEndpointAnnot != null) {
            sb.append("\n");
            sb.append("WebEndpoint: ");
            sb.append(this.webEndpointAnnot.toString());
        }
        if (this.webResultAnnot != null) {
            sb.append("\n");
            sb.append("WebResult: ");
            sb.append(this.webResultAnnot.toString());
        }
        if (this.webServiceRefAnnot != null) {
            sb.append("\n");
            sb.append("WebServiceRef: ");
            sb.append(this.webServiceRefAnnot.toString());
        }
        if (this.actionAnnot != null) {
            sb.append("\n");
            sb.append("Action: ");
            sb.append(this.actionAnnot.toString());
        }
        if (this.handlerChainAnnot != null) {
            sb.append("\n");
            sb.append("HandlerChain: ");
            sb.append(this.handlerChainAnnot.toString());
        }
        sb.append("\n");
        sb.append("Number of Parameter Descriptions: " + this.parameterDescriptions.size());
        Iterator<ParameterDescriptionComposite> pdcIter = this.parameterDescriptions.iterator();
        while (pdcIter.hasNext()) {
            sb.append("\n");
            ParameterDescriptionComposite pdc = pdcIter.next();
            sb.append(pdc.toString());
        }
        return sb.toString();
    }
}

