/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.orchestrator.cpi.impl;

import java.io.IOException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.orchestrator.core.OrchestratorConfiguration;
import org.apache.airavata.orchestrator.core.context.OrchestratorContext;
import org.apache.airavata.orchestrator.core.exception.OrchestratorException;
import org.apache.airavata.orchestrator.core.utils.OrchestratorUtils;
import org.apache.airavata.orchestrator.cpi.Orchestrator;
import org.apache.airavata.registry.core.experiment.catalog.impl.RegistryFactory;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOrchestrator
implements Orchestrator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOrchestrator.class);
    protected OrchestratorContext orchestratorContext;
    protected OrchestratorConfiguration orchestratorConfiguration;
    private String registryURL;
    private String gatewayName;
    private String airavataUserName;

    public String getRegistryURL() {
        return this.registryURL;
    }

    public void setRegistryURL(String registryURL) {
        this.registryURL = registryURL;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public String getAiravataUserName() {
        return this.airavataUserName;
    }

    public void setAiravataUserName(String airavataUserName) {
        this.airavataUserName = airavataUserName;
    }

    public AbstractOrchestrator() throws OrchestratorException {
        try {
            this.orchestratorConfiguration = OrchestratorUtils.loadOrchestratorConfiguration();
            this.setGatewayProperties();
            this.orchestratorContext = new OrchestratorContext();
            this.orchestratorContext.setOrchestratorConfiguration(this.orchestratorConfiguration);
            this.orchestratorContext.setRegistry(RegistryFactory.getRegistry());
        }
        catch (IOException e) {
            logger.error("Failed to initializing Orchestrator - Error parsing configuration files");
            OrchestratorException orchestratorException = new OrchestratorException(e);
            throw orchestratorException;
        }
        catch (ApplicationSettingsException e) {
            throw new OrchestratorException(e);
        }
        catch (RegistryException e) {
            logger.error("Failed to initializing Orchestrator - Error initializing registry");
            OrchestratorException orchestratorException = new OrchestratorException(e);
            throw orchestratorException;
        }
    }

    protected void setGatewayProperties() {
        try {
            this.setAiravataUserName(ServerSettings.getDefaultUser());
            this.setGatewayName(ServerSettings.getDefaultUserGateway());
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public OrchestratorContext getOrchestratorContext() {
        return this.orchestratorContext;
    }

    public OrchestratorConfiguration getOrchestratorConfiguration() {
        return this.orchestratorConfiguration;
    }
}

