/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;

class CreateViewNode
extends DDLStatementNode {
    private ResultColumnList resultColumns;
    private ResultSetNode queryExpression;
    private String qeText;
    private int checkOption;
    private ProviderInfo[] providerInfos;
    private ColumnInfo[] colInfos;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;

    CreateViewNode(TableName tableName, ResultColumnList resultColumnList, ResultSetNode resultSetNode, int n, String string, OrderByList orderByList, ValueNode valueNode, ValueNode valueNode2, boolean bl, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.resultColumns = resultColumnList;
        this.queryExpression = resultSetNode;
        this.checkOption = n;
        this.qeText = string.trim();
        this.orderByList = orderByList;
        this.offset = valueNode;
        this.fetchFirst = valueNode2;
        this.hasJDBClimitClause = bl;
        this.implicitCreateSchema = true;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return "CREATE VIEW";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    public void bindStatement() throws StandardException {
        String string;
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        this.providerInfos = this.bindViewDefinition(dataDictionary, compilerContext, this.getLanguageConnectionContext(), this.getOptimizerFactory(), this.queryExpression, this.getContextManager());
        ResultColumnList resultColumnList = this.queryExpression.getResultColumns();
        if (this.resultColumns != null) {
            if (this.resultColumns.size() != resultColumnList.visibleSize()) {
                throw StandardException.newException("42X56", this.getFullName());
            }
            resultColumnList.copyResultColumnNames(this.resultColumns);
        }
        if ((string = resultColumnList.verifyUniqueNames(this.resultColumns == null)) != null) {
            throw StandardException.newException("42Y13", string);
        }
        if (this.queryExpression.getResultColumns().size() > 5000) {
            throw StandardException.newException("54011", String.valueOf(this.queryExpression.getResultColumns().size()), this.getRelativeName(), String.valueOf(5000));
        }
        this.colInfos = new ColumnInfo[this.queryExpression.getResultColumns().visibleSize()];
        this.genColumnInfos(this.colInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo[] bindViewDefinition(DataDictionary dataDictionary, CompilerContext compilerContext, LanguageConnectionContext languageConnectionContext, OptimizerFactory optimizerFactory, ResultSetNode resultSetNode, ContextManager contextManager) throws StandardException {
        FromList fromList = new FromList(optimizerFactory.doJoinOrderOptimization(), contextManager);
        ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
        ProviderList providerList2 = new ProviderList();
        try {
            compilerContext.setCurrentAuxiliaryProviderList(providerList2);
            compilerContext.pushCurrentPrivType(0);
            resultSetNode = resultSetNode.bindNonVTITables(dataDictionary, fromList);
            resultSetNode = resultSetNode.bindVTITables(fromList);
            resultSetNode.bindExpressions(fromList);
            if (resultSetNode instanceof SelectNode && resultSetNode.referencesSessionSchema()) {
                throw StandardException.newException("XCL51.S", new Object[0]);
            }
            resultSetNode.bindResultColumns(fromList);
            resultSetNode.bindUntypedNullsToResultColumns(null);
        }
        finally {
            compilerContext.popCurrentPrivType();
            compilerContext.setCurrentAuxiliaryProviderList(providerList);
        }
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        ProviderInfo[] providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList2);
        dependencyManager.clearColumnInfoInProviders(providerList2);
        return providerInfoArray;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.queryExpression.referencesSessionSchema();
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getCreateViewConstantAction(this.getSchemaDescriptor().getSchemaName(), this.getRelativeName(), 2, this.qeText, this.checkOption, this.colInfos, this.providerInfos, null);
    }

    private void genColumnInfos(ColumnInfo[] columnInfoArray) {
        ResultColumnList resultColumnList = this.queryExpression.getResultColumns();
        for (int i = 0; i < columnInfoArray.length; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            columnInfoArray[i] = new ColumnInfo(resultColumn.getName(), resultColumn.getType(), null, null, null, null, null, 0, 0L, 0L, 0L, 0L);
        }
    }

    ResultSetNode getParsedQueryExpression() {
        return this.queryExpression;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.queryExpression != null) {
            this.queryExpression = (ResultSetNode)this.queryExpression.accept(visitor);
        }
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getFetchFirst() {
        return this.fetchFirst;
    }

    public boolean hasJDBClimitClause() {
        return this.hasJDBClimitClause;
    }
}

