/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.api.server.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.airavata.accountprovisioning.ConfigParam;
import org.apache.airavata.accountprovisioning.SSHAccountManager;
import org.apache.airavata.accountprovisioning.SSHAccountProvisionerFactory;
import org.apache.airavata.accountprovisioning.SSHAccountProvisionerProvider;
import org.apache.airavata.api.Airavata;
import org.apache.airavata.api.server.util.ThriftClientPool;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.client.CredentialStoreClientFactory;
import org.apache.airavata.credential.store.cpi.CredentialStoreService;
import org.apache.airavata.credential.store.exception.CredentialStoreException;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessagingFactory;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.Type;
import org.apache.airavata.model.WorkflowModel;
import org.apache.airavata.model.appcatalog.accountprovisioning.SSHAccountProvisioner;
import org.apache.airavata.model.appcatalog.accountprovisioning.SSHAccountProvisionerConfigParam;
import org.apache.airavata.model.appcatalog.accountprovisioning.SSHAccountProvisionerConfigParamType;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile;
import org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference;
import org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.credential.store.CredentialOwnerType;
import org.apache.airavata.model.credential.store.CredentialSummary;
import org.apache.airavata.model.credential.store.PasswordCredential;
import org.apache.airavata.model.credential.store.SSHCredential;
import org.apache.airavata.model.credential.store.SummaryType;
import org.apache.airavata.model.data.movement.DMType;
import org.apache.airavata.model.data.movement.GridFTPDataMovement;
import org.apache.airavata.model.data.movement.LOCALDataMovement;
import org.apache.airavata.model.data.movement.SCPDataMovement;
import org.apache.airavata.model.data.movement.UnicoreDataMovement;
import org.apache.airavata.model.data.replica.DataProductModel;
import org.apache.airavata.model.data.replica.DataReplicaLocationModel;
import org.apache.airavata.model.error.AiravataClientException;
import org.apache.airavata.model.error.AiravataErrorType;
import org.apache.airavata.model.error.AiravataSystemException;
import org.apache.airavata.model.error.AuthorizationException;
import org.apache.airavata.model.error.ExperimentNotFoundException;
import org.apache.airavata.model.error.InvalidRequestException;
import org.apache.airavata.model.error.ProjectNotFoundException;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.ExperimentSearchFields;
import org.apache.airavata.model.experiment.ExperimentStatistics;
import org.apache.airavata.model.experiment.ExperimentSummaryModel;
import org.apache.airavata.model.experiment.ProjectSearchFields;
import org.apache.airavata.model.experiment.UserConfigurationDataModel;
import org.apache.airavata.model.group.GroupModel;
import org.apache.airavata.model.group.ResourcePermissionType;
import org.apache.airavata.model.group.ResourceType;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.messaging.event.ExperimentStatusChangeEvent;
import org.apache.airavata.model.messaging.event.ExperimentSubmitEvent;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.model.status.ExperimentState;
import org.apache.airavata.model.status.ExperimentStatus;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.QueueStatusModel;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.Notification;
import org.apache.airavata.model.workspace.Project;
import org.apache.airavata.registry.api.RegistryService;
import org.apache.airavata.registry.api.client.RegistryServiceClientFactory;
import org.apache.airavata.registry.api.exception.RegistryServiceException;
import org.apache.airavata.service.security.interceptor.SecurityCheck;
import org.apache.airavata.sharing.registry.client.SharingRegistryServiceClientFactory;
import org.apache.airavata.sharing.registry.models.Domain;
import org.apache.airavata.sharing.registry.models.Entity;
import org.apache.airavata.sharing.registry.models.EntitySearchField;
import org.apache.airavata.sharing.registry.models.EntityType;
import org.apache.airavata.sharing.registry.models.GroupType;
import org.apache.airavata.sharing.registry.models.PermissionType;
import org.apache.airavata.sharing.registry.models.SearchCondition;
import org.apache.airavata.sharing.registry.models.SearchCriteria;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.airavata.sharing.registry.models.User;
import org.apache.airavata.sharing.registry.models.UserGroup;
import org.apache.airavata.sharing.registry.service.cpi.SharingRegistryService;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiravataServerHandler
implements Airavata.Iface {
    private static final Logger logger = LoggerFactory.getLogger(AiravataServerHandler.class);
    private Publisher statusPublisher;
    private Publisher experimentPublisher;
    private ThriftClientPool<SharingRegistryService.Client> sharingClientPool;
    private ThriftClientPool<RegistryService.Client> registryClientPool;
    private ThriftClientPool<CredentialStoreService.Client> csClientPool;

    public AiravataServerHandler() {
        try {
            this.statusPublisher = MessagingFactory.getPublisher((Type)Type.STATUS);
            this.experimentPublisher = MessagingFactory.getPublisher((Type)Type.EXPERIMENT_LAUNCH);
            GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
            poolConfig.maxActive = 100;
            poolConfig.minIdle = 5;
            poolConfig.whenExhaustedAction = 1;
            poolConfig.testOnBorrow = true;
            poolConfig.testWhileIdle = true;
            poolConfig.numTestsPerEvictionRun = 10;
            poolConfig.maxWait = 3000L;
            this.sharingClientPool = new ThriftClientPool<SharingRegistryService.Client>(tProtocol -> new SharingRegistryService.Client(tProtocol), poolConfig, ServerSettings.getSharingRegistryHost(), Integer.parseInt(ServerSettings.getSharingRegistryPort()));
            this.registryClientPool = new ThriftClientPool<RegistryService.Client>(tProtocol -> new RegistryService.Client(tProtocol), poolConfig, ServerSettings.getRegistryServerHost(), Integer.parseInt(ServerSettings.getRegistryServerPort()));
            this.csClientPool = new ThriftClientPool<CredentialStoreService.Client>(tProtocol -> new CredentialStoreService.Client(tProtocol), poolConfig, ServerSettings.getCredentialStoreServerHost(), Integer.parseInt(ServerSettings.getCredentialStoreServerPort()));
            this.initSharingRegistry();
            this.postInitDefaultGateway();
        }
        catch (ApplicationSettingsException e) {
            logger.error("Error occured while reading airavata-server properties..", (Throwable)e);
        }
        catch (AiravataException e) {
            logger.error("Error occured while reading airavata-server properties..", (Throwable)e);
        }
        catch (TException e) {
            logger.error("Error occured while reading airavata-server properties..", (Throwable)e);
        }
    }

    private void postInitDefaultGateway() {
        block5: {
            RegistryService.Client registryClient = this.registryClientPool.getResource();
            try {
                String token;
                GatewayResourceProfile gatewayResourceProfile;
                block6: {
                    gatewayResourceProfile = registryClient.getGatewayResourceProfile(ServerSettings.getDefaultUserGateway());
                    if (gatewayResourceProfile == null || gatewayResourceProfile.getCredentialStoreToken() != null) break block5;
                    logger.debug("Starting to add the password credential for default gateway : " + ServerSettings.getDefaultUserGateway());
                    PasswordCredential passwordCredential = new PasswordCredential();
                    passwordCredential.setPortalUserName(ServerSettings.getDefaultUser());
                    passwordCredential.setGatewayId(ServerSettings.getDefaultUserGateway());
                    passwordCredential.setLoginUserName(ServerSettings.getDefaultUser());
                    passwordCredential.setPassword(ServerSettings.getDefaultUserPassword());
                    passwordCredential.setDescription("Credentials for default gateway");
                    CredentialStoreService.Client csClient = this.csClientPool.getResource();
                    token = null;
                    try {
                        logger.info("Creating password credential for default gateway");
                        token = csClient.addPasswordCredential(passwordCredential);
                        this.csClientPool.returnResource(csClient);
                    }
                    catch (Exception ex) {
                        logger.error("Failed to create the password credential for the default gateway : " + ServerSettings.getDefaultUserGateway(), (Throwable)ex);
                        if (csClient == null) break block6;
                        this.csClientPool.returnBrokenResource(csClient);
                    }
                }
                if (token != null) {
                    logger.debug("Adding password credential token " + token + " to the default gateway : " + ServerSettings.getDefaultUserGateway());
                    gatewayResourceProfile.setIdentityServerPwdCredToken(token);
                    registryClient.updateGatewayResourceProfile(ServerSettings.getDefaultUserGateway(), gatewayResourceProfile);
                }
                this.registryClientPool.returnResource(registryClient);
            }
            catch (Exception e) {
                logger.error("Failed to add the password credentials for the default gateway", (Throwable)e);
                if (registryClient == null) break block5;
                this.registryClientPool.returnBrokenResource(registryClient);
            }
        }
    }

    private void initSharingRegistry() throws ApplicationSettingsException, TException {
        SharingRegistryService.Client client = this.sharingClientPool.getResource();
        try {
            if (!client.isDomainExists(ServerSettings.getDefaultUserGateway())) {
                Domain domain = new Domain();
                domain.setDomainId(ServerSettings.getDefaultUserGateway());
                domain.setName(ServerSettings.getDefaultUserGateway());
                domain.setDescription("Domain entry for " + domain.name);
                client.createDomain(domain);
                User user = new User();
                user.setDomainId(domain.domainId);
                user.setUserId(ServerSettings.getDefaultUser() + "@" + ServerSettings.getDefaultUserGateway());
                user.setUserName(ServerSettings.getDefaultUser());
                client.createUser(user);
                EntityType entityType = new EntityType();
                entityType.setEntityTypeId(domain.domainId + ":PROJECT");
                entityType.setDomainId(domain.domainId);
                entityType.setName("PROJECT");
                entityType.setDescription("Project entity type");
                client.createEntityType(entityType);
                entityType = new EntityType();
                entityType.setEntityTypeId(domain.domainId + ":EXPERIMENT");
                entityType.setDomainId(domain.domainId);
                entityType.setName("EXPERIMENT");
                entityType.setDescription("Experiment entity type");
                client.createEntityType(entityType);
                entityType = new EntityType();
                entityType.setEntityTypeId(domain.domainId + ":FILE");
                entityType.setDomainId(domain.domainId);
                entityType.setName("FILE");
                entityType.setDescription("File entity type");
                client.createEntityType(entityType);
                PermissionType permissionType = new PermissionType();
                permissionType.setPermissionTypeId(domain.domainId + ":READ");
                permissionType.setDomainId(domain.domainId);
                permissionType.setName("READ");
                permissionType.setDescription("Read permission type");
                client.createPermissionType(permissionType);
                permissionType = new PermissionType();
                permissionType.setPermissionTypeId(domain.domainId + ":WRITE");
                permissionType.setDomainId(domain.domainId);
                permissionType.setName("WRITE");
                permissionType.setDescription("Write permission type");
                client.createPermissionType(permissionType);
            }
            this.sharingClientPool.returnResource(client);
        }
        catch (Exception ex) {
            this.sharingClientPool.returnBrokenResource(client);
            throw ex;
        }
    }

    @SecurityCheck
    public String getAPIVersion(AuthzToken authzToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        return "0.17.0";
    }

    public boolean isUserExists(AuthzToken authzToken, String gatewayId, String userName) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client client = this.registryClientPool.getResource();
        try {
            boolean isExists = client.isUserExists(gatewayId, userName);
            this.registryClientPool.returnResource(client);
            return isExists;
        }
        catch (Exception e) {
            logger.error("Error while verifying user", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while verifying user. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(client);
            throw exception;
        }
    }

    @SecurityCheck
    public String addGateway(AuthzToken authzToken, Gateway gateway) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        RegistryService.Client registryClient = this.registryClientPool.getResource();
        try {
            String gatewayId = registryClient.addGateway(gateway);
            Domain domain = new Domain();
            domain.setDomainId(gateway.getGatewayId());
            domain.setName(gateway.getGatewayName());
            domain.setDescription("Domain entry for " + domain.name);
            sharingClient.createDomain(domain);
            EntityType entityType = new EntityType();
            entityType.setEntityTypeId(domain.domainId + ":PROJECT");
            entityType.setDomainId(domain.domainId);
            entityType.setName("PROJECT");
            entityType.setDescription("Project entity type");
            sharingClient.createEntityType(entityType);
            entityType = new EntityType();
            entityType.setEntityTypeId(domain.domainId + ":EXPERIMENT");
            entityType.setDomainId(domain.domainId);
            entityType.setName("EXPERIMENT");
            entityType.setDescription("Experiment entity type");
            sharingClient.createEntityType(entityType);
            entityType = new EntityType();
            entityType.setEntityTypeId(domain.domainId + ":FILE");
            entityType.setDomainId(domain.domainId);
            entityType.setName("FILE");
            entityType.setDescription("File entity type");
            sharingClient.createEntityType(entityType);
            PermissionType permissionType = new PermissionType();
            permissionType.setPermissionTypeId(domain.domainId + ":READ");
            permissionType.setDomainId(domain.domainId);
            permissionType.setName("READ");
            permissionType.setDescription("Read permission type");
            sharingClient.createPermissionType(permissionType);
            permissionType = new PermissionType();
            permissionType.setPermissionTypeId(domain.domainId + ":WRITE");
            permissionType.setDomainId(domain.domainId);
            permissionType.setName("WRITE");
            permissionType.setDescription("Write permission type");
            sharingClient.createPermissionType(permissionType);
            this.registryClientPool.returnResource(registryClient);
            this.sharingClientPool.returnResource(sharingClient);
            return gatewayId;
        }
        catch (Exception e) {
            logger.error("Error while adding gateway", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding gateway. More info : " + e.getMessage());
            this.sharingClientPool.returnBrokenResource(sharingClient);
            this.registryClientPool.returnBrokenResource(registryClient);
            throw exception;
        }
    }

    public List<String> getAllUsersInGateway(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllUsersInGateway(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving users", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving users. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateGateway(AuthzToken authzToken, String gatewayId, Gateway updatedGateway) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateGateway(gatewayId, updatedGateway);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while updating the gateway", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating the gateway. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public Gateway getGateway(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            Gateway result = regClient.getGateway(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while getting the gateway", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while getting the gateway. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteGateway(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteGateway(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while deleting the gateway", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting the gateway. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<Gateway> getAllGateways(AuthzToken authzToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllGateways();
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while getting all the gateways", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while getting all the gateways. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean isGatewayExist(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.isGatewayExist(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while getting gateway", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while getting gateway. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String createNotification(AuthzToken authzToken, Notification notification) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.createNotification(notification);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while creating notification", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while creating notification. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateNotification(AuthzToken authzToken, Notification notification) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateNotification(notification);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while updating notification", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while getting gateway. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteNotification(AuthzToken authzToken, String gatewayId, String notificationId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteNotification(gatewayId, notificationId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while deleting notification", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting notification. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    public Notification getNotification(AuthzToken authzToken, String gatewayId, String notificationId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            Notification result = regClient.getNotification(gatewayId, notificationId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving notification", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retreiving notification. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    public List<Notification> getAllNotifications(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllNotifications(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while getting all notifications", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while getting all notifications. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String generateAndRegisterSSHKeys(AuthzToken authzToken, String gatewayId, String userName, String description, CredentialOwnerType credentialOwnerType) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        try {
            SSHCredential sshCredential = new SSHCredential();
            sshCredential.setUsername(userName);
            sshCredential.setGatewayId(gatewayId);
            sshCredential.setDescription(description);
            if (credentialOwnerType != null) {
                sshCredential.setCredentialOwnerType(credentialOwnerType);
            }
            String key = csClient.addSSHCredential(sshCredential);
            logger.debug("Airavata generated SSH keys for gateway : " + gatewayId + " and for user : " + userName);
            this.csClientPool.returnResource(csClient);
            return key;
        }
        catch (Exception e) {
            logger.error("Error occurred while registering SSH Credential", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while registering SSH Credential. More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerPwdCredential(AuthzToken authzToken, String gatewayId, String portalUserName, String loginUserName, String password, String description) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        try {
            PasswordCredential pwdCredential = new PasswordCredential();
            pwdCredential.setPortalUserName(portalUserName);
            pwdCredential.setLoginUserName(loginUserName);
            pwdCredential.setPassword(password);
            pwdCredential.setDescription(description);
            pwdCredential.setGatewayId(gatewayId);
            String key = csClient.addPasswordCredential(pwdCredential);
            logger.debug("Airavata generated PWD credential for gateway : " + gatewayId + " and for user : " + loginUserName);
            this.csClientPool.returnResource(csClient);
            return key;
        }
        catch (Exception e) {
            logger.error("Error occurred while registering PWD Credential", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while registering PWD Credential. More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String getSSHPubKey(AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        try {
            SSHCredential sshCredential = csClient.getSSHCredential(airavataCredStoreToken, gatewayId);
            logger.debug("Airavata retrieved SSH pub key for gateway id : " + gatewayId + " and for token : " + airavataCredStoreToken);
            this.csClientPool.returnResource(csClient);
            return sshCredential.getPublicKey();
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving SSH credential", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while retrieving SSH credential. More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
    }

    @SecurityCheck
    public Map<String, String> getAllGatewaySSHPubKeys(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        try {
            Map allSSHKeysForGateway = csClient.getAllSSHKeysForGateway(gatewayId);
            logger.debug("Airavata retrieved all SSH pub keys for gateway Id : " + gatewayId);
            this.csClientPool.returnResource(csClient);
            return allSSHKeysForGateway;
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving SSH public keys for gateway : " + gatewayId, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while retrieving SSH public keys for gateway : " + gatewayId + ". More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<CredentialSummary> getAllCredentialSummaryForGateway(AuthzToken authzToken, SummaryType type, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        try {
            if (type.equals((Object)SummaryType.SSH)) {
                logger.debug("Airavata will retrieve all SSH pub keys summaries for gateway Id : " + gatewayId);
                List result = csClient.getAllCredentialSummaryForGateway(type, gatewayId);
                this.csClientPool.returnResource(csClient);
                return result;
            }
            logger.info("Summay Type" + type.toString() + " not supported by Airavata");
            AiravataSystemException ex = new AiravataSystemException();
            ex.setAiravataErrorType(AiravataErrorType.UNSUPPORTED_OPERATION);
            ex.setMessage("Summay Type" + type.toString() + " not supported by Airavata");
            this.csClientPool.returnResource(csClient);
            throw ex;
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving SSH public keys summaries for gateway : " + gatewayId, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while retrieving SSH public keys summaries for gateway : " + gatewayId + ". More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<CredentialSummary> getAllCredentialSummaryForUsersInGateway(AuthzToken authzToken, SummaryType type, String gatewayId, String userId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        try {
            if (type.equals((Object)SummaryType.SSH)) {
                logger.debug("Airavata will retrieve all SSH pub keys summaries for gateway Id : " + gatewayId);
                List result = csClient.getAllCredentialSummaryForUserInGateway(type, gatewayId, userId);
                this.csClientPool.returnResource(csClient);
                return result;
            }
            logger.info("Summay Type" + type.toString() + " not supported by Airavata");
            AiravataSystemException ex = new AiravataSystemException();
            ex.setAiravataErrorType(AiravataErrorType.UNSUPPORTED_OPERATION);
            ex.setMessage("Summay Type" + type.toString() + " not supported by Airavata");
            this.csClientPool.returnResource(csClient);
            throw ex;
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving SSH public keys summaries for user : " + userId, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while retrieving SSH public keys summaries for user : " + userId + ". More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
    }

    @SecurityCheck
    public Map<String, String> getAllGatewayPWDCredentials(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        try {
            Map allPwdCredentials = csClient.getAllPWDCredentialsForGateway(gatewayId);
            logger.debug("Airavata retrieved all PWD Credentials for gateway Id : " + gatewayId);
            this.csClientPool.returnResource(csClient);
            return allPwdCredentials;
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving PWD Credentials for gateway : " + gatewayId, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while retrieving PWD Credentials for gateway : " + gatewayId + ". More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteSSHPubKey(AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        try {
            logger.debug("Airavata deleted SSH pub key for gateway Id : " + gatewayId + " and with token id : " + airavataCredStoreToken);
            boolean result = csClient.deleteSSHCredential(airavataCredStoreToken, gatewayId);
            this.csClientPool.returnResource(csClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error occurred while deleting SSH credential", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while deleting SSH credential. More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deletePWDCredential(AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, TException {
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        try {
            logger.debug("Airavata deleted PWD credential for gateway Id : " + gatewayId + " and with token id : " + airavataCredStoreToken);
            boolean result = csClient.deletePWDCredential(airavataCredStoreToken, gatewayId);
            this.csClientPool.returnResource(csClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error occurred while deleting PWD credential", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while deleting PWD credential. More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String createProject(AuthzToken authzToken, String gatewayId, Project project) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            String projectId = regClient.createProject(gatewayId, project);
            if (ServerSettings.isEnableSharing().booleanValue()) {
                try {
                    Entity entity = new Entity();
                    entity.setEntityId(projectId);
                    entity.setDomainId(project.getGatewayId());
                    entity.setEntityTypeId(project.getGatewayId() + ":PROJECT");
                    entity.setOwnerId(project.getOwner() + "@" + project.getGatewayId());
                    entity.setName(project.getName());
                    entity.setDescription(project.getDescription());
                    sharingClient.createEntity(entity);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    logger.error("Rolling back project creation Proj ID : " + projectId);
                    regClient.deleteProject(projectId);
                    AiravataSystemException ase = new AiravataSystemException();
                    ase.setMessage("Failed to create entry for project in Sharing Registry");
                    throw ase;
                }
            }
            logger.debug("Airavata created project with project Id : " + projectId + " for gateway Id : " + gatewayId);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return projectId;
        }
        catch (Exception e) {
            logger.error("Error while creating the project", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while creating the project. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public void updateProject(AuthzToken authzToken, String projectId, Project updatedProject) throws InvalidRequestException, AiravataClientException, AiravataSystemException, ProjectNotFoundException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            Project existingProject = regClient.getProject(projectId);
            if (ServerSettings.isEnableSharing().booleanValue() && !((String)authzToken.getClaimsMap().get("userName")).equals(existingProject.getOwner()) || !((String)authzToken.getClaimsMap().get("gatewayID")).equals(existingProject.getGatewayId())) {
                try {
                    String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
                    String userId = (String)authzToken.getClaimsMap().get("userName");
                    if (!sharingClient.userHasAccess(gatewayId, userId + "@" + gatewayId, projectId, gatewayId + ":WRITE")) {
                        throw new AuthorizationException("User does not have permission to access this resource");
                    }
                }
                catch (Exception e) {
                    throw new AuthorizationException("User does not have permission to access this resource");
                }
            }
            if (!updatedProject.getOwner().equals(existingProject.getOwner())) {
                throw new InvalidRequestException("Owner of a project cannot be changed");
            }
            if (!updatedProject.getGatewayId().equals(existingProject.getGatewayId())) {
                throw new InvalidRequestException("Gateway ID of a project cannot be changed");
            }
            regClient.updateProject(projectId, updatedProject);
            logger.debug("Airavata updated project with project Id : " + projectId);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
        }
        catch (Exception e) {
            logger.error("Error while updating the project", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating the project. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteProject(AuthzToken authzToken, String projectId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, ProjectNotFoundException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            Project existingProject = regClient.getProject(projectId);
            if (ServerSettings.isEnableSharing().booleanValue() && !((String)authzToken.getClaimsMap().get("userName")).equals(existingProject.getOwner()) || !((String)authzToken.getClaimsMap().get("gatewayID")).equals(existingProject.getGatewayId())) {
                try {
                    String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
                    String userId = (String)authzToken.getClaimsMap().get("userName");
                    if (!sharingClient.userHasAccess(gatewayId, userId + "@" + gatewayId, projectId, gatewayId + ":WRITE")) {
                        throw new AuthorizationException("User does not have permission to access this resource");
                    }
                }
                catch (Exception e) {
                    throw new AuthorizationException("User does not have permission to access this resource");
                }
            }
            boolean ret = regClient.deleteProject(projectId);
            logger.debug("Airavata deleted project with project Id : " + projectId);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return ret;
        }
        catch (Exception e) {
            logger.error("Error while removing the project", (Throwable)e);
            ProjectNotFoundException exception = new ProjectNotFoundException();
            exception.setMessage("Error while removing the project. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    private boolean validateString(String name) {
        boolean valid = true;
        if (name == null || name.equals("") || name.trim().length() == 0) {
            valid = false;
        }
        return valid;
    }

    @SecurityCheck
    public Project getProject(AuthzToken authzToken, String projectId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, ProjectNotFoundException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            Project project = regClient.getProject(projectId);
            if (((String)authzToken.getClaimsMap().get("userName")).equals(project.getOwner()) && ((String)authzToken.getClaimsMap().get("gatewayID")).equals(project.getGatewayId())) {
                this.registryClientPool.returnResource(regClient);
                this.sharingClientPool.returnResource(sharingClient);
                return project;
            }
            if (ServerSettings.isEnableSharing().booleanValue()) {
                try {
                    String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
                    String userId = (String)authzToken.getClaimsMap().get("userName");
                    if (!sharingClient.userHasAccess(gatewayId, userId + "@" + gatewayId, projectId, gatewayId + ":READ")) {
                        throw new AuthorizationException("User does not have permission to access this resource");
                    }
                    this.registryClientPool.returnResource(regClient);
                    this.sharingClientPool.returnResource(sharingClient);
                    return project;
                }
                catch (Exception e) {
                    throw new AuthorizationException("User does not have permission to access this resource");
                }
            }
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return null;
        }
        catch (Exception e) {
            logger.error("Error while retrieving the project", (Throwable)e);
            ProjectNotFoundException exception = new ProjectNotFoundException();
            exception.setMessage("Error while retrieving the project. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<Project> getUserProjects(AuthzToken authzToken, String gatewayId, String userName, int limit, int offset) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            if (ServerSettings.isEnableSharing().booleanValue()) {
                ArrayList accessibleProjectIds = new ArrayList();
                ArrayList<SearchCriteria> filters = new ArrayList<SearchCriteria>();
                SearchCriteria searchCriteria = new SearchCriteria();
                searchCriteria.setSearchField(EntitySearchField.ENTITY_TYPE_ID);
                searchCriteria.setSearchCondition(SearchCondition.EQUAL);
                searchCriteria.setValue(gatewayId + ":PROJECT");
                filters.add(searchCriteria);
                sharingClient.searchEntities((String)authzToken.getClaimsMap().get("gatewayID"), userName + "@" + gatewayId, filters, offset, limit).stream().forEach(p -> accessibleProjectIds.add(p.entityId));
                List result = regClient.searchProjects(gatewayId, userName, accessibleProjectIds, new HashMap(), limit, offset);
                this.registryClientPool.returnResource(regClient);
                this.sharingClientPool.returnResource(sharingClient);
                return result;
            }
            List result = regClient.getUserProjects(gatewayId, userName, limit, offset);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving projects", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving projects. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    public List<Project> searchProjects(AuthzToken authzToken, String gatewayId, String userName, Map<ProjectSearchFields, String> filters, int limit, int offset) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            ArrayList accessibleProjIds = new ArrayList();
            if (ServerSettings.isEnableSharing().booleanValue()) {
                ArrayList<SearchCriteria> sharingFilters = new ArrayList<SearchCriteria>();
                SearchCriteria searchCriteria = new SearchCriteria();
                searchCriteria.setSearchField(EntitySearchField.ENTITY_TYPE_ID);
                searchCriteria.setSearchCondition(SearchCondition.EQUAL);
                searchCriteria.setValue(gatewayId + ":PROJECT");
                sharingFilters.add(searchCriteria);
                sharingClient.searchEntities((String)authzToken.getClaimsMap().get("gatewayID"), userName + "@" + gatewayId, sharingFilters, 0, -1).stream().forEach(e -> accessibleProjIds.add(e.entityId));
            }
            List result = regClient.searchProjects(gatewayId, userName, accessibleProjIds, filters, limit, offset);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e2) {
            logger.error("Error while retrieving projects", (Throwable)e2);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving projects. More info : " + e2.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<ExperimentSummaryModel> searchExperiments(AuthzToken authzToken, String gatewayId, String userName, Map<ExperimentSearchFields, String> filters, int limit, int offset) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            ArrayList accessibleExpIds = new ArrayList();
            if (ServerSettings.isEnableSharing().booleanValue()) {
                ArrayList<SearchCriteria> sharingFilters = new ArrayList<SearchCriteria>();
                SearchCriteria searchCriteria = new SearchCriteria();
                searchCriteria.setSearchField(EntitySearchField.ENTITY_TYPE_ID);
                searchCriteria.setSearchCondition(SearchCondition.EQUAL);
                searchCriteria.setValue(gatewayId + ":EXPERIMENT");
                sharingFilters.add(searchCriteria);
                sharingClient.searchEntities((String)authzToken.getClaimsMap().get("gatewayID"), userName + "@" + gatewayId, sharingFilters, 0, -1).forEach(e -> accessibleExpIds.add(e.entityId));
            }
            List result = regClient.searchExperiments(gatewayId, userName, accessibleExpIds, filters, limit, offset);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e2) {
            logger.error("Error while retrieving experiments", (Throwable)e2);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving experiments. More info : " + e2.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ExperimentStatistics getExperimentStatistics(AuthzToken authzToken, String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            ExperimentStatistics result = regClient.getExperimentStatistics(gatewayId, fromTime, toTime, userName, applicationName, resourceHostName);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving experiments", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving experiments. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<ExperimentModel> getExperimentsInProject(AuthzToken authzToken, String projectId, int limit, int offset) throws InvalidRequestException, AiravataClientException, AiravataSystemException, ProjectNotFoundException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            Project project = regClient.getProject(projectId);
            if (ServerSettings.isEnableSharing().booleanValue() && !((String)authzToken.getClaimsMap().get("userName")).equals(project.getOwner()) || !((String)authzToken.getClaimsMap().get("gatewayID")).equals(project.getGatewayId())) {
                try {
                    String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
                    String userId = (String)authzToken.getClaimsMap().get("userName");
                    if (!sharingClient.userHasAccess(gatewayId, userId + "@" + gatewayId, projectId, gatewayId + ":READ")) {
                        throw new AuthorizationException("User does not have permission to access this resource");
                    }
                }
                catch (Exception e) {
                    throw new AuthorizationException("User does not have permission to access this resource");
                }
            }
            List result = regClient.getExperimentsInProject(projectId, limit, offset);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving the experiments", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving the experiments. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<ExperimentModel> getUserExperiments(AuthzToken authzToken, String gatewayId, String userName, int limit, int offset) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            List result = regClient.getUserExperiments(gatewayId, userName, limit, offset);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving the experiments", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving the experiments. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String createExperiment(AuthzToken authzToken, String gatewayId, ExperimentModel experiment) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            String experimentId = regClient.createExperiment(gatewayId, experiment);
            if (ServerSettings.isEnableSharing().booleanValue()) {
                try {
                    Entity entity = new Entity();
                    entity.setEntityId(experimentId);
                    entity.setDomainId(experiment.getGatewayId());
                    entity.setEntityTypeId(experiment.getGatewayId() + ":EXPERIMENT");
                    entity.setOwnerId(experiment.getUserName() + "@" + experiment.getGatewayId());
                    entity.setName(experiment.getExperimentName());
                    entity.setDescription(experiment.getDescription());
                    entity.setParentEntityId(experiment.getProjectId());
                    sharingClient.createEntity(entity);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    logger.error("Rolling back experiment creation Exp ID : " + experimentId);
                    regClient.deleteExperiment(experimentId);
                    AiravataSystemException ase = new AiravataSystemException();
                    ase.setMessage("Failed to create sharing registry record");
                    throw ase;
                }
            }
            ExperimentStatusChangeEvent event = new ExperimentStatusChangeEvent(ExperimentState.CREATED, experimentId, gatewayId);
            String messageId = AiravataUtils.getId((String)"EXPERIMENT");
            MessageContext messageContext = new MessageContext((TBase)event, MessageType.EXPERIMENT, messageId, gatewayId);
            messageContext.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
            if (this.statusPublisher != null) {
                this.statusPublisher.publish(messageContext);
            }
            logger.debug(experimentId, (Object)"Created new experiment with experiment name {}", (Object)experiment.getExperimentName());
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return experimentId;
        }
        catch (Exception e) {
            logger.error("Error while creating the experiment with experiment name {}", (Object)experiment.getExperimentName());
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while creating the experiment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteExperiment(AuthzToken authzToken, String experimentId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            ExperimentModel experimentModel = regClient.getExperiment(experimentId);
            if (ServerSettings.isEnableSharing().booleanValue() && !((String)authzToken.getClaimsMap().get("userName")).equals(experimentModel.getUserName()) || !((String)authzToken.getClaimsMap().get("gatewayID")).equals(experimentModel.getGatewayId())) {
                try {
                    String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
                    String userId = (String)authzToken.getClaimsMap().get("userName");
                    if (!sharingClient.userHasAccess(gatewayId, userId + "@" + gatewayId, experimentId, gatewayId + ":WRITE")) {
                        throw new AuthorizationException("User does not have permission to access this resource");
                    }
                }
                catch (Exception e) {
                    throw new AuthorizationException("User does not have permission to access this resource");
                }
            }
            if (((ExperimentStatus)experimentModel.getExperimentStatus().get(0)).getState() != ExperimentState.CREATED) {
                logger.error("Error while deleting the experiment");
                throw new RegistryServiceException("Experiment is not in CREATED state. Hence cannot deleted. ID:" + experimentId);
            }
            boolean result = regClient.deleteExperiment(experimentId);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while deleting the experiment", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting the experiment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ExperimentModel getExperiment(AuthzToken authzToken, String airavataExperimentId) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        ExperimentModel experimentModel = null;
        try {
            experimentModel = regClient.getExperiment(airavataExperimentId);
            if (((String)authzToken.getClaimsMap().get("userName")).equals(experimentModel.getUserName()) && ((String)authzToken.getClaimsMap().get("gatewayID")).equals(experimentModel.getGatewayId())) {
                this.registryClientPool.returnResource(regClient);
                this.sharingClientPool.returnResource(sharingClient);
                return experimentModel;
            }
            if (ServerSettings.isEnableSharing().booleanValue()) {
                try {
                    String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
                    String userId = (String)authzToken.getClaimsMap().get("userName");
                    if (!sharingClient.userHasAccess(gatewayId, userId + "@" + gatewayId, airavataExperimentId, gatewayId + ":READ")) {
                        throw new AuthorizationException("User does not have permission to access this resource");
                    }
                    this.registryClientPool.returnResource(regClient);
                    this.sharingClientPool.returnResource(sharingClient);
                    return experimentModel;
                }
                catch (Exception e) {
                    throw new AuthorizationException("User does not have permission to access this resource");
                }
            }
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return null;
        }
        catch (Exception e) {
            logger.error("Error while getting the experiment", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while getting the experiment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ExperimentModel getExperimentByAdmin(AuthzToken authzToken, String airavataExperimentId) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        ExperimentModel experimentModel = null;
        try {
            String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
            experimentModel = regClient.getExperiment(airavataExperimentId);
            this.registryClientPool.returnResource(regClient);
            if (gatewayId.equals(experimentModel.getGatewayId())) {
                return experimentModel;
            }
            throw new AuthorizationException("User does not have permission to access this resource");
        }
        catch (Exception e) {
            logger.error("Error while getting the experiment", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while getting the experiment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ExperimentModel getDetailedExperimentTree(AuthzToken authzToken, String airavataExperimentId) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            ExperimentModel result = regClient.getDetailedExperimentTree(airavataExperimentId);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving the experiment", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving the experiment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public void updateExperiment(AuthzToken authzToken, String airavataExperimentId, ExperimentModel experiment) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            ExperimentModel experimentModel = regClient.getExperiment(airavataExperimentId);
            if (ServerSettings.isEnableSharing().booleanValue() && !((String)authzToken.getClaimsMap().get("userName")).equals(experimentModel.getUserName()) || !((String)authzToken.getClaimsMap().get("gatewayID")).equals(experimentModel.getGatewayId())) {
                try {
                    String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
                    String userId = (String)authzToken.getClaimsMap().get("userName");
                    if (!sharingClient.userHasAccess(gatewayId, userId + "@" + gatewayId, airavataExperimentId, gatewayId + ":WRITE")) {
                        throw new AuthorizationException("User does not have permission to access this resource");
                    }
                }
                catch (Exception e) {
                    throw new AuthorizationException("User does not have permission to access this resource");
                }
            }
            regClient.updateExperiment(airavataExperimentId, experiment);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while updating experiment", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating experiment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public void updateExperimentConfiguration(AuthzToken authzToken, String airavataExperimentId, UserConfigurationDataModel userConfiguration) throws AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            regClient.send_updateExperimentConfiguration(airavataExperimentId, userConfiguration);
            this.registryClientPool.returnResource(regClient);
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while updating user configuration", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating user configuration. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses...  " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public void updateResourceScheduleing(AuthzToken authzToken, String airavataExperimentId, ComputationalResourceSchedulingModel resourceScheduling) throws AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            regClient.updateResourceScheduleing(airavataExperimentId, resourceScheduling);
            this.registryClientPool.returnResource(regClient);
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while updating scheduling info", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating scheduling info. Update experiment is only valid for experiments with status CREATED, VALIDATED, CANCELLED, FAILED and UNKNOWN. Make sure the given experiment is in one of above statuses...  " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean validateExperiment(AuthzToken authzToken, String airavataExperimentId) throws TException {
        return true;
    }

    @SecurityCheck
    public ExperimentStatus getExperimentStatus(AuthzToken authzToken, String airavataExperimentId) throws TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ExperimentStatus result = regClient.getExperimentStatus(airavataExperimentId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            AiravataSystemException exception = new AiravataSystemException();
            exception.setMessage(e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<OutputDataObjectType> getExperimentOutputs(AuthzToken authzToken, String airavataExperimentId) throws AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getExperimentOutputs(airavataExperimentId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while retrieving the experiment outputs", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving the experiment outputs. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<OutputDataObjectType> getIntermediateOutputs(AuthzToken authzToken, String airavataExperimentId) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        return null;
    }

    @SecurityCheck
    public Map<String, JobStatus> getJobStatuses(AuthzToken authzToken, String airavataExperimentId) throws AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            Map result = regClient.getJobStatuses(airavataExperimentId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while retrieving the job statuses", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving the job statuses. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<JobModel> getJobDetails(AuthzToken authzToken, String airavataExperimentId) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getJobDetails(airavataExperimentId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(airavataExperimentId, (Object)"Error while retrieving the job details", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving the job details. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public void launchExperiment(AuthzToken authzToken, String airavataExperimentId, String gatewayId) throws TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ExperimentModel experiment = regClient.getExperiment(airavataExperimentId);
            if (experiment == null) {
                logger.error(airavataExperimentId, (Object)"Error while launching experiment, experiment {} doesn't exist.", (Object)airavataExperimentId);
                throw new ExperimentNotFoundException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            this.submitExperiment(gatewayId, airavataExperimentId);
            this.registryClientPool.returnResource(regClient);
        }
        catch (Exception e1) {
            logger.error(airavataExperimentId, (Object)"Error while instantiate the registry instance", (Object)e1);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while instantiate the registry instance. More info : " + e1.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String cloneExperiment(AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, AuthorizationException, ProjectNotFoundException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            ExperimentModel existingExperiment = this.getExperiment(authzToken, existingExperimentID);
            String result = this.cloneExperimentInternal(regClient, sharingClient, authzToken, existingExperimentID, newExperimentName, newExperimentProjectId, existingExperiment);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e) {
            logger.error(existingExperimentID, (Object)"Error while cloning the experiment with existing configuration...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while cloning the experiment with existing configuration. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String cloneExperimentByAdmin(AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId) throws InvalidRequestException, ExperimentNotFoundException, AiravataClientException, AiravataSystemException, AuthorizationException, ProjectNotFoundException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            ExperimentModel existingExperiment = this.getExperimentByAdmin(authzToken, existingExperimentID);
            String result = this.cloneExperimentInternal(regClient, sharingClient, authzToken, existingExperimentID, newExperimentName, newExperimentProjectId, existingExperiment);
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return result;
        }
        catch (Exception e) {
            logger.error(existingExperimentID, (Object)"Error while cloning the experiment with existing configuration...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while cloning the experiment with existing configuration. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            this.sharingClientPool.returnBrokenResource(sharingClient);
            throw exception;
        }
    }

    private String cloneExperimentInternal(RegistryService.Client regClient, SharingRegistryService.Client sharingClient, AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId, ExperimentModel existingExperiment) throws ExperimentNotFoundException, ProjectNotFoundException, TException, AuthorizationException, ApplicationSettingsException {
        String compResourceId;
        ComputeResourceDescription computeResourceDescription;
        String userId;
        String gatewayId;
        if (existingExperiment == null) {
            logger.error(existingExperimentID, (Object)"Error while cloning experiment {}, experiment doesn't exist.", (Object)existingExperimentID);
            throw new ExperimentNotFoundException("Requested experiment id " + existingExperimentID + " does not exist in the system..");
        }
        if (newExperimentProjectId != null) {
            Project project = this.getProject(authzToken, newExperimentProjectId);
            if (project == null) {
                logger.error("Error while cloning experiment {}, project {} doesn't exist.", (Object)existingExperimentID, (Object)newExperimentProjectId);
                throw new ProjectNotFoundException("Requested project id " + newExperimentProjectId + " does not exist in the system..");
            }
            existingExperiment.setProjectId(project.getProjectID());
        }
        if (!sharingClient.userHasAccess(gatewayId = (String)authzToken.getClaimsMap().get("gatewayID"), (userId = (String)authzToken.getClaimsMap().get("userName")) + "@" + gatewayId, existingExperiment.getProjectId(), gatewayId + ":WRITE")) {
            logger.error("Error while cloning experiment {}, user doesn't have write access to project {}", (Object)existingExperimentID, (Object)existingExperiment.getProjectId());
            throw new AuthorizationException("User does not have permission to clone an experiment in this project");
        }
        existingExperiment.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
        if (existingExperiment.getExecutionId() != null) {
            List applicationOutputs = regClient.getApplicationOutputs(existingExperiment.getExecutionId());
            existingExperiment.setExperimentOutputs(applicationOutputs);
        }
        if (this.validateString(newExperimentName)) {
            existingExperiment.setExperimentName(newExperimentName);
        }
        if (existingExperiment.getErrors() != null) {
            existingExperiment.getErrors().clear();
        }
        if (existingExperiment.getUserConfigurationData() != null && existingExperiment.getUserConfigurationData().getComputationalResourceScheduling() != null && !(computeResourceDescription = regClient.getComputeResource(compResourceId = existingExperiment.getUserConfigurationData().getComputationalResourceScheduling().getResourceHostId())).isEnabled()) {
            existingExperiment.getUserConfigurationData().setComputationalResourceScheduling(null);
        }
        logger.debug("Airavata cloned experiment with experiment id : " + existingExperimentID);
        existingExperiment.setUserName(userId);
        String expId = regClient.createExperiment(gatewayId, existingExperiment);
        if (ServerSettings.isEnableSharing().booleanValue()) {
            try {
                Entity entity = new Entity();
                entity.setEntityId(expId);
                entity.setDomainId(existingExperiment.getGatewayId());
                entity.setEntityTypeId(existingExperiment.getGatewayId() + ":EXPERIMENT");
                entity.setOwnerId(existingExperiment.getUserName() + "@" + existingExperiment.getGatewayId());
                entity.setName(existingExperiment.getExperimentName());
                entity.setDescription(existingExperiment.getDescription());
                sharingClient.createEntity(entity);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                logger.error("rolling back experiment creation Exp ID : " + expId);
                regClient.deleteExperiment(expId);
            }
        }
        return expId;
    }

    @SecurityCheck
    public void terminateExperiment(AuthzToken authzToken, String airavataExperimentId, String gatewayId) throws TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ExperimentModel existingExperiment = regClient.getExperiment(airavataExperimentId);
            if (existingExperiment == null) {
                logger.error(airavataExperimentId, (Object)"Error while cancelling experiment {}, experiment doesn't exist.", (Object)airavataExperimentId);
                throw new ExperimentNotFoundException("Requested experiment id " + airavataExperimentId + " does not exist in the system..");
            }
            switch (((ExperimentStatus)existingExperiment.getExperimentStatus().get(0)).getState()) {
                case COMPLETED: 
                case CANCELED: 
                case FAILED: 
                case CANCELING: {
                    logger.warn("Can't terminate already {} experiment", (Object)((ExperimentStatus)existingExperiment.getExperimentStatus().get(0)).getState().name());
                    break;
                }
                case CREATED: {
                    logger.warn("Experiment termination is only allowed for launched experiments.");
                    break;
                }
                default: {
                    this.submitCancelExperiment(gatewayId, airavataExperimentId);
                    logger.debug("Airavata cancelled experiment with experiment id : " + airavataExperimentId);
                }
            }
            this.registryClientPool.returnResource(regClient);
        }
        catch (AiravataException | RegistryServiceException e) {
            logger.error(airavataExperimentId, (Object)"Error while cancelling the experiment...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while cancelling the experiment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerApplicationModule(AuthzToken authzToken, String gatewayId, ApplicationModule applicationModule) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerApplicationModule(gatewayId, applicationModule);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while adding application module...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding application module. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ApplicationModule getApplicationModule(AuthzToken authzToken, String appModuleId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ApplicationModule result = regClient.getApplicationModule(appModuleId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appModuleId, (Object)"Error while retrieving application module...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving the adding application module. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateApplicationModule(AuthzToken authzToken, String appModuleId, ApplicationModule applicationModule) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateApplicationModule(appModuleId, applicationModule);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appModuleId, (Object)"Error while updating application module...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating application module. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<ApplicationModule> getAllAppModules(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllAppModules(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving all application modules...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving all application modules. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteApplicationModule(AuthzToken authzToken, String appModuleId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteApplicationModule(appModuleId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appModuleId, (Object)"Error while deleting application module...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting the application module. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerApplicationDeployment(AuthzToken authzToken, String gatewayId, ApplicationDeploymentDescription applicationDeployment) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerApplicationDeployment(gatewayId, applicationDeployment);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while adding application deployment...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding application deployment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ApplicationDeploymentDescription getApplicationDeployment(AuthzToken authzToken, String appDeploymentId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ApplicationDeploymentDescription result = regClient.getApplicationDeployment(appDeploymentId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appDeploymentId, (Object)"Error while retrieving application deployment...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving application deployment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateApplicationDeployment(AuthzToken authzToken, String appDeploymentId, ApplicationDeploymentDescription applicationDeployment) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateApplicationDeployment(appDeploymentId, applicationDeployment);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appDeploymentId, (Object)"Error while updating application deployment...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating application deployment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteApplicationDeployment(AuthzToken authzToken, String appDeploymentId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteApplicationDeployment(appDeploymentId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appDeploymentId, (Object)"Error while deleting application deployment...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting application deployment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<ApplicationDeploymentDescription> getAllApplicationDeployments(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllApplicationDeployments(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving application deployments...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving application deployments. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<String> getAppModuleDeployedResources(AuthzToken authzToken, String appModuleId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAppModuleDeployedResources(appModuleId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appModuleId, (Object)"Error while retrieving application deployments...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving application deployment. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerApplicationInterface(AuthzToken authzToken, String gatewayId, ApplicationInterfaceDescription applicationInterface) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerApplicationInterface(gatewayId, applicationInterface);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while adding application interface...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding application interface. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String cloneApplicationInterface(AuthzToken authzToken, String existingAppInterfaceID, String newApplicationName, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ApplicationInterfaceDescription existingInterface = regClient.getApplicationInterface(existingAppInterfaceID);
            if (existingInterface == null) {
                logger.error("Provided application interface does not exist.Please provide a valid application interface id...");
                throw new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            }
            existingInterface.setApplicationName(newApplicationName);
            existingInterface.setApplicationInterfaceId("DO_NOT_SET_AT_CLIENTS");
            String interfaceId = regClient.registerApplicationInterface(gatewayId, existingInterface);
            logger.debug("Airavata cloned application interface : " + existingAppInterfaceID + " for gateway id : " + gatewayId);
            this.registryClientPool.returnResource(regClient);
            return interfaceId;
        }
        catch (Exception e) {
            logger.error("Error while adding application interface...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding application interface. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ApplicationInterfaceDescription getApplicationInterface(AuthzToken authzToken, String appInterfaceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ApplicationInterfaceDescription result = regClient.getApplicationInterface(appInterfaceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appInterfaceId, (Object)"Error while retrieving application interface...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving application interface. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateApplicationInterface(AuthzToken authzToken, String appInterfaceId, ApplicationInterfaceDescription applicationInterface) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateApplicationInterface(appInterfaceId, applicationInterface);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appInterfaceId, (Object)"Error while updating application interface...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating application interface. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteApplicationInterface(AuthzToken authzToken, String appInterfaceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteApplicationInterface(appInterfaceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appInterfaceId, (Object)"Error while deleting application interface...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting application interface. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public Map<String, String> getAllApplicationInterfaceNames(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            Map result = regClient.getAllApplicationInterfaceNames(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving application interfaces...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving application interfaces. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<ApplicationInterfaceDescription> getAllApplicationInterfaces(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllApplicationInterfaces(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving application interfaces...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving application interfaces. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<InputDataObjectType> getApplicationInputs(AuthzToken authzToken, String appInterfaceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getApplicationInputs(appInterfaceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appInterfaceId, (Object)"Error while retrieving application inputs...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving application inputs. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<OutputDataObjectType> getApplicationOutputs(AuthzToken authzToken, String appInterfaceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getApplicationOutputs(appInterfaceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            AiravataSystemException exception = new AiravataSystemException();
            exception.setMessage(e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public Map<String, String> getAvailableAppInterfaceComputeResources(AuthzToken authzToken, String appInterfaceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            Map result = regClient.getAvailableAppInterfaceComputeResources(appInterfaceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(appInterfaceId, (Object)"Error while saving compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while saving compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerComputeResource(AuthzToken authzToken, ComputeResourceDescription computeResourceDescription) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerComputeResource(computeResourceDescription);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while saving compute resource...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while saving compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ComputeResourceDescription getComputeResource(AuthzToken authzToken, String computeResourceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ComputeResourceDescription result = regClient.getComputeResource(computeResourceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(computeResourceId, (Object)"Error while retrieving compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public Map<String, String> getAllComputeResourceNames(AuthzToken authzToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            Map result = regClient.getAllComputeResourceNames();
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateComputeResource(AuthzToken authzToken, String computeResourceId, ComputeResourceDescription computeResourceDescription) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateComputeResource(computeResourceId, computeResourceDescription);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(computeResourceId, (Object)"Error while updating compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updaing compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteComputeResource(AuthzToken authzToken, String computeResourceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteComputeResource(computeResourceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(computeResourceId, (Object)"Error while deleting compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerStorageResource(AuthzToken authzToken, StorageResourceDescription storageResourceDescription) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerStorageResource(storageResourceDescription);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while saving storage resource...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while saving storage resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public StorageResourceDescription getStorageResource(AuthzToken authzToken, String storageResourceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            StorageResourceDescription result = regClient.getStorageResource(storageResourceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(storageResourceId, (Object)"Error while retrieving storage resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving storage resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public Map<String, String> getAllStorageResourceNames(AuthzToken authzToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            Map result = regClient.getAllStorageResourceNames();
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while retrieving storage resource...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving storage resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateStorageResource(AuthzToken authzToken, String storageResourceId, StorageResourceDescription storageResourceDescription) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateStorageResource(storageResourceId, storageResourceDescription);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(storageResourceId, (Object)"Error while updating storage resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updaing storage resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteStorageResource(AuthzToken authzToken, String storageResourceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteStorageResource(storageResourceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(storageResourceId, (Object)"Error while deleting storage resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting storage resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String addLocalSubmissionDetails(AuthzToken authzToken, String computeResourceId, int priorityOrder, LOCALSubmission localSubmission) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.addLocalSubmissionDetails(computeResourceId, priorityOrder, localSubmission);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(computeResourceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateLocalSubmissionDetails(AuthzToken authzToken, String jobSubmissionInterfaceId, LOCALSubmission localSubmission) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateLocalSubmissionDetails(jobSubmissionInterfaceId, localSubmission);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public LOCALSubmission getLocalJobSubmission(AuthzToken authzToken, String jobSubmissionId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            LOCALSubmission result = regClient.getLocalJobSubmission(jobSubmissionId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving local job submission interface to resource compute resource...";
            logger.error(jobSubmissionId, (Object)errorMsg, (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(errorMsg + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String addSSHJobSubmissionDetails(AuthzToken authzToken, String computeResourceId, int priorityOrder, SSHJobSubmission sshJobSubmission) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.addSSHJobSubmissionDetails(computeResourceId, priorityOrder, sshJobSubmission);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(computeResourceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String addSSHForkJobSubmissionDetails(AuthzToken authzToken, String computeResourceId, int priorityOrder, SSHJobSubmission sshJobSubmission) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.addSSHForkJobSubmissionDetails(computeResourceId, priorityOrder, sshJobSubmission);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(computeResourceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public SSHJobSubmission getSSHJobSubmission(AuthzToken authzToken, String jobSubmissionId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            SSHJobSubmission result = regClient.getSSHJobSubmission(jobSubmissionId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving SSH job submission interface to resource compute resource...";
            logger.error(jobSubmissionId, (Object)errorMsg, (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(errorMsg + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String addCloudJobSubmissionDetails(AuthzToken authzToken, String computeResourceId, int priorityOrder, CloudJobSubmission cloudJobSubmission) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.addCloudJobSubmissionDetails(computeResourceId, priorityOrder, cloudJobSubmission);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(computeResourceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public CloudJobSubmission getCloudJobSubmission(AuthzToken authzToken, String jobSubmissionId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            CloudJobSubmission result = regClient.getCloudJobSubmission(jobSubmissionId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving Cloud job submission interface to resource compute resource...";
            logger.error(jobSubmissionId, (Object)errorMsg, (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(errorMsg + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String addUNICOREJobSubmissionDetails(AuthzToken authzToken, String computeResourceId, int priorityOrder, UnicoreJobSubmission unicoreJobSubmission) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.addUNICOREJobSubmissionDetails(computeResourceId, priorityOrder, unicoreJobSubmission);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while adding job submission interface to resource compute resource...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public UnicoreJobSubmission getUnicoreJobSubmission(AuthzToken authzToken, String jobSubmissionId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            UnicoreJobSubmission result = regClient.getUnicoreJobSubmission(jobSubmissionId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving Unicore job submission interface to resource compute resource...";
            logger.error(jobSubmissionId, (Object)errorMsg, (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(errorMsg + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateSSHJobSubmissionDetails(AuthzToken authzToken, String jobSubmissionInterfaceId, SSHJobSubmission sshJobSubmission) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateSSHJobSubmissionDetails(jobSubmissionInterfaceId, sshJobSubmission);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateCloudJobSubmissionDetails(AuthzToken authzToken, String jobSubmissionInterfaceId, CloudJobSubmission cloudJobSubmission) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateCloudJobSubmissionDetails(jobSubmissionInterfaceId, cloudJobSubmission);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateUnicoreJobSubmissionDetails(AuthzToken authzToken, String jobSubmissionInterfaceId, UnicoreJobSubmission unicoreJobSubmission) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateUnicoreJobSubmissionDetails(jobSubmissionInterfaceId, unicoreJobSubmission);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String addLocalDataMovementDetails(AuthzToken authzToken, String resourceId, DMType dmType, int priorityOrder, LOCALDataMovement localDataMovement) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.addLocalDataMovementDetails(resourceId, dmType, priorityOrder, localDataMovement);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(resourceId, (Object)"Error while adding data movement interface to resource resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding data movement interface to resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateLocalDataMovementDetails(AuthzToken authzToken, String dataMovementInterfaceId, LOCALDataMovement localDataMovement) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateLocalDataMovementDetails(dataMovementInterfaceId, localDataMovement);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while updating local data movement interface..", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating local data movement interface. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public LOCALDataMovement getLocalDataMovement(AuthzToken authzToken, String dataMovementId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            LOCALDataMovement result = regClient.getLocalDataMovement(dataMovementId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving local data movement interface to resource compute resource...";
            logger.error(dataMovementId, (Object)errorMsg, (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(errorMsg + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String addSCPDataMovementDetails(AuthzToken authzToken, String resourceId, DMType dmType, int priorityOrder, SCPDataMovement scpDataMovement) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.addSCPDataMovementDetails(resourceId, dmType, priorityOrder, scpDataMovement);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(resourceId, (Object)"Error while adding data movement interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding data movement interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateSCPDataMovementDetails(AuthzToken authzToken, String dataMovementInterfaceId, SCPDataMovement scpDataMovement) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateSCPDataMovementDetails(dataMovementInterfaceId, scpDataMovement);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public SCPDataMovement getSCPDataMovement(AuthzToken authzToken, String dataMovementId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            SCPDataMovement result = regClient.getSCPDataMovement(dataMovementId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving SCP data movement interface to resource compute resource...";
            logger.error(dataMovementId, (Object)errorMsg, (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(errorMsg + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String addUnicoreDataMovementDetails(AuthzToken authzToken, String resourceId, DMType dmType, int priorityOrder, UnicoreDataMovement unicoreDataMovement) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.addUnicoreDataMovementDetails(resourceId, dmType, priorityOrder, unicoreDataMovement);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(resourceId, (Object)"Error while adding data movement interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding data movement interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateUnicoreDataMovementDetails(AuthzToken authzToken, String dataMovementInterfaceId, UnicoreDataMovement unicoreDataMovement) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateUnicoreDataMovementDetails(dataMovementInterfaceId, unicoreDataMovement);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while updating unicore data movement to compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating unicore data movement to compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public UnicoreDataMovement getUnicoreDataMovement(AuthzToken authzToken, String dataMovementId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            UnicoreDataMovement result = regClient.getUnicoreDataMovement(dataMovementId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving UNICORE data movement interface...";
            logger.error(dataMovementId, (Object)errorMsg, (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(errorMsg + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String addGridFTPDataMovementDetails(AuthzToken authzToken, String computeResourceId, DMType dmType, int priorityOrder, GridFTPDataMovement gridFTPDataMovement) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.addGridFTPDataMovementDetails(computeResourceId, dmType, priorityOrder, gridFTPDataMovement);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(computeResourceId, (Object)"Error while adding data movement interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding data movement interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateGridFTPDataMovementDetails(AuthzToken authzToken, String dataMovementInterfaceId, GridFTPDataMovement gridFTPDataMovement) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateGridFTPDataMovementDetails(dataMovementInterfaceId, gridFTPDataMovement);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while adding job submission interface to resource compute resource...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding job submission interface to resource compute resource. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public GridFTPDataMovement getGridFTPDataMovement(AuthzToken authzToken, String dataMovementId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            GridFTPDataMovement result = regClient.getGridFTPDataMovement(dataMovementId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving GridFTP data movement interface to resource compute resource...";
            logger.error(dataMovementId, (Object)errorMsg, (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(errorMsg + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean changeJobSubmissionPriority(AuthzToken authzToken, String jobSubmissionInterfaceId, int newPriorityOrder) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        return false;
    }

    @SecurityCheck
    public boolean changeDataMovementPriority(AuthzToken authzToken, String dataMovementInterfaceId, int newPriorityOrder) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        return false;
    }

    @SecurityCheck
    public boolean changeJobSubmissionPriorities(AuthzToken authzToken, Map<String, Integer> jobSubmissionPriorityMap) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        return false;
    }

    @SecurityCheck
    public boolean changeDataMovementPriorities(AuthzToken authzToken, Map<String, Integer> dataMovementPriorityMap) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        return false;
    }

    @SecurityCheck
    public boolean deleteJobSubmissionInterface(AuthzToken authzToken, String computeResourceId, String jobSubmissionInterfaceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteJobSubmissionInterface(computeResourceId, jobSubmissionInterfaceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(jobSubmissionInterfaceId, (Object)"Error while deleting job submission interface...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting job submission interface. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteDataMovementInterface(AuthzToken authzToken, String resourceId, String dataMovementInterfaceId, DMType dmType) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteDataMovementInterface(resourceId, dataMovementInterfaceId, dmType);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(dataMovementInterfaceId, (Object)"Error while deleting data movement interface...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting data movement interface. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerResourceJobManager(AuthzToken authzToken, ResourceJobManager resourceJobManager) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerResourceJobManager(resourceJobManager);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(resourceJobManager.getResourceJobManagerId(), (Object)"Error while adding resource job manager...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while adding resource job manager. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateResourceJobManager(AuthzToken authzToken, String resourceJobManagerId, ResourceJobManager updatedResourceJobManager) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateResourceJobManager(resourceJobManagerId, updatedResourceJobManager);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(resourceJobManagerId, (Object)"Error while updating resource job manager...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating resource job manager. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ResourceJobManager getResourceJobManager(AuthzToken authzToken, String resourceJobManagerId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ResourceJobManager result = regClient.getResourceJobManager(resourceJobManagerId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(resourceJobManagerId, (Object)"Error while retrieving resource job manager...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving resource job manager. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteResourceJobManager(AuthzToken authzToken, String resourceJobManagerId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteResourceJobManager(resourceJobManagerId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(resourceJobManagerId, (Object)"Error while deleting resource job manager...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting resource job manager. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteBatchQueue(AuthzToken authzToken, String computeResourceId, String queueName) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteBatchQueue(computeResourceId, queueName);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(computeResourceId, (Object)"Error while deleting batch queue...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while deleting batch queue. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerGatewayResourceProfile(AuthzToken authzToken, GatewayResourceProfile gatewayResourceProfile) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerGatewayResourceProfile(gatewayResourceProfile);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while registering gateway resource profile...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while registering gateway resource profile. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public GatewayResourceProfile getGatewayResourceProfile(AuthzToken authzToken, String gatewayID) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            GatewayResourceProfile result = regClient.getGatewayResourceProfile(gatewayID);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while retrieving gateway resource profile...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving gateway resource profile. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateGatewayResourceProfile(AuthzToken authzToken, String gatewayID, GatewayResourceProfile gatewayResourceProfile) throws TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateGatewayResourceProfile(gatewayID, gatewayResourceProfile);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while updating gateway resource profile...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating gateway resource profile. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteGatewayResourceProfile(AuthzToken authzToken, String gatewayID) throws TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteGatewayResourceProfile(gatewayID);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while removing gateway resource profile...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while removing gateway resource profile. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean addGatewayComputeResourcePreference(AuthzToken authzToken, String gatewayID, String computeResourceId, ComputeResourcePreference computeResourcePreference) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.addGatewayComputeResourcePreference(gatewayID, computeResourceId, computeResourcePreference);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while registering gateway resource profile preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while registering gateway resource profile preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean addGatewayStoragePreference(AuthzToken authzToken, String gatewayID, String storageResourceId, StoragePreference dataStoragePreference) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.addGatewayStoragePreference(gatewayID, storageResourceId, dataStoragePreference);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while registering gateway resource profile preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while registering gateway resource profile preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public ComputeResourcePreference getGatewayComputeResourcePreference(AuthzToken authzToken, String gatewayID, String computeResourceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            ComputeResourcePreference result = regClient.getGatewayComputeResourcePreference(gatewayID, computeResourceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while reading gateway compute resource preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading gateway compute resource preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public StoragePreference getGatewayStoragePreference(AuthzToken authzToken, String gatewayID, String storageId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            StoragePreference result = regClient.getGatewayStoragePreference(gatewayID, storageId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while reading gateway data storage preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading gateway data storage preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<ComputeResourcePreference> getAllGatewayComputeResourcePreferences(AuthzToken authzToken, String gatewayID) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllGatewayComputeResourcePreferences(gatewayID);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while reading gateway compute resource preferences...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading gateway compute resource preferences. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<StoragePreference> getAllGatewayStoragePreferences(AuthzToken authzToken, String gatewayID) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllGatewayStoragePreferences(gatewayID);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while reading gateway data storage preferences...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading gateway data storage preferences. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<GatewayResourceProfile> getAllGatewayResourceProfiles(AuthzToken authzToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllGatewayResourceProfiles();
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading retrieving all gateway profiles. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateGatewayComputeResourcePreference(AuthzToken authzToken, String gatewayID, String computeResourceId, ComputeResourcePreference computeResourcePreference) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateGatewayComputeResourcePreference(gatewayID, computeResourceId, computeResourcePreference);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while reading gateway compute resource preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating gateway compute resource preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateGatewayStoragePreference(AuthzToken authzToken, String gatewayID, String storageId, StoragePreference dataStoragePreference) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateGatewayStoragePreference(gatewayID, storageId, dataStoragePreference);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while reading gateway data storage preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating gateway data storage preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteGatewayComputeResourcePreference(AuthzToken authzToken, String gatewayID, String computeResourceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteGatewayComputeResourcePreference(gatewayID, computeResourceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while reading gateway compute resource preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating gateway compute resource preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteGatewayStoragePreference(AuthzToken authzToken, String gatewayID, String storageId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteGatewayStoragePreference(gatewayID, storageId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(gatewayID, (Object)"Error while reading gateway data storage preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating gateway data storage preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<SSHAccountProvisioner> getSSHAccountProvisioners(AuthzToken authzToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        ArrayList<SSHAccountProvisioner> sshAccountProvisioners = new ArrayList<SSHAccountProvisioner>();
        List sshAccountProvisionerProviders = SSHAccountProvisionerFactory.getSSHAccountProvisionerProviders();
        for (SSHAccountProvisionerProvider provider : sshAccountProvisionerProviders) {
            SSHAccountProvisioner sshAccountProvisioner = new SSHAccountProvisioner();
            sshAccountProvisioner.setCanCreateAccount(provider.canCreateAccount());
            sshAccountProvisioner.setCanInstallSSHKey(provider.canInstallSSHKey());
            sshAccountProvisioner.setName(provider.getName());
            ArrayList<SSHAccountProvisionerConfigParam> sshAccountProvisionerConfigParams = new ArrayList<SSHAccountProvisionerConfigParam>();
            for (ConfigParam configParam : provider.getConfigParams()) {
                SSHAccountProvisionerConfigParam sshAccountProvisionerConfigParam = new SSHAccountProvisionerConfigParam();
                sshAccountProvisionerConfigParam.setName(configParam.getName());
                sshAccountProvisionerConfigParam.setDescription(configParam.getDescription());
                sshAccountProvisionerConfigParam.setIsOptional(configParam.isOptional());
                switch (configParam.getType()) {
                    case STRING: {
                        sshAccountProvisionerConfigParam.setType(SSHAccountProvisionerConfigParamType.STRING);
                        break;
                    }
                    case CRED_STORE_PASSWORD_TOKEN: {
                        sshAccountProvisionerConfigParam.setType(SSHAccountProvisionerConfigParamType.CRED_STORE_PASSWORD_TOKEN);
                    }
                }
                sshAccountProvisionerConfigParams.add(sshAccountProvisionerConfigParam);
            }
            sshAccountProvisioner.setConfigParams(sshAccountProvisionerConfigParams);
            sshAccountProvisioners.add(sshAccountProvisioner);
        }
        return sshAccountProvisioners;
    }

    @SecurityCheck
    public boolean doesUserHaveSSHAccount(AuthzToken authzToken, String computeResourceId, String userId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        try {
            String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
            return SSHAccountManager.doesUserHaveSSHAccount((String)gatewayId, (String)computeResourceId, (String)userId);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while checking if [" + userId + "] has an SSH Account on [" + computeResourceId + "].";
            logger.error(errorMessage, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(errorMessage + " More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public boolean isSSHSetupCompleteForUserComputeResourcePreference(AuthzToken authzToken, String computeResourceId, String airavataCredStoreToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
        String userId = (String)authzToken.getClaimsMap().get("userName");
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        SSHCredential sshCredential = null;
        try {
            sshCredential = csClient.getSSHCredential(airavataCredStoreToken, gatewayId);
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving SSH Credential", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while retrieving SSH Credential. More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
        try {
            return SSHAccountManager.isSSHAccountSetupComplete((String)gatewayId, (String)computeResourceId, (String)userId, (SSHCredential)sshCredential);
        }
        catch (Exception e) {
            String msg = "Error occurred while checking if setup of SSH account is complete for user [" + userId + "].";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public UserComputeResourcePreference setupUserComputeResourcePreferencesForSSH(AuthzToken authzToken, String computeResourceId, String userId, String airavataCredStoreToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
        CredentialStoreService.Client csClient = this.csClientPool.getResource();
        SSHCredential sshCredential = null;
        try {
            sshCredential = csClient.getSSHCredential(airavataCredStoreToken, gatewayId);
        }
        catch (Exception e) {
            logger.error("Error occurred while retrieving SSH Credential", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while retrieving SSH Credential. More info : " + e.getMessage());
            this.csClientPool.returnBrokenResource(csClient);
            throw exception;
        }
        try {
            UserComputeResourcePreference userComputeResourcePreference = SSHAccountManager.setupSSHAccount((String)gatewayId, (String)computeResourceId, (String)userId, (SSHCredential)sshCredential);
            return userComputeResourcePreference;
        }
        catch (Exception e) {
            logger.error("Error occurred while automatically setting up SSH account for user [" + userId + "]", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error occurred while automatically setting up SSH account for user [" + userId + "]. More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public String registerUserResourceProfile(AuthzToken authzToken, UserResourceProfile userResourceProfile) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerUserResourceProfile(userResourceProfile);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error("Error while registering user resource profile...", (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while registering user resource profile. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public UserResourceProfile getUserResourceProfile(AuthzToken authzToken, String userId, String gatewayID) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            UserResourceProfile result = regClient.getUserResourceProfile(userId, gatewayID);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while retrieving user resource profile...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while retrieving user resource profile. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateUserResourceProfile(AuthzToken authzToken, String userId, String gatewayID, UserResourceProfile userResourceProfile) throws TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateUserResourceProfile(userId, gatewayID, userResourceProfile);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while updating user resource profile...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating user resource profile. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteUserResourceProfile(AuthzToken authzToken, String userId, String gatewayID) throws TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteUserResourceProfile(userId, gatewayID);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while removing user resource profile...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while removing user resource profile. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean addUserComputeResourcePreference(AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, UserComputeResourcePreference userComputeResourcePreference) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.addUserComputeResourcePreference(userId, gatewayID, userComputeResourceId, userComputeResourcePreference);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while registering user resource profile preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while registering user resource profile preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean addUserStoragePreference(AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, UserStoragePreference dataStoragePreference) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.addUserStoragePreference(userId, gatewayID, userStorageResourceId, dataStoragePreference);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while registering user storage preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while registering user storage preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public UserComputeResourcePreference getUserComputeResourcePreference(AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            UserComputeResourcePreference result = regClient.getUserComputeResourcePreference(userId, gatewayID, userComputeResourceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while reading user compute resource preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading user compute resource preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public UserStoragePreference getUserStoragePreference(AuthzToken authzToken, String userId, String gatewayID, String userStorageId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            UserStoragePreference result = regClient.getUserStoragePreference(userId, gatewayID, userStorageId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while reading user data storage preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading user data storage preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<UserComputeResourcePreference> getAllUserComputeResourcePreferences(AuthzToken authzToken, String userId, String gatewayID) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllUserComputeResourcePreferences(userId, gatewayID);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while reading User compute resource preferences...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading User compute resource preferences. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<UserStoragePreference> getAllUserStoragePreferences(AuthzToken authzToken, String userId, String gatewayID) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllUserStoragePreferences(userId, gatewayID);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while reading User data storage preferences...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading User data storage preferences. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<UserResourceProfile> getAllUserResourceProfiles(AuthzToken authzToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllUserResourceProfiles();
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while reading retrieving all user resource profiles. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateUserComputeResourcePreference(AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, UserComputeResourcePreference userComputeResourcePreference) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateUserComputeResourcePreference(userId, gatewayID, userComputeResourceId, userComputeResourcePreference);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while reading user compute resource preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating user compute resource preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateUserStoragePreference(AuthzToken authzToken, String userId, String gatewayID, String userStorageId, UserStoragePreference dataStoragePreference) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.updateUserStoragePreference(userId, gatewayID, userStorageId, dataStoragePreference);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while reading user data storage preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating user data storage preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteUserComputeResourcePreference(AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteUserComputeResourcePreference(userId, gatewayID, userComputeResourceId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while reading user compute resource preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating user compute resource preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteUserStoragePreference(AuthzToken authzToken, String userId, String gatewayID, String userStorageId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.deleteUserStoragePreference(userId, gatewayID, userStorageId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            logger.error(userId, (Object)"Error while reading user data storage preference...", (Object)e);
            AiravataSystemException exception = new AiravataSystemException();
            exception.setAiravataErrorType(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage("Error while updating user data storage preference. More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<String> getAllWorkflows(AuthzToken authzToken, String gatewayId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getAllWorkflows(gatewayId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in retrieving all workflow template Ids.";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    public List<QueueStatusModel> getLatestQueueStatuses(AuthzToken authzToken) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getLatestQueueStatuses();
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in retrieving queue statuses";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public WorkflowModel getWorkflow(AuthzToken authzToken, String workflowTemplateId) throws InvalidRequestException, AiravataClientException, AuthorizationException, AiravataSystemException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            WorkflowModel result = regClient.getWorkflow(workflowTemplateId);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in retrieving the workflow " + workflowTemplateId + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public void deleteWorkflow(AuthzToken authzToken, String workflowTemplateId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            regClient.deleteWorkflow(workflowTemplateId);
            this.registryClientPool.returnResource(regClient);
            return;
        }
        catch (Exception e) {
            String msg = "Error in deleting the workflow " + workflowTemplateId + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerWorkflow(AuthzToken authzToken, String gatewayId, WorkflowModel workflow) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerWorkflow(gatewayId, workflow);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in registering the workflow " + workflow.getName() + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public void updateWorkflow(AuthzToken authzToken, String workflowTemplateId, WorkflowModel workflow) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            regClient.updateWorkflow(workflowTemplateId, workflow);
            this.registryClientPool.returnResource(regClient);
            return;
        }
        catch (Exception e) {
            String msg = "Error in updating the workflow " + workflow.getName() + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String getWorkflowTemplateId(AuthzToken authzToken, String workflowName) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.getWorkflowTemplateId(workflowName);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in retrieving the workflow template id for " + workflowName + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean isWorkflowExistWithName(AuthzToken authzToken, String workflowName) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            boolean result = regClient.isWorkflowExistWithName(workflowName);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in veriying the workflow for workflow name " + workflowName + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerDataProduct(AuthzToken authzToken, DataProductModel dataProductModel) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerDataProduct(dataProductModel);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in registering the data resource" + dataProductModel.getProductName() + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public DataProductModel getDataProduct(AuthzToken authzToken, String productUri) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            DataProductModel result = regClient.getDataProduct(productUri);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in retreiving the data product " + productUri + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String registerReplicaLocation(AuthzToken authzToken, DataReplicaLocationModel replicaLocationModel) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            String result = regClient.registerReplicaLocation(replicaLocationModel);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in retreiving the replica " + replicaLocationModel.getReplicaName() + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public DataProductModel getParentDataProduct(AuthzToken authzToken, String productUri) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            DataProductModel result = regClient.getParentDataProduct(productUri);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in retreiving the parent data product for " + productUri + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<DataProductModel> getChildDataProducts(AuthzToken authzToken, String productUri) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        try {
            List result = regClient.getChildDataProducts(productUri);
            this.registryClientPool.returnResource(regClient);
            return result;
        }
        catch (Exception e) {
            String msg = "Error in retreiving the child products for " + productUri + ".";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean shareResourceWithUsers(AuthzToken authzToken, String resourceId, ResourceType resourceType, Map<String, ResourcePermissionType> userPermissionList) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            for (Map.Entry<String, ResourcePermissionType> userPermission : userPermissionList.entrySet()) {
                String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
                if (userPermission.getValue().equals((Object)ResourcePermissionType.WRITE)) {
                    sharingClient.shareEntityWithUsers(gatewayId, resourceId, Arrays.asList(userPermission.getKey()), (String)authzToken.getClaimsMap().get("gatewayID") + ":WRITE", true);
                    continue;
                }
                sharingClient.shareEntityWithUsers(gatewayId, resourceId, Arrays.asList(userPermission.getKey()), (String)authzToken.getClaimsMap().get("gatewayID") + ":READ", true);
            }
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return true;
        }
        catch (Exception e) {
            String msg = "Error in sharing resource with users. Resource ID : " + resourceId + " Resource Type : " + resourceType.toString();
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.sharingClientPool.returnBrokenResource(sharingClient);
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public boolean revokeSharingOfResourceFromUsers(AuthzToken authzToken, String resourceId, ResourceType resourceType, Map<String, ResourcePermissionType> userPermissionList) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            for (Map.Entry<String, ResourcePermissionType> userPermission : userPermissionList.entrySet()) {
                String gatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
                if (userPermission.getValue().equals((Object)ResourcePermissionType.WRITE)) {
                    sharingClient.revokeEntitySharingFromUsers(gatewayId, resourceId, Arrays.asList(userPermission.getKey()), (String)authzToken.getClaimsMap().get("gatewayID") + ":WRITE");
                    continue;
                }
                sharingClient.revokeEntitySharingFromUsers(gatewayId, resourceId, Arrays.asList(userPermission.getKey()), (String)authzToken.getClaimsMap().get("gatewayID") + ":READ");
            }
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return true;
        }
        catch (Exception e) {
            String msg = "Error in revoking access to resouce from users. Resource ID : " + resourceId + " Resource Type : " + resourceType.toString();
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.sharingClientPool.returnBrokenResource(sharingClient);
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public List<String> getAllAccessibleUsers(AuthzToken authzToken, String resourceId, ResourceType resourceType, ResourcePermissionType permissionType) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        RegistryService.Client regClient = this.registryClientPool.getResource();
        SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
        try {
            HashSet accessibleUsers = new HashSet();
            if (permissionType.equals((Object)ResourcePermissionType.WRITE)) {
                sharingClient.getListOfSharedUsers((String)authzToken.getClaimsMap().get("gatewayID"), resourceId, (String)authzToken.getClaimsMap().get("gatewayID") + ":WRITE").stream().forEach(u -> accessibleUsers.add(u.userId));
                sharingClient.getListOfSharedUsers((String)authzToken.getClaimsMap().get("gatewayID"), resourceId, (String)authzToken.getClaimsMap().get("gatewayID") + ":OWNER").stream().forEach(u -> accessibleUsers.add(u.userId));
            } else if (permissionType.equals((Object)ResourcePermissionType.READ)) {
                sharingClient.getListOfSharedUsers((String)authzToken.getClaimsMap().get("gatewayID"), resourceId, (String)authzToken.getClaimsMap().get("gatewayID") + ":READ").stream().forEach(u -> accessibleUsers.add(u.userId));
                sharingClient.getListOfSharedUsers((String)authzToken.getClaimsMap().get("gatewayID"), resourceId, (String)authzToken.getClaimsMap().get("gatewayID") + ":OWNER").stream().forEach(u -> accessibleUsers.add(u.userId));
            } else if (permissionType.equals((Object)ResourcePermissionType.OWNER)) {
                sharingClient.getListOfSharedUsers((String)authzToken.getClaimsMap().get("gatewayID"), resourceId, (String)authzToken.getClaimsMap().get("gatewayID") + ":OWNER").stream().forEach(u -> accessibleUsers.add(u.userId));
            }
            this.registryClientPool.returnResource(regClient);
            this.sharingClientPool.returnResource(sharingClient);
            return new ArrayList<String>(accessibleUsers);
        }
        catch (Exception e) {
            String msg = "Error in getting all accessible users for resource. Resource ID : " + resourceId + " Resource Type : " + resourceType.toString();
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            this.sharingClientPool.returnBrokenResource(sharingClient);
            this.registryClientPool.returnBrokenResource(regClient);
            throw exception;
        }
    }

    @SecurityCheck
    public String createGroup(AuthzToken authzToken, GroupModel groupModel) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        try {
            SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
            UserGroup sharingUserGroup = new UserGroup();
            sharingUserGroup.setGroupId(UUID.randomUUID().toString());
            sharingUserGroup.setName(groupModel.getName());
            sharingUserGroup.setDescription(groupModel.getDescription());
            sharingUserGroup.setGroupType(GroupType.USER_LEVEL_GROUP);
            sharingUserGroup.setDomainId((String)authzToken.getClaimsMap().get("gatewayID"));
            String groupId = sharingClient.createGroup(sharingUserGroup);
            sharingClient.addUsersToGroup((String)authzToken.getClaimsMap().get("gatewayID"), groupModel.getMembers(), groupId);
            return groupId;
        }
        catch (Exception e) {
            String msg = "Error Creating Group";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateGroup(AuthzToken authzToken, GroupModel groupModel) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        try {
            SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
            UserGroup sharingUserGroup = new UserGroup();
            sharingUserGroup.setGroupId(groupModel.getId());
            sharingUserGroup.setName(groupModel.getName());
            sharingUserGroup.setDescription(groupModel.getDescription());
            sharingUserGroup.setGroupType(GroupType.USER_LEVEL_GROUP);
            sharingUserGroup.setDomainId((String)authzToken.getClaimsMap().get("gatewayID"));
            sharingClient.updateGroup(sharingUserGroup);
            return true;
        }
        catch (Exception e) {
            String msg = "Error Updating Group";
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteGroup(AuthzToken authzToken, String groupId, String ownerId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        try {
            SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
            sharingClient.deleteGroup((String)authzToken.getClaimsMap().get("gatewayID"), groupId);
            return true;
        }
        catch (Exception e) {
            String msg = "Error Deleting Group. Group ID: " + groupId;
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public GroupModel getGroup(AuthzToken authzToken, String groupId) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        try {
            SharingRegistryService.Client sharingClient = this.sharingClientPool.getResource();
            UserGroup userGroup = sharingClient.getGroup((String)authzToken.getClaimsMap().get("gatewayID"), groupId);
            GroupModel groupModel = new GroupModel();
            groupModel.setId(userGroup.getGroupId());
            groupModel.setName(userGroup.getName());
            groupModel.setDescription(userGroup.getDescription());
            groupModel.setOwnerId(userGroup.getOwnerId());
            sharingClient.getGroupMembersOfTypeUser((String)authzToken.getClaimsMap().get("gatewayID"), groupId, 0, -1).stream().forEach(user -> groupModel.addToMembers(user.getUserId()));
            return groupModel;
        }
        catch (Exception e) {
            String msg = "Error Retreiving Group. Group ID: " + groupId;
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public List<GroupModel> getAllGroupsUserBelongs(AuthzToken authzToken, String userName) throws InvalidRequestException, AiravataClientException, AiravataSystemException, AuthorizationException, TException {
        try {
            throw new UnsupportedOperationException("Method not supported yet");
        }
        catch (Exception e) {
            String msg = "Error Retreiving All Groups for User. User ID: " + userName;
            logger.error(msg, (Throwable)e);
            AiravataSystemException exception = new AiravataSystemException(AiravataErrorType.INTERNAL_ERROR);
            exception.setMessage(msg + " More info : " + e.getMessage());
            throw exception;
        }
    }

    private void submitExperiment(String gatewayId, String experimentId) throws AiravataException {
        ExperimentSubmitEvent event = new ExperimentSubmitEvent(experimentId, gatewayId);
        MessageContext messageContext = new MessageContext((TBase)event, MessageType.EXPERIMENT, "LAUNCH.EXP-" + UUID.randomUUID().toString(), gatewayId);
        messageContext.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
        this.experimentPublisher.publish(messageContext);
    }

    private void submitCancelExperiment(String gatewayId, String experimentId) throws AiravataException {
        ExperimentSubmitEvent event = new ExperimentSubmitEvent(experimentId, gatewayId);
        MessageContext messageContext = new MessageContext((TBase)event, MessageType.EXPERIMENT_CANCEL, "CANCEL.EXP-" + UUID.randomUUID().toString(), gatewayId);
        messageContext.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
        this.experimentPublisher.publish(messageContext);
    }

    private CredentialStoreService.Client getCredentialStoreServiceClient() throws TException, ApplicationSettingsException {
        int serverPort = Integer.parseInt(ServerSettings.getCredentialStoreServerPort());
        String serverHost = ServerSettings.getCredentialStoreServerHost();
        try {
            return CredentialStoreClientFactory.createAiravataCSClient((String)serverHost, (int)serverPort);
        }
        catch (CredentialStoreException e) {
            throw new TException("Unable to create credential store client...", (Throwable)e);
        }
    }

    private RegistryService.Client getRegistryServiceClient() throws TException, ApplicationSettingsException {
        int serverPort = Integer.parseInt(ServerSettings.getRegistryServerPort());
        String serverHost = ServerSettings.getRegistryServerHost();
        try {
            return RegistryServiceClientFactory.createRegistryClient((String)serverHost, (int)serverPort);
        }
        catch (RegistryServiceException e) {
            throw new TException("Unable to create registry client...", (Throwable)e);
        }
    }

    private SharingRegistryService.Client getSharingRegistryServiceClient() throws TException, ApplicationSettingsException {
        int serverPort = Integer.parseInt(ServerSettings.getSharingRegistryPort());
        String serverHost = ServerSettings.getSharingRegistryHost();
        try {
            return SharingRegistryServiceClientFactory.createSharingRegistryClient((String)serverHost, (int)serverPort);
        }
        catch (SharingRegistryException e) {
            throw new TException("Unable to create sharing registry client...", (Throwable)e);
        }
    }
}

