/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NormalizeSpace_1
extends SystemFunctionCall
implements Callable {
    public int getIntrinsicDependencies() {
        int d = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            d |= 2;
        }
        return d;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (this.argument.length == 0 && contextInfo == null) {
            XPathException err = new XPathException("The context item for normalize-space() is absent");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return super.typeCheck(visitor, contextInfo);
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return Literal.makeLiteral((AtomicValue)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext()), this.getContainer());
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        StringValue sv = (StringValue)this.argument[0].evaluateItem(c);
        return NormalizeSpace_1.normalizeSpace(sv);
    }

    public static StringValue normalizeSpace(StringValue sv) {
        if (sv == null) {
            return StringValue.EMPTY_STRING;
        }
        return StringValue.makeStringValue(Whitespace.collapseWhitespace(sv.getStringValueCS()));
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        AtomicValue sv = (AtomicValue)this.argument[0].evaluateItem(c);
        if (sv == null) {
            return false;
        }
        CharSequence cs = sv.getStringValueCS();
        return !Whitespace.isWhite(cs);
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return NormalizeSpace_1.normalizeSpace((StringValue)arguments[0].head());
    }
}

