/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.impl;

import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.registry.core.app.catalog.impl.AppCatalogImpl;
import org.apache.airavata.registry.core.experiment.catalog.impl.ExperimentCatalogImpl;
import org.apache.airavata.registry.core.impl.RegistryImpl;
import org.apache.airavata.registry.core.replica.catalog.impl.ReplicaCatalogImpl;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.Registry;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.ReplicaCatalog;
import org.apache.airavata.registry.cpi.ReplicaCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryFactory {
    private static ExperimentCatalog experimentCatalog;
    private static AppCatalog appCatalog;
    private static ReplicaCatalog replicaCatalog;
    private static Registry registry;
    private static Logger logger;

    public static Registry getRegistry() throws RegistryException {
        try {
            if (registry == null) {
                registry = new RegistryImpl();
            }
        }
        catch (Exception e) {
            logger.error("Unable to create registry instance", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return registry;
    }

    public static ExperimentCatalog getExperimentCatalog(String gateway, String username, String password) throws RegistryException {
        try {
            if (experimentCatalog == null) {
                experimentCatalog = new ExperimentCatalogImpl(gateway, username, password);
            }
        }
        catch (RegistryException e) {
            logger.error("Unable to create experiment catalog instance", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experimentCatalog;
    }

    public static ExperimentCatalog getExperimentCatalog(String gateway) throws RegistryException {
        try {
            if (experimentCatalog == null) {
                experimentCatalog = new ExperimentCatalogImpl(gateway, ServerSettings.getDefaultUser(), ServerSettings.getDefaultUserPassword());
            }
        }
        catch (RegistryException e) {
            logger.error("Unable to create experiment catalog instance", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        catch (ApplicationSettingsException e) {
            logger.error("Unable to create experiment catalog instance", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experimentCatalog;
    }

    public static ExperimentCatalog getDefaultExpCatalog() throws RegistryException {
        try {
            if (experimentCatalog == null) {
                experimentCatalog = new ExperimentCatalogImpl();
            }
        }
        catch (RegistryException e) {
            logger.error("Unable to create experiment catalog instance", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experimentCatalog;
    }

    public static AppCatalog getAppCatalog() throws AppCatalogException {
        try {
            if (appCatalog == null) {
                appCatalog = new AppCatalogImpl();
            }
        }
        catch (Exception e) {
            logger.error("Unable to create app catalog instance", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return appCatalog;
    }

    public static ReplicaCatalog getReplicaCatalog() throws ReplicaCatalogException {
        try {
            if (replicaCatalog == null) {
                replicaCatalog = new ReplicaCatalogImpl();
            }
        }
        catch (Exception e) {
            logger.error("Unable to create data catalog instance", (Throwable)e);
            throw new ReplicaCatalogException((Throwable)e);
        }
        return replicaCatalog;
    }

    static {
        logger = LoggerFactory.getLogger(RegistryFactory.class);
    }
}

