/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationDeployment;
import org.apache.airavata.registry.core.app.catalog.model.ApplicationModule;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppModuleResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDeploymentResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(AppDeploymentResource.class);
    private String deploymentId;
    private String appModuleId;
    private String hostId;
    private String executablePath;
    private String parallelism;
    private String appDes;
    private String gatewayId;
    private String defaultQueueName;
    private int defaultNodeCount;
    private int defaultCPUCount;
    private int defaultWalltime;
    private boolean editableByUser;
    private ComputeResourceResource hostResource;
    private AppModuleResource moduleResource;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getAppModuleId() {
        return this.appModuleId;
    }

    public void setAppModuleId(String appModuleId) {
        this.appModuleId = appModuleId;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getExecutablePath() {
        return this.executablePath;
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public String getAppDes() {
        return this.appDes;
    }

    public void setAppDes(String appDes) {
        this.appDes = appDes;
    }

    public ComputeResourceResource getHostResource() {
        return this.hostResource;
    }

    public void setHostResource(ComputeResourceResource hostResource) {
        this.hostResource = hostResource;
    }

    public AppModuleResource getModuleResource() {
        return this.moduleResource;
    }

    public void setModuleResource(AppModuleResource moduleResource) {
        this.moduleResource = moduleResource;
    }

    public String getDefaultQueueName() {
        return this.defaultQueueName;
    }

    public void setDefaultQueueName(String defaultQueueName) {
        this.defaultQueueName = defaultQueueName;
    }

    public int getDefaultNodeCount() {
        return this.defaultNodeCount;
    }

    public void setDefaultNodeCount(int defaultNodeCount) {
        this.defaultNodeCount = defaultNodeCount;
    }

    public int getDefaultCPUCount() {
        return this.defaultCPUCount;
    }

    public void setDefaultCPUCount(int defaultCPUCount) {
        this.defaultCPUCount = defaultCPUCount;
    }

    public boolean isEditableByUser() {
        return this.editableByUser;
    }

    public void setEditableByUser(boolean editableByUser) {
        this.editableByUser = editableByUser;
    }

    public int getDefaultWalltime() {
        return this.defaultWalltime;
    }

    public void setDefaultWalltime(int defaultWalltime) {
        this.defaultWalltime = defaultWalltime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationDeployment", new Object[0][]);
            generator.setParameter("deploymentID", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationDeployment", new Object[0][]);
            generator.setParameter("deploymentID", identifier);
            Query q = generator.selectQuery(em);
            ApplicationDeployment deployment = (ApplicationDeployment)q.getSingleResult();
            AppDeploymentResource deploymentResource = (AppDeploymentResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_DEPLOYMENT, deployment);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            AppDeploymentResource appDeploymentResource = deploymentResource;
            return appDeploymentResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> appDeployments = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationDeployment", new Object[0][]);
            if (fieldName.equals("appModuleID")) {
                generator.setParameter("appModuleID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationDeployment deployment = (ApplicationDeployment)result;
                        AppDeploymentResource deploymentResource = (AppDeploymentResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_DEPLOYMENT, deployment);
                        appDeployments.add(deploymentResource);
                    }
                }
            } else if (fieldName.equals("hostID")) {
                generator.setParameter("hostID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationDeployment deployment = (ApplicationDeployment)result;
                        AppDeploymentResource deploymentResource = (AppDeploymentResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_DEPLOYMENT, deployment);
                        appDeployments.add(deploymentResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for app deployment resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for app deployment resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return appDeployments;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        ArrayList<AppCatalogResource> appDeployments = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationDeployment", new Object[0][]);
            generator.setParameter("gatewayId", this.gatewayId);
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            if (results.size() != 0) {
                for (Object result : results) {
                    ApplicationDeployment deployment = (ApplicationDeployment)result;
                    AppDeploymentResource deploymentResource = (AppDeploymentResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.APPLICATION_DEPLOYMENT, deployment);
                    appDeployments.add(deploymentResource);
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return appDeployments;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        ArrayList<String> appDeployments = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationDeployment", new Object[0][]);
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            if (results.size() != 0) {
                for (Object result : results) {
                    ApplicationDeployment deployment = (ApplicationDeployment)result;
                    appDeployments.add(deployment.getDeploymentID());
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return appDeployments;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> appDeployments = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ApplicationDeployment", new Object[0][]);
            if (fieldName.equals("appModuleID")) {
                generator.setParameter("appModuleID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationDeployment deployment = (ApplicationDeployment)result;
                        appDeployments.add(deployment.getDeploymentID());
                    }
                }
            } else if (fieldName.equals("hostID")) {
                generator.setParameter("hostID", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        ApplicationDeployment deployment = (ApplicationDeployment)result;
                        appDeployments.add(deployment.getDeploymentID());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for app deployment resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for app deployment resource.");
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return appDeployments;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ApplicationDeployment existingDeployment = (ApplicationDeployment)em.find(ApplicationDeployment.class, (Object)this.deploymentId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            ApplicationModule applicationModule = (ApplicationModule)em.find(ApplicationModule.class, (Object)this.appModuleId);
            ComputeResource computeHost = (ComputeResource)em.find(ComputeResource.class, (Object)this.hostId);
            if (existingDeployment != null) {
                existingDeployment.setDeploymentID(this.deploymentId);
                existingDeployment.setApplicationDesc(this.appDes);
                existingDeployment.setAppModuleID(this.appModuleId);
                existingDeployment.setApplicationModule(applicationModule);
                existingDeployment.setComputeResource(computeHost);
                existingDeployment.setHostID(this.hostId);
                existingDeployment.setExecutablePath(this.executablePath);
                existingDeployment.setParallelism(this.parallelism);
                existingDeployment.setGatewayId(this.gatewayId);
                existingDeployment.setDefaultQueueName(this.defaultQueueName);
                existingDeployment.setDefaultCPUCount(this.defaultCPUCount);
                existingDeployment.setDefaultNodeCount(this.defaultNodeCount);
                existingDeployment.setDefaultWalltime(this.defaultWalltime);
                existingDeployment.setEditableByUser(this.editableByUser);
                existingDeployment.setUpdateTime(AiravataUtils.getCurrentTimestamp());
                em.merge((Object)existingDeployment);
            } else {
                ApplicationDeployment deployment = new ApplicationDeployment();
                deployment.setApplicationDesc(this.appDes);
                deployment.setDeploymentID(this.deploymentId);
                deployment.setAppModuleID(this.appModuleId);
                deployment.setHostID(this.hostId);
                deployment.setApplicationModule(applicationModule);
                deployment.setComputeResource(computeHost);
                deployment.setExecutablePath(this.executablePath);
                deployment.setParallelism(this.parallelism);
                deployment.setGatewayId(this.gatewayId);
                deployment.setDefaultQueueName(this.defaultQueueName);
                deployment.setDefaultCPUCount(this.defaultCPUCount);
                deployment.setDefaultNodeCount(this.defaultNodeCount);
                deployment.setDefaultWalltime(this.defaultWalltime);
                deployment.setEditableByUser(this.editableByUser);
                deployment.setCreationTime(AiravataUtils.getCurrentTimestamp());
                em.persist((Object)deployment);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ApplicationDeployment deployment = (ApplicationDeployment)em.find(ApplicationDeployment.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = deployment != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(String parallelism) {
        this.parallelism = parallelism;
    }
}

