/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.proxy.ProxyACExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyAddressRestrictionData;
import eu.emi.security.authn.x509.helpers.proxy.ProxyCertInfoExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyCertificateImpl;
import eu.emi.security.authn.x509.helpers.proxy.ProxySAMLExtension;
import eu.emi.security.authn.x509.helpers.proxy.ProxyTracingExtension;
import eu.emi.security.authn.x509.helpers.proxy.X509v3CertificateBuilder;
import eu.emi.security.authn.x509.proxy.BaseProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.CertificateExtension;
import eu.emi.security.authn.x509.proxy.ProxyCertificate;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import eu.emi.security.authn.x509.proxy.ProxyRequestOptions;
import eu.emi.security.authn.x509.proxy.ProxyType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class ProxyGeneratorHelper {
    private SubjectPublicKeyInfo proxyPublicKeyInfo = null;
    private transient PrivateKey proxyPrivateKey = null;
    private X509v3CertificateBuilder certBuilder;
    private X509Certificate proxy;

    public ProxyCertificate generate(ProxyCertificateOptions param, PrivateKey privateKey) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateParsingException, IOException {
        this.establishKeys(param);
        return this.generateCommon(param, privateKey);
    }

    public X509Certificate[] generate(ProxyRequestOptions param, PrivateKey privateKey) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateParsingException, IOException {
        PKCS10CertificationRequest csr = param.getProxyRequest();
        this.proxyPublicKeyInfo = csr.getSubjectPublicKeyInfo();
        return this.generateCommon(param, privateKey).getCertificateChain();
    }

    private ProxyCertificate generateCommon(BaseProxyCertificateOptions param, PrivateKey privateKey) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateParsingException, IOException {
        this.setupCertBuilder(param);
        this.addExtensions(param);
        try {
            this.buildCertificate(param.getParentCertChain()[0], privateKey);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Default signature provider is not available? A bug or serious JDK misconfiguration.", e);
        }
        catch (IOException e) {
            throw new CertificateParsingException("Can not encode the certificate to the binary DER form", e);
        }
        return this.wrapResult(param.getParentCertChain());
    }

    private void establishKeys(ProxyCertificateOptions param) throws InvalidKeyException {
        PublicKey proxyPublicKey = param.getPublicKey();
        this.proxyPrivateKey = null;
        if (proxyPublicKey == null) {
            KeyPair pair = ProxyGeneratorHelper.generateKeyPair(param.getKeyLength());
            proxyPublicKey = pair.getPublic();
            this.proxyPrivateKey = pair.getPrivate();
        }
        try {
            this.proxyPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(proxyPublicKey.getEncoded()).readObject());
        }
        catch (IOException e) {
            throw new InvalidKeyException("Can not parse the public keybeing included in the proxy certificate", e);
        }
    }

    private void setupCertBuilder(BaseProxyCertificateOptions param) throws InvalidKeyException {
        X509Certificate issuingCert = param.getParentCertChain()[0];
        Date notBefore = param.getNotBefore();
        Date notAfter = new Date(notBefore.getTime() + (long)param.getLifetime() * 1000L);
        BigInteger serial = ProxyGeneratorHelper.establishSerial(param);
        X500Name issuer = CertificateHelpers.toX500Name(issuingCert.getSubjectX500Principal());
        X500Name subject = ProxyGeneratorHelper.generateDN(issuingCert.getSubjectX500Principal(), param.getType(), param.isLimited(), serial);
        this.certBuilder = new X509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, this.proxyPublicKeyInfo);
    }

    public static Integer getChainKeyUsage(X509Certificate[] chain) {
        int flags = 33023;
        boolean found = false;
        for (X509Certificate cert : chain) {
            boolean[] certKu;
            if (cert.getBasicConstraints() != -1 || (certKu = cert.getKeyUsage()) == null) continue;
            found = true;
            int certKuInt = 0;
            for (int i = 0; i < certKu.length; ++i) {
                if (!certKu[i]) continue;
                int bit = i == 8 ? 32768 : 1 << 7 - i;
                certKuInt |= bit;
            }
            flags &= certKuInt;
        }
        return found ? Integer.valueOf(flags) : null;
    }

    private KeyUsage establishKeyUsage(BaseProxyCertificateOptions param) {
        Integer parentKU = ProxyGeneratorHelper.getChainKeyUsage(param.getParentCertChain());
        int retMask = parentKU == null ? (param.getProxyKeyUsageMask() < 0 ? 176 : param.getProxyKeyUsageMask()) : (param.getProxyKeyUsageMask() < 0 ? parentKU : param.getProxyKeyUsageMask() & parentKU);
        return new KeyUsage(retMask);
    }

    private void addExtensions(BaseProxyCertificateOptions param) throws IOException {
        ASN1Object extValue;
        ASN1Object extValue2;
        KeyUsage ks = this.establishKeyUsage(param);
        this.certBuilder.addExtension(X509Extension.keyUsage, true, (ASN1Object)ks);
        if (param.getType() != ProxyType.LEGACY) {
            ProxyPolicy policy = param.getPolicy();
            if (policy == null) {
                policy = new ProxyPolicy("1.3.6.1.5.5.7.21.1");
            }
            String oid = param.getType() == ProxyType.DRAFT_RFC ? "1.3.6.1.4.1.3536.1.222" : "1.3.6.1.5.5.7.1.14";
            extValue2 = new ProxyCertInfoExtension(param.getProxyPathLimit(), policy);
            this.certBuilder.addExtension(new ASN1ObjectIdentifier(oid), true, extValue2);
        }
        if (param.getProxyTracingIssuer() != null) {
            extValue = new ProxyTracingExtension(param.getProxyTracingIssuer());
            this.certBuilder.addExtension(new ASN1ObjectIdentifier("1.2.840.113612.5.5.1.1.1.1"), false, extValue);
        }
        if (param.getProxyTracingSubject() != null) {
            extValue = new ProxyTracingExtension(param.getProxyTracingSubject());
            this.certBuilder.addExtension(new ASN1ObjectIdentifier("1.2.840.113612.5.5.1.1.1.2"), false, extValue);
        }
        if (param.getSAMLAssertion() != null) {
            extValue = new ProxySAMLExtension(param.getSAMLAssertion());
            this.certBuilder.addExtension(new ASN1ObjectIdentifier("1.3.6.1.4.1.3536.1.1.1.12"), false, extValue);
        }
        if (param.getAttributeCertificates() != null) {
            extValue = new ProxyACExtension(param.getAttributeCertificates());
            this.certBuilder.addExtension(new ASN1ObjectIdentifier("1.3.6.1.4.1.8005.100.100.5"), false, extValue);
        }
        String[] srcExcl = param.getSourceRestrictionExcludedAddresses();
        String[] srcPerm = param.getSourceRestrictionPermittedAddresses();
        if (srcExcl != null || srcPerm != null) {
            extValue2 = new ProxyAddressRestrictionData();
            if (srcExcl != null) {
                for (String addr : srcExcl) {
                    extValue2.addExcludedIPAddressWithNetmask(addr);
                }
            }
            if (srcPerm != null) {
                for (String addr : srcPerm) {
                    extValue2.addPermittedIPAddressWithNetmask(addr);
                }
            }
            this.certBuilder.addExtension(new ASN1ObjectIdentifier("1.2.840.113612.5.5.1.1.2.1"), false, extValue2);
        }
        String[] tgtExcl = param.getTargetRestrictionExcludedAddresses();
        String[] tgtPerm = param.getTargetRestrictionPermittedAddresses();
        if (tgtExcl != null || tgtPerm != null) {
            ProxyAddressRestrictionData extValue3 = new ProxyAddressRestrictionData();
            if (tgtExcl != null) {
                String[] arr$ = tgtExcl;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String addr = arr$[i$];
                    extValue3.addExcludedIPAddressWithNetmask(addr);
                }
            }
            if (tgtPerm != null) {
                for (String addr : tgtPerm) {
                    extValue3.addPermittedIPAddressWithNetmask(addr);
                }
            }
            this.certBuilder.addExtension(new ASN1ObjectIdentifier("1.2.840.113612.5.5.1.1.2.2"), false, extValue3);
        }
        List<CertificateExtension> additionalExts = param.getExtensions();
        for (CertificateExtension ext : additionalExts) {
            this.certBuilder.addExtension(new ASN1ObjectIdentifier(ext.getOid()), ext.isCritical(), (ASN1Object)ext.getValue());
        }
    }

    private void buildCertificate(X509Certificate issuingCert, PrivateKey privateKey) throws CertificateParsingException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, IOException {
        AlgorithmIdentifier sigAlg;
        try {
            sigAlg = X509v3CertificateBuilder.extractAlgorithmId(issuingCert);
        }
        catch (IOException e) {
            throw new CertificateParsingException("Can not parse parameters of the public key contained in the issuer certificate", e);
        }
        String sigAlgName = issuingCert.getSigAlgName();
        this.proxy = this.certBuilder.build(privateKey, sigAlg, sigAlgName, null, null);
    }

    private ProxyCertificate wrapResult(X509Certificate[] originalChain) throws InvalidKeyException {
        X509Certificate[] extendedChain = new X509Certificate[originalChain.length + 1];
        for (int i = 0; i < originalChain.length; ++i) {
            extendedChain[i + 1] = originalChain[i];
        }
        extendedChain[0] = this.proxy;
        if (this.proxyPrivateKey != null) {
            try {
                return new ProxyCertificateImpl(extendedChain, this.proxyPrivateKey);
            }
            catch (KeyStoreException e) {
                throw new InvalidKeyException("The generated private key is unsupported, bug?", e);
            }
        }
        return new ProxyCertificateImpl(extendedChain);
    }

    public static BigInteger establishSerial(BaseProxyCertificateOptions param) {
        if (param.getType() == ProxyType.LEGACY) {
            return param.getParentCertChain()[0].getSerialNumber();
        }
        if (param.getSerialNumber() != null) {
            return param.getSerialNumber();
        }
        SecureRandom rand = new SecureRandom();
        return BigInteger.valueOf(rand.nextInt()).abs();
    }

    public static X500Name generateDN(X500Principal parentSubject, ProxyType type, boolean limited, BigInteger serial) {
        String cn = type == ProxyType.LEGACY ? (limited ? "limited proxy" : "proxy") : serial.toString();
        X500Name dn = CertificateHelpers.toX500Name(parentSubject);
        AttributeTypeAndValue ava = new AttributeTypeAndValue(BCStyle.CN, (ASN1Encodable)new DERPrintableString(cn));
        RDN added = new RDN(ava);
        RDN[] orig = dn.getRDNs();
        RDN[] proxyRDNs = new RDN[orig.length + 1];
        for (int i = 0; i < orig.length; ++i) {
            proxyRDNs[i] = orig[i];
        }
        proxyRDNs[orig.length] = added;
        return new X500Name(proxyRDNs);
    }

    public static KeyPair generateKeyPair(int len) {
        KeyPairGenerator kpGen;
        try {
            kpGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("RSA algorithm not supported!?", e);
        }
        kpGen.initialize(len, new SecureRandom());
        return kpGen.generateKeyPair();
    }
}

