/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.selector;

import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.jms.selector.filter.BooleanExpression;
import org.apache.qpid.jms.selector.filter.FilterException;
import org.apache.qpid.jms.selector.parser.SelectorParserImpl;
import org.apache.qpid.jms.util.LRUCache;

public class SelectorParser {
    private static final Map<String, Object> cache = Collections.synchronizedMap(new LRUCache(100));

    public static BooleanExpression parse(String sql) throws FilterException {
        Object result = cache.get(sql);
        if (result instanceof FilterException) {
            throw (FilterException)result;
        }
        if (result instanceof BooleanExpression) {
            return (BooleanExpression)result;
        }
        try {
            BooleanExpression e = null;
            SelectorParserImpl parser = new SelectorParserImpl(new StringReader(sql));
            e = parser.JmsSelector();
            cache.put(sql, e);
            return e;
        }
        catch (Throwable e) {
            FilterException fe = new FilterException(sql, e);
            cache.put(sql, fe);
            throw fe;
        }
    }

    public static void clearCache() {
        cache.clear();
    }
}

