/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.meta.JmsAbstractResourceId;
import org.apache.qpid.jms.meta.JmsSessionId;

public final class JmsProducerId
extends JmsAbstractResourceId
implements Comparable<JmsProducerId> {
    private String connectionId;
    private long sessionId;
    private long value;
    private transient String key;
    private transient JmsSessionId parentId;

    public JmsProducerId(JmsSessionId sessionId, long producerId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Session ID cannot be null");
        }
        this.connectionId = sessionId.getConnectionId();
        this.sessionId = sessionId.getValue();
        this.value = producerId;
        this.parentId = sessionId;
    }

    public JmsProducerId(JmsProducerId id) {
        if (id == null) {
            throw new IllegalArgumentException("Producer ID cannot be null");
        }
        this.connectionId = id.getConnectionId();
        this.sessionId = id.getSessionId();
        this.value = id.getValue();
        this.parentId = id.getParentId();
    }

    public JmsProducerId(String connectionId, long sessionId, long producerId) {
        if (connectionId == null || connectionId.isEmpty()) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        this.connectionId = connectionId;
        this.sessionId = sessionId;
        this.value = producerId;
    }

    public JmsProducerId(String producerKey) {
        if (producerKey == null || producerKey.isEmpty()) {
            throw new IllegalArgumentException("Producer Key cannot be null or empty");
        }
        int p = producerKey.lastIndexOf(":");
        if (p >= 0) {
            this.value = Long.parseLong(producerKey.substring(p + 1));
            producerKey = producerKey.substring(0, p);
        }
        this.setProducerSessionKey(producerKey);
    }

    public JmsSessionId getParentId() {
        if (this.parentId == null) {
            this.parentId = new JmsSessionId(this);
        }
        return this.parentId;
    }

    private void setProducerSessionKey(String sessionKey) {
        int p = sessionKey.lastIndexOf(":");
        if (p >= 0) {
            this.sessionId = Long.parseLong(sessionKey.substring(p + 1));
            sessionKey = sessionKey.substring(0, p);
        }
        this.connectionId = sessionKey;
        this.parentId = new JmsSessionId(this.connectionId, this.sessionId);
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public long getValue() {
        return this.value;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        if (this.key == null) {
            this.key = this.connectionId + ":" + this.sessionId + ":" + this.value;
        }
        return this.key;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = 31 * this.hashCode + this.connectionId.hashCode();
            this.hashCode = 31 * this.hashCode + (int)(this.sessionId ^ this.sessionId >>> 32);
            this.hashCode = 31 * this.hashCode + (int)(this.value ^ this.value >>> 32);
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != JmsProducerId.class) {
            return false;
        }
        JmsProducerId id = (JmsProducerId)o;
        return this.sessionId == id.sessionId && this.value == id.value && this.connectionId.equals(id.connectionId);
    }

    @Override
    public int compareTo(JmsProducerId other) {
        return this.toString().compareTo(other.toString());
    }
}

