/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.JMSException;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsSession;
import org.apache.qpid.jms.JmsTransactionContext;
import org.apache.qpid.jms.JmsTransactionListener;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsResourceId;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsLocalTransactionContext
implements JmsTransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(JmsLocalTransactionContext.class);
    private final Map<JmsResourceId, JmsResourceId> participants = Collections.synchronizedMap(new HashMap());
    private final JmsSession session;
    private final JmsConnection connection;
    private JmsTransactionInfo transactionInfo;
    private JmsTransactionListener listener;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public JmsLocalTransactionContext(JmsSession session) {
        this.session = session;
        this.connection = session.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(JmsConnection connection, final JmsOutboundMessageDispatch envelope, final ProviderSynchronization outcome) throws JMSException {
        this.lock.readLock().lock();
        try {
            if (this.isInDoubt()) {
                this.participants.put(envelope.getProducerId(), envelope.getProducerId());
                if (outcome != null) {
                    outcome.onPendingSuccess();
                }
                if (envelope.isCompletionRequired()) {
                    connection.onCompletedMessageSend(envelope);
                }
                return;
            }
            connection.send(envelope, new ProviderSynchronization(){

                @Override
                public void onPendingSuccess() {
                    LOG.trace("TX:{} has performed a send.", (Object)JmsLocalTransactionContext.this.getTransactionId());
                    JmsLocalTransactionContext.this.participants.put(envelope.getProducerId(), envelope.getProducerId());
                    if (outcome != null) {
                        outcome.onPendingSuccess();
                    }
                }

                @Override
                public void onPendingFailure(ProviderException cause) {
                    LOG.trace("TX:{} has a failed send.", (Object)JmsLocalTransactionContext.this.getTransactionId());
                    JmsLocalTransactionContext.this.participants.put(envelope.getProducerId(), envelope.getProducerId());
                    if (outcome != null) {
                        outcome.onPendingFailure(cause);
                    }
                }
            });
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(JmsConnection connection, final JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType) throws JMSException {
        if (ackType == ProviderConstants.ACK_TYPE.ACCEPTED || ackType == ProviderConstants.ACK_TYPE.DELIVERED) {
            this.lock.readLock().lock();
            try {
                connection.acknowledge(envelope, ackType, new ProviderSynchronization(){

                    @Override
                    public void onPendingSuccess() {
                        LOG.trace("TX:{} has performed a acknowledge.", (Object)JmsLocalTransactionContext.this.getTransactionId());
                        JmsLocalTransactionContext.this.participants.put(envelope.getConsumerId(), envelope.getConsumerId());
                    }

                    @Override
                    public void onPendingFailure(ProviderException cause) {
                        LOG.trace("TX:{} has failed a acknowledge.", (Object)JmsLocalTransactionContext.this.getTransactionId());
                        JmsLocalTransactionContext.this.participants.put(envelope.getConsumerId(), envelope.getConsumerId());
                    }
                });
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            connection.acknowledge(envelope, ackType);
        }
    }

    @Override
    public boolean isInDoubt() {
        return this.transactionInfo != null ? this.transactionInfo.isInDoubt() : false;
    }

    @Override
    public void begin() throws JMSException {
        this.lock.writeLock().lock();
        try {
            this.reset();
            final JmsTransactionInfo transactionInfo = this.getNextTransactionInfo();
            LOG.debug("Initiating Begin of txn: {}", (Object)transactionInfo.getId());
            this.connection.createResource(transactionInfo, new ProviderSynchronization(){

                @Override
                public void onPendingSuccess() {
                    JmsLocalTransactionContext.this.transactionInfo = transactionInfo;
                }

                @Override
                public void onPendingFailure(ProviderException cause) {
                    JmsLocalTransactionContext.this.transactionInfo = transactionInfo;
                    transactionInfo.setInDoubt(true);
                }
            });
            if (this.listener != null) {
                try {
                    this.listener.onTransactionStarted();
                }
                catch (Throwable error) {
                    LOG.trace("Local TX listener error ignored: {}", error);
                }
            }
            LOG.trace("Completed Begin of txn: {}", (Object)transactionInfo.getId());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws JMSException {
        block23: {
            this.lock.writeLock().lock();
            try {
                if (this.isInDoubt()) {
                    try {
                        this.rollback();
                    }
                    catch (Exception e) {
                        LOG.trace("Error during rollback of failed TX: {}", (Throwable)e);
                    }
                    throw new TransactionRolledBackException("Transaction failed and has been rolled back.");
                }
                LOG.debug("Commit: {}", (Object)this.transactionInfo.getId());
                JmsTransactionId oldTransactionId = this.transactionInfo.getId();
                final JmsTransactionInfo nextTx = this.getNextTransactionInfo();
                try {
                    this.connection.commit(this.transactionInfo, nextTx, new ProviderSynchronization(){

                        @Override
                        public void onPendingSuccess() {
                            JmsLocalTransactionContext.this.reset();
                            JmsLocalTransactionContext.this.transactionInfo = nextTx;
                        }

                        @Override
                        public void onPendingFailure(ProviderException cause) {
                            JmsLocalTransactionContext.this.reset();
                            JmsLocalTransactionContext.this.transactionInfo = nextTx;
                        }
                    });
                    if (this.listener == null) break block23;
                    try {
                        this.listener.onTransactionCommitted();
                    }
                    catch (Throwable error) {
                        LOG.trace("Local TX listener error ignored: {}", error);
                    }
                    try {
                        this.listener.onTransactionStarted();
                    }
                    catch (Throwable error) {
                        LOG.trace("Local TX listener error ignored: {}", error);
                    }
                }
                catch (JMSException cause) {
                    LOG.info("Commit failed for transaction: {}", (Object)oldTransactionId);
                    if (this.listener != null) {
                        try {
                            this.listener.onTransactionRolledBack();
                        }
                        catch (Throwable error) {
                            LOG.trace("Local TX listener error ignored: {}", error);
                        }
                    }
                    throw cause;
                }
                finally {
                    try {
                        if (nextTx.getId().getProviderTxId() == null) {
                            this.begin();
                        }
                    }
                    catch (Exception e) {
                        LOG.info("Failed to start new Transaction after failed rollback of: {}", (Object)oldTransactionId);
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void rollback() throws JMSException {
        this.doRollback(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollback(boolean startNewTx) throws JMSException {
        block23: {
            this.lock.writeLock().lock();
            try {
                if (this.transactionInfo == null) {
                    return;
                }
                LOG.debug("Rollback: {}", (Object)this.transactionInfo.getId());
                JmsTransactionId oldTransactionId = this.transactionInfo.getId();
                final JmsTransactionInfo nextTx = startNewTx ? this.getNextTransactionInfo() : null;
                try {
                    this.connection.rollback(this.transactionInfo, nextTx, new ProviderSynchronization(){

                        @Override
                        public void onPendingSuccess() {
                            JmsLocalTransactionContext.this.reset();
                            JmsLocalTransactionContext.this.transactionInfo = nextTx;
                        }

                        @Override
                        public void onPendingFailure(ProviderException cause) {
                            JmsLocalTransactionContext.this.reset();
                            JmsLocalTransactionContext.this.transactionInfo = nextTx;
                        }
                    });
                    if (this.listener == null) break block23;
                    try {
                        this.listener.onTransactionRolledBack();
                    }
                    catch (Throwable error) {
                        LOG.trace("Local TX listener error ignored: {}", error);
                    }
                    try {
                        if (startNewTx) {
                            this.listener.onTransactionStarted();
                        }
                    }
                    catch (Throwable error) {
                        LOG.trace("Local TX listener error ignored: {}", error);
                    }
                }
                catch (JMSException cause) {
                    LOG.info("Rollback failed for transaction: {}", (Object)oldTransactionId);
                    if (this.listener != null) {
                        try {
                            this.listener.onTransactionRolledBack();
                        }
                        catch (Throwable error) {
                            LOG.trace("Local TX listener error ignored: {}", error);
                        }
                    }
                    throw cause;
                }
                finally {
                    try {
                        if (startNewTx && nextTx.getId().getProviderTxId() == null) {
                            this.begin();
                        }
                    }
                    catch (Exception e) {
                        LOG.info("Failed to start new Transaction after failed rollback of: {}", (Object)oldTransactionId);
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void shutdown() throws JMSException {
        this.doRollback(false);
    }

    @Override
    public void onConnectionInterrupted() {
        this.lock.writeLock().tryLock();
        try {
            if (this.transactionInfo != null) {
                this.transactionInfo.setInDoubt(true);
            }
        }
        finally {
            if (this.lock.writeLock().isHeldByCurrentThread()) {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void onConnectionRecovery(Provider provider) throws Exception {
        if (this.lock.writeLock().tryLock(5L, TimeUnit.MILLISECONDS)) {
            try {
                if (this.transactionInfo == null) {
                    LOG.trace("Transaction context skipping recovery because no transaction previously existed.");
                    return;
                }
                this.transactionInfo = this.getNextTransactionInfo();
                ProviderFuture request = provider.newProviderFuture(new ProviderSynchronization(){

                    @Override
                    public void onPendingSuccess() {
                        LOG.trace("TX:{} Recovery of Transaction succeeded: in-doubt state: {}.", (Object)JmsLocalTransactionContext.this.transactionInfo.getId(), (Object)(!JmsLocalTransactionContext.this.participants.isEmpty() ? 1 : 0));
                        JmsLocalTransactionContext.this.transactionInfo.setInDoubt(!JmsLocalTransactionContext.this.participants.isEmpty());
                    }

                    @Override
                    public void onPendingFailure(ProviderException cause) {
                        LOG.trace("TX:{} Recovery of Transaction failed and current state set to in-doubt: {}.", (Object)JmsLocalTransactionContext.this.transactionInfo.getId(), (Object)cause);
                        JmsLocalTransactionContext.this.transactionInfo.setInDoubt(true);
                    }
                });
                LOG.trace("Transaction recovery creating new TX:{} after failover.", (Object)this.transactionInfo.getId());
                provider.create(this.transactionInfo, request);
                request.sync();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else if (this.transactionInfo != null) {
            LOG.trace("Transaction recovery marking current TX:{} as in-doubt.", (Object)this.transactionInfo.getId());
            this.transactionInfo.setInDoubt(true);
        }
    }

    public String toString() {
        return "JmsLocalTransactionContext{ transactionId=" + String.valueOf(this.getTransactionId()) + " }";
    }

    @Override
    public JmsTransactionId getTransactionId() {
        return this.transactionInfo.getId();
    }

    @Override
    public JmsTransactionListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(JmsTransactionListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isInTransaction() {
        return true;
    }

    @Override
    public boolean isActiveInThisContext(JmsResourceId resouceId) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.participants.containsKey(resouceId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void reset() {
        this.participants.clear();
    }

    private JmsTransactionInfo getNextTransactionInfo() {
        JmsTransactionId transactionId = this.connection.getNextTransactionId();
        return new JmsTransactionInfo(this.session.getSessionId(), transactionId);
    }
}

