/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionConfigurationAbtract;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionProtocol;
import org.apache.activemq.artemis.cli.factory.ConnectionFactoryClosable;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.qpid.jms.JmsConnectionFactory;
import picocli.CommandLine;

public class ConnectionAbstract
extends ConnectionConfigurationAbtract {
    @CommandLine.Option(names={"--clientID"}, description={"ClientID set on the connection."})
    protected String clientID;
    @CommandLine.Option(names={"--protocol"}, description={"Protocol used. Valid values are ${COMPLETION-CANDIDATES}"}, converter={ConnectionProtocol.ProtocolConverter.class})
    protected ConnectionProtocol protocol = ConnectionProtocol.CORE;

    public String getClientID() {
        return this.clientID;
    }

    public ConnectionAbstract setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public ConnectionProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ConnectionProtocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = ConnectionProtocol.fromString(protocol);
    }

    protected ConnectionFactoryClosable createConnectionFactory() throws Exception {
        this.recoverConnectionInformation();
        return this.createConnectionFactory(this.brokerURL, this.user, this.password, this.clientID, this.protocol);
    }

    protected ConnectionFactoryClosable createConnectionFactory(String brokerURL, String user, String password, String clientID, ConnectionProtocol protocol) throws Exception {
        if (protocol == ConnectionProtocol.CORE) {
            return new ConnectionFactoryClosable((ConnectionFactory)this.createCoreConnectionFactory(brokerURL, user, password, clientID));
        }
        if (protocol == ConnectionProtocol.AMQP) {
            return new ConnectionFactoryClosable(this.createAMQPConnectionFactory(brokerURL, user, password, clientID));
        }
        throw new IllegalStateException("protocol " + String.valueOf((Object)protocol) + " not supported");
    }

    private ConnectionFactory createAMQPConnectionFactory(String brokerURL, String user, String password, String clientID) {
        if (((String)brokerURL).startsWith("tcp://")) {
            brokerURL = "amqp" + ((String)brokerURL).substring(3);
        }
        JmsConnectionFactory cf = new JmsConnectionFactory(user, password, (String)brokerURL);
        if (clientID != null) {
            cf.setClientID(clientID);
        }
        try {
            this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            return cf;
        }
        catch (JMSSecurityException e) {
            this.getActionContext().err.println("Connection failed::" + e.getMessage());
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new JmsConnectionFactory(user, password, (String)brokerURL);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            try {
                this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
        catch (JMSException e) {
            this.getActionContext().err.println("Connection failed::" + e.getMessage());
            brokerURL = this.inputBrokerURL((String)brokerURL);
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new JmsConnectionFactory(user, password, (String)brokerURL);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            try {
                this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
    }

    protected ActiveMQConnectionFactory createCoreConnectionFactory() {
        this.recoverConnectionInformation();
        return this.createCoreConnectionFactory(this.brokerURL, this.user, this.password, this.clientID);
    }

    protected ActiveMQConnectionFactory createCoreConnectionFactory(String brokerURL, String user, String password, String clientID) {
        if (((String)brokerURL).startsWith("amqp://")) {
            brokerURL = "tcp" + ((String)brokerURL).substring(4);
        }
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory((String)brokerURL, user, password);
        if (clientID != null) {
            this.getActionContext().out.println("Consumer:: clientID = " + clientID);
            cf.setClientID(clientID);
        }
        try {
            this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            return cf;
        }
        catch (JMSSecurityException e) {
            if (this.getActionContext() != null) {
                this.getActionContext().err.println("Connection failed::" + e.getMessage());
            }
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new ActiveMQConnectionFactory((String)brokerURL, user, password);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            try {
                this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
        catch (JMSException e) {
            if (this.getActionContext() != null) {
                this.getActionContext().err.println("Connection failed::" + e.getMessage());
            }
            brokerURL = this.inputBrokerURL((String)brokerURL);
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new ActiveMQConnectionFactory((String)brokerURL, user, password);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            try {
                this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
    }

    protected void tryConnect(String brokerURL, String user, String password, ConnectionFactory cf) throws JMSException {
        Connection connection = cf.createConnection();
        connection.close();
        this.saveConnectionInfo(brokerURL, user, password);
    }

    protected void performCoreManagement(ManagementHelper.MessageAcceptor setup, ManagementHelper.MessageAcceptor ok, ManagementHelper.MessageAcceptor failed) throws Exception {
        try (ActiveMQConnectionFactory factory = this.createCoreConnectionFactory();){
            ManagementHelper.doManagement((ServerLocator)factory.getServerLocator(), (String)this.user, (String)this.password, (ManagementHelper.MessageAcceptor)setup, (ManagementHelper.MessageAcceptor)ok, (ManagementHelper.MessageAcceptor)failed);
        }
    }

    protected void performCoreManagement(String uri, String user, String password, ManagementHelper.MessageAcceptor setup, ManagementHelper.MessageAcceptor ok, ManagementHelper.MessageAcceptor failed) throws Exception {
        try (ActiveMQConnectionFactory factory = this.createCoreConnectionFactory(uri, user, password, this.clientID);){
            ManagementHelper.doManagement((ServerLocator)factory.getServerLocator(), (String)user, (String)password, (ManagementHelper.MessageAcceptor)setup, (ManagementHelper.MessageAcceptor)ok, (ManagementHelper.MessageAcceptor)failed);
        }
    }
}

