/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQPFederationAddressBindingsConsumer
extends AMQPFederationAddressConsumer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Set<Binding> bindings = new ConcurrentHashSet();
    private final PostOffice postOffice;
    private final StorageManager storageManager;

    public AMQPFederationAddressBindingsConsumer(AMQPFederationAddressPolicyManager manager, AMQPFederationConsumerConfiguration configuration, AMQPSessionContext session, FederationConsumerInfo consumerInfo, AMQPFederationMetrics.ConsumerMetrics metrics) {
        super(manager, configuration, session, consumerInfo, metrics);
        this.postOffice = manager.getFederation().getServer().getPostOffice();
        this.storageManager = this.federation.getServer().getStorageManager();
    }

    @Override
    protected AMQPFederationAddressConsumer.AMQPFederatedAddressDeliveryHandler createDeliveryHandler(Receiver receiver) {
        return new AMQPFederatedAddressBindingsDeliveryReceiver(this.session, this.consumerInfo, receiver);
    }

    public void addBindings(Collection<Binding> currentBindings) {
        this.bindings.addAll(currentBindings);
    }

    public void addBinding(Binding binding) {
        this.bindings.add(binding);
    }

    public void removeBinding(Binding binding) {
        this.bindings.remove(binding);
    }

    private class AMQPFederatedAddressBindingsDeliveryReceiver
    extends AMQPFederationAddressConsumer.AMQPFederatedAddressDeliveryHandler {
        AMQPFederatedAddressBindingsDeliveryReceiver(AMQPSessionContext session, FederationConsumerInfo consumerInfo, Receiver receiver) {
            super(AMQPFederationAddressBindingsConsumer.this, session, consumerInfo, receiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void routeFederatedMessage(Message message, final Delivery delivery, Receiver receiver, Transaction tx) {
            this.incrementSettle();
            ArrayList<Binding> targets = new ArrayList<Binding>(AMQPFederationAddressBindingsConsumer.this.bindings);
            if (targets.isEmpty()) {
                this.acceptUnroutableMessage(message, delivery);
                return;
            }
            delivery.setContext((Object)message);
            message.setAddress(AMQPFederationAddressBindingsConsumer.this.consumerInfo.getAddress());
            message.setConnectionID(receiver.getSession().getConnection().getRemoteContainer());
            if (message.getMessageID() <= 0L) {
                message.setMessageID(AMQPFederationAddressBindingsConsumer.this.storageManager.generateID());
            }
            OperationContext oldContext = this.recoverContext();
            try {
                this.routingContext.clear();
                logger.trace("Address federation consumer routing incoming message to {} bindings on address: {}", (Object)AMQPFederationAddressBindingsConsumer.this.bindings.size(), (Object)this.cachedAddress);
                for (Binding binding : targets) {
                    binding.route(message, this.routingContext);
                }
                AMQPFederationAddressBindingsConsumer.this.postOffice.processRoute(message, this.routingContext, false);
                AMQPFederationAddressBindingsConsumer.this.storageManager.afterCompleteOperations(new IOCallback(){
                    final /* synthetic */ AMQPFederatedAddressBindingsDeliveryReceiver this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void done() {
                        this.this$1.connection.runNow(() -> {
                            delivery.disposition((DeliveryState)Accepted.getInstance());
                            this.this$1.settle(delivery);
                            this.this$1.connection.flush();
                        });
                    }

                    public void onError(int errorCode, String errorMessage) {
                        logger.warn("Address federation bindings consumer error after IO completion{}-{}", (Object)errorCode, (Object)errorMessage);
                    }
                });
            }
            catch (Exception e) {
                logger.warn("Address federation failed routing incoming message: {}", (Object)e.getMessage(), (Object)e);
                this.deliveryFailed(delivery, receiver, e);
                this.connection.flush();
            }
            finally {
                OperationContextImpl.setContext((OperationContext)oldContext);
            }
        }

        private void acceptUnroutableMessage(Message message, Delivery delivery) {
            delivery.disposition((DeliveryState)Accepted.getInstance());
            this.settle(delivery);
            this.connection.flush();
            if (message.isLargeMessage()) {
                try {
                    ((LargeServerMessage)message).deleteFile();
                }
                catch (Exception e) {
                    logger.debug("Error during delete of large message file when no bindings remain on federation consumer:", (Throwable)e);
                }
            }
        }
    }
}

