/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class StringUtil {
    private static final Set<String> networkKeys = Set.of("ip", "ip6", "host", "host6");

    private StringUtil() {
    }

    public static String resolvePlaceholders(String value) {
        return StringUtil.resolvePlaceholders(value, System.getProperties(), System.getenv());
    }

    public static String resolvePlaceholders(String value, Properties sys, Map<String, String> env) {
        if (value == null || !value.contains("$")) {
            return value;
        }
        StringBuilder result = new StringBuilder();
        int l = value.length();
        for (int pos1 = 0; pos1 < l; ++pos1) {
            char c2;
            char c1 = value.charAt(pos1);
            char c = c2 = pos1 == l - 1 ? (char)'\u0000' : value.charAt(pos1 + 1);
            if (c1 == '$' && c2 == '{') {
                int depth = 1;
                int pos2 = pos1 + 2;
                while (depth > 0 && pos2 < l) {
                    if (value.charAt(pos2) == '$' && pos2 < l - 1 && value.charAt(pos2 + 1) == '{') {
                        ++depth;
                        pos2 += 2;
                        continue;
                    }
                    if (value.charAt(pos2) == '}') {
                        --depth;
                        ++pos2;
                        continue;
                    }
                    ++pos2;
                }
                if (depth > 0) {
                    result.append('$');
                    continue;
                }
                pos1 = StringUtil.resolve(value, result, pos1, pos2, sys, env) - 1;
                continue;
            }
            result.append(c1);
        }
        return result.toString();
    }

    private static int resolve(String value, StringBuilder result, int from, int to, Properties sys, Map<String, String> env) {
        String prefix;
        String key = StringUtil.resolvePlaceholders(value.substring(from + 2, to - 1), sys, env).trim();
        if (key.startsWith("env:")) {
            String v = env.get(key.substring(4));
            result.append(v);
            return to;
        }
        boolean sp = false;
        if (key.startsWith("sys:")) {
            key = key.substring(4);
            sp = true;
        }
        if (key.startsWith("prop:")) {
            key = key.substring(5);
            sp = true;
        }
        if (sp && sys.containsKey(key)) {
            String v = sys.getProperty(key);
            result.append(v);
            return to;
        }
        if (networkKeys.contains(key) && sys.containsKey(key)) {
            String v = sys.getProperty(key);
            result.append(v);
            return to;
        }
        int idx = key.indexOf(":");
        if (idx > 0 && networkKeys.contains(prefix = key.substring(0, idx)) && sys.containsKey(key)) {
            String v = sys.getProperty(key);
            result.append(v);
            return to;
        }
        if (sys.containsKey(key)) {
            String v = sys.getProperty(key);
            result.append(v);
            return to;
        }
        result.append("${").append(key).append("}");
        return to;
    }
}

