/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp.v11;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;

public class StompFrameV11
extends StompFrame {
    protected final List<StompFrame.Header> allHeaders = new ArrayList<StompFrame.Header>();

    public StompFrameV11(String command, Map<String, String> headers, byte[] content) {
        super(command, headers, content);
    }

    public StompFrameV11(String command) {
        super(command);
    }

    @Override
    protected void encodeHeaders(StringBuilder head) {
        for (StompFrame.Header h : this.allHeaders) {
            head.append(h.getEncodedKey());
            head.append(":");
            head.append(h.getEncodedValue());
            head.append("\n");
        }
    }

    @Override
    public void addHeader(String key, String val) {
        if (!this.headers.containsKey(key)) {
            this.headers.put(key, val);
            this.allHeaders.add(new StompFrame.Header(key, val));
        } else if (!key.equals("content-length")) {
            this.allHeaders.add(new StompFrame.Header(key, val));
        }
    }
}

