/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionXAResponseMessage
extends PacketImpl {
    protected boolean error;
    protected int responseCode;
    protected String message;

    public SessionXAResponseMessage(boolean isError, int responseCode, String message) {
        super((byte)55);
        this.error = isError;
        this.responseCode = responseCode;
        this.message = message;
    }

    public SessionXAResponseMessage() {
        super((byte)55);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public boolean isError() {
        return this.error;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.error);
        buffer.writeInt(this.responseCode);
        buffer.writeNullableString(this.message);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.error = buffer.readBoolean();
        this.responseCode = buffer.readInt();
        this.message = buffer.readNullableString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.error, this.message, this.responseCode);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", error=" + this.error);
        sb.append(", message=" + this.message);
        sb.append(", responseCode=" + this.responseCode);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAResponseMessage)) {
            return false;
        }
        SessionXAResponseMessage other = (SessionXAResponseMessage)obj;
        return this.error == other.error && Objects.equals(this.message, other.message) && this.responseCode == other.responseCode;
    }
}

