/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public final class Db2SequentialFileDriver
extends JDBCSequentialFileFactoryDriver {
    private String replaceLargeObject;

    public Db2SequentialFileDriver() {
    }

    public Db2SequentialFileDriver(JDBCConnectionProvider connectionProvider, SQLProvider provider) {
        super(connectionProvider, provider);
    }

    @Override
    protected void prepareStatements() {
        this.deleteFile = this.sqlProvider.getDeleteFileSQL();
        this.createFile = this.sqlProvider.getInsertFileSQL();
        this.createFileColumnNames = new String[]{"ID"};
        this.selectFileByFileName = this.sqlProvider.getSelectFileByFileName();
        this.copyFileRecord = this.sqlProvider.getCopyFileRecordByIdSQL();
        this.renameFile = this.sqlProvider.getUpdateFileNameByIdSQL();
        this.readLargeObject = this.sqlProvider.getReadLargeObjectSQL();
        this.replaceLargeObject = this.sqlProvider.getReplaceLargeObjectSQL();
        this.appendToLargeObject = this.sqlProvider.getAppendToLargeObjectSQL();
        this.selectFileNamesByExtension = this.sqlProvider.getSelectFileNamesByExtensionSQL();
    }

    @Override
    public int writeToFile(JDBCSequentialFile file, byte[] data, boolean append) throws SQLException {
        if (data == null || data.length == 0) {
            return 0;
        }
        try (Connection connection = this.connectionProvider.getConnection();){
            int n;
            block16: {
                PreparedStatement largeObjectStatement = connection.prepareStatement(append ? this.appendToLargeObject : this.replaceLargeObject);
                try {
                    connection.setAutoCommit(false);
                    largeObjectStatement.setBytes(1, data);
                    largeObjectStatement.setLong(2, file.getId());
                    int updatesFiles = largeObjectStatement.executeUpdate();
                    assert (updatesFiles <= 1);
                    connection.commit();
                    int bytesWritten = updatesFiles == 0 ? 0 : data.length;
                    n = bytesWritten;
                    if (largeObjectStatement == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (largeObjectStatement != null) {
                            try {
                                largeObjectStatement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        connection.rollback();
                        throw e;
                    }
                }
                largeObjectStatement.close();
            }
            return n;
        }
    }
}

