/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.event;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;

public final class EventHelper {
    private static final JavaUtilJarAccess JUJA = SharedSecrets.javaUtilJarAccess();
    private static volatile boolean loggingSecurity;
    private static volatile Logger securityLogger;
    private static AtomicReference<Logger> loggerRef;
    private static final Level LOG_LEVEL;
    private static final String SECURITY_LOGGER_NAME = "jdk.event.security";

    public static void logTLSHandshakeEvent(Instant instant, String string, int n, String string2, String string3, long l) {
        assert (securityLogger != null);
        String string4 = EventHelper.getDurationString(instant);
        securityLogger.log(LOG_LEVEL, string4 + " TLSHandshake: {0}:{1,number,#}, {2}, {3}, {4,number,#}", new Object[]{string, n, string3, string2, l});
    }

    public static void logSecurityPropertyEvent(String string, String string2) {
        assert (securityLogger != null);
        securityLogger.log(LOG_LEVEL, "SecurityPropertyModification: key:{0}, value:{1}", new Object[]{string, string2});
    }

    public static void logX509ValidationEvent(int n, int[] nArray) {
        assert (securityLogger != null);
        String string = IntStream.of(nArray).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        securityLogger.log(LOG_LEVEL, "ValidationChain: {0,number,#}, {1}", new Object[]{n, string});
    }

    public static void logX509CertificateEvent(String string, String string2, String string3, String string4, String string5, int n, long l, long l2, long l3) {
        assert (securityLogger != null);
        securityLogger.log(LOG_LEVEL, "X509Certificate: Alg:{0}, Serial:{1}, Subject:{2}, Issuer:{3}, Key type:{4}, Length:{5,number,#}, Cert Id:{6,number,#}, Valid from:{7}, Valid until:{8}", new Object[]{string, string2, string3, string4, string5, n, l, new Date(l2), new Date(l3)});
    }

    private static String getDurationString(Instant instant) {
        if (instant != null) {
            if (instant.equals(Instant.MIN)) {
                return "N/A";
            }
            Duration duration = Duration.between(instant, Instant.now());
            long l = duration.toNanos() / 1000L;
            if (l < 1000000L) {
                return "duration = " + (double)l / 1000.0 + " ms:";
            }
            return "duration = " + (double)(l / 1000L) / 1000.0 + " s:";
        }
        return "";
    }

    public static boolean isLoggingSecurity() {
        if (securityLogger == null && !JUJA.isInitializing() && loggerRef.compareAndSet(null, Logger.getLogger(SECURITY_LOGGER_NAME))) {
            securityLogger = loggerRef.get();
            loggingSecurity = securityLogger.isLoggable(LOG_LEVEL);
        }
        return loggingSecurity;
    }

    static {
        loggerRef = new AtomicReference();
        LOG_LEVEL = Level.FINE;
    }
}

