/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.legacy8ujsse.sun.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class ByteBufferInputStream
extends InputStream {
    ByteBuffer bb;

    ByteBufferInputStream(ByteBuffer bb) {
        this.bb = bb;
    }

    @Override
    public int read() throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (this.bb.remaining() == 0) {
            return -1;
        }
        return this.bb.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bb == null) {
            throw new IOException("read on a closed InputStream");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int length = Math.min(this.bb.remaining(), len);
        if (length == 0) {
            return -1;
        }
        this.bb.get(b, off, length);
        return length;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.bb == null) {
            throw new IOException("skip on a closed InputStream");
        }
        if (n <= 0L) {
            return 0L;
        }
        int nInt = (int)n;
        int skip = Math.min(this.bb.remaining(), nInt);
        this.bb.position(this.bb.position() + skip);
        return nInt;
    }

    @Override
    public int available() throws IOException {
        if (this.bb == null) {
            throw new IOException("available on a closed InputStream");
        }
        return this.bb.remaining();
    }

    @Override
    public void close() throws IOException {
        this.bb = null;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

