/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models;

import com.azul.crs.com.fasterxml.jackson.annotation.JsonCreator;
import com.azul.crs.com.fasterxml.jackson.annotation.JsonInclude;
import com.azul.crs.com.fasterxml.jackson.core.JsonProcessingException;
import com.azul.crs.shared.models.EventAnalysisStats;
import com.azul.crs.shared.models.Payload;
import com.azul.crs.shared.models.VMInstance;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EventAnalysisSummary
extends Payload {
    private final Map<String, EventAnalysisStats> entries = new HashMap<String, EventAnalysisStats>();

    public EventAnalysisSummary() {
    }

    @JsonCreator
    private EventAnalysisSummary(Map<String, Map> entries) {
        for (Map.Entry<String, Map> entry : entries.entrySet()) {
            this.entries.put(entry.getKey(), EventAnalysisSummary.objectMapper().convertValue((Object)entry.getValue(), EventAnalysisStats.class));
        }
    }

    @Override
    public String toJson() throws JsonProcessingException {
        return EventAnalysisSummary.objectMapper().writeValueAsString(this.entries);
    }

    public Map<String, EventAnalysisStats> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public void mergeEntry(VMInstance.Annotation annotation, EventAnalysisStats stats) {
        String key = annotation.getName();
        EventAnalysisStats oldStats = this.entries.get(key);
        if (oldStats == null) {
            this.entries.put(key, stats);
        } else {
            oldStats.merge(stats);
        }
    }

    public void putEntry(VMInstance.Annotation annotation, EventAnalysisStats stats) {
        this.entries.put(annotation.getName(), stats);
    }

    public void putEntry(VMInstance.Annotation annotation, EventAnalysisStats stats, boolean merge) {
        if (merge) {
            this.mergeEntry(annotation, stats);
        } else {
            this.putEntry(annotation, stats);
        }
    }

    public void putEntry(VMInstance.Annotation annotation, int totalEventCount, int unresolvedEventCount, long analysisTime) {
        this.putEntry(annotation, new EventAnalysisStats().totalEventCount(totalEventCount).unresolvedEventCount(unresolvedEventCount).analysisTime(analysisTime));
    }

    public EventAnalysisStats getEntry(VMInstance.Annotation annotation) {
        return this.entries.get(annotation.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventAnalysisSummary that = (EventAnalysisSummary)o;
        return this.entries.equals(that.entries);
    }
}

