/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.Response;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import sun.security.validator.ValidatorException;

public class Result<T> {
    private Response<T> response;
    private IOException exception;

    public Result(Response<T> response) {
        this.response = response;
    }

    public Result(IOException exception) {
        this.exception = exception;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    public Response<T> getResponse() {
        return this.response;
    }

    public IOException getException() {
        return this.exception;
    }

    public boolean successful() {
        return this.hasResponse() && this.response.successful();
    }

    public boolean canRetry() {
        if (this.hasResponse()) {
            return this.response.canRetry();
        }
        if (this.exception instanceof UnknownHostException) {
            return false;
        }
        return !(this.exception instanceof SSLHandshakeException) || this.exception.getCause() == null || !(this.exception.getCause() instanceof ValidatorException);
    }

    public String errorString() {
        return this.hasResponse() ? this.response.errorString() : this.exception.getMessage();
    }

    public String toString() {
        return "Result{response=" + this.response + ", exception=" + this.exception + '}';
    }
}

