/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.security.BasicPermission;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.Exported;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Configuration;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Type;

@Exported
public final class FlightRecorderPermission
extends BasicPermission {
    public FlightRecorderPermission(String string) {
        super(Objects.requireNonNull(string));
        if (!string.equals("accessFlightRecorder") && !string.equals("registerEvent")) {
            throw new IllegalArgumentException("name: " + string);
        }
    }

    static {
        PrivateAccess.setPrivateAccess(new InternalAccess());
    }

    private static final class InternalAccess
    extends PrivateAccess {
        private InternalAccess() {
        }

        @Override
        public Type getType(Object object) {
            if (object instanceof AnnotationElement) {
                return ((AnnotationElement)object).getType();
            }
            if (object instanceof EventType) {
                return ((EventType)object).getType();
            }
            if (object instanceof ValueDescriptor) {
                return ((ValueDescriptor)object).getType();
            }
            if (object instanceof SettingDescriptor) {
                return ((SettingDescriptor)object).getType();
            }
            throw new Error("Unknown type " + object.getClass());
        }

        @Override
        public Configuration newConfiguration(String string, String string2, String string3, String string4, Map<String, String> map, String string5) {
            return new Configuration(string, string2, string3, string4, map, string5);
        }

        @Override
        public EventType newEventType(PlatformEventType platformEventType) {
            return new EventType(platformEventType);
        }

        @Override
        public AnnotationElement newAnnotation(Type type, List<Object> list, boolean bl) {
            return new AnnotationElement(type, list, bl);
        }

        @Override
        public ValueDescriptor newValueDescriptor(String string, Type type, List<AnnotationElement> list, int n, boolean bl, String string2) {
            return new ValueDescriptor(type, string, list, n, bl, string2);
        }

        @Override
        public PlatformRecording getPlatformRecording(Recording recording) {
            return recording.getInternal();
        }

        @Override
        public PlatformEventType getPlatformEventType(EventType eventType) {
            return eventType.getPlatformEventType();
        }

        @Override
        public boolean isConstantPool(ValueDescriptor valueDescriptor) {
            return valueDescriptor.isConstantPool();
        }

        @Override
        public void setAnnotations(ValueDescriptor valueDescriptor, List<AnnotationElement> list) {
            valueDescriptor.setAnnotations(list);
        }

        @Override
        public void setAnnotations(SettingDescriptor settingDescriptor, List<AnnotationElement> list) {
            settingDescriptor.setAnnotations(list);
        }

        @Override
        public String getFieldName(ValueDescriptor valueDescriptor) {
            return valueDescriptor.getJavaFieldName();
        }

        @Override
        public ValueDescriptor newValueDescriptor(Class<?> clazz, String string) {
            return new ValueDescriptor(clazz, string, Collections.emptyList(), true);
        }

        @Override
        public SettingDescriptor newSettingDescriptor(Type type, String string, String string2, List<AnnotationElement> list) {
            return new SettingDescriptor(type, string, string2, list);
        }

        @Override
        public boolean isUnsigned(ValueDescriptor valueDescriptor) {
            return valueDescriptor.isUnsigned();
        }

        @Override
        public PlatformRecorder getPlatformRecorder() {
            return FlightRecorder.getFlightRecorder().getInternal();
        }
    }
}

