/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.Exported;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

@Exported
public final class EventType {
    private final PlatformEventType platformEventType;
    private final List<String> UNCATEGORIZED = Collections.singletonList("Uncategorized");
    private Map<String, ValueDescriptor> cache;

    EventType(PlatformEventType platformEventType) {
        this.platformEventType = platformEventType;
    }

    public List<ValueDescriptor> getFields() {
        return this.platformEventType.getFields();
    }

    public ValueDescriptor getField(String string) {
        Objects.requireNonNull(string);
        if (this.cache == null) {
            List<ValueDescriptor> list = this.getFields();
            LinkedHashMap<String, ValueDescriptor> linkedHashMap = new LinkedHashMap<String, ValueDescriptor>(list.size());
            for (ValueDescriptor valueDescriptor : list) {
                linkedHashMap.put(valueDescriptor.getName(), valueDescriptor);
            }
            this.cache = linkedHashMap;
        }
        return this.cache.get(string);
    }

    public String getName() {
        return this.platformEventType.getName();
    }

    public String getLabel() {
        return this.platformEventType.getLabel();
    }

    public long getId() {
        return this.platformEventType.getId();
    }

    public List<AnnotationElement> getAnnotationElements() {
        return this.platformEventType.getAnnotationElements();
    }

    public boolean isEnabled() {
        return this.platformEventType.isEnabled();
    }

    public String getDescription() {
        return this.platformEventType.getDescription();
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        Objects.requireNonNull(clazz);
        return (A)((Annotation)this.platformEventType.getAnnotation(clazz));
    }

    public static EventType getEventType(Class<? extends Event> clazz) {
        Objects.requireNonNull(clazz);
        Utils.ensureValidEventSubclass(clazz);
        JVMSupport.ensureWithInternalError();
        return MetadataRepository.getInstance().getEventType(clazz);
    }

    public List<SettingDescriptor> getSettingDescriptors() {
        return Collections.unmodifiableList(this.platformEventType.getSettings());
    }

    public List<String> getCategoryNames() {
        Category category = (Category)this.platformEventType.getAnnotation(Category.class);
        if (category == null) {
            return this.UNCATEGORIZED;
        }
        return Collections.unmodifiableList(Arrays.asList(category.value()));
    }

    Type getType() {
        return this.platformEventType;
    }

    PlatformEventType getPlatformEventType() {
        return this.platformEventType;
    }
}

