/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import sun.security.action.GetPropertyAction;
import sun.security.action.OpenFileInputStreamAction;
import sun.security.ssl.Debug;
import sun.security.validator.TrustStoreUtil;

final class TrustStoreManager {
    private static final Debug debug = Debug.getInstance("ssl");
    private static final TrustAnchorManager tam = new TrustAnchorManager();

    private TrustStoreManager() {
    }

    public static Set<X509Certificate> getTrustedCerts() throws Exception {
        return tam.getTrustedCerts(TrustStoreDescriptor.createInstance());
    }

    public static KeyStore getTrustedKeyStore() throws Exception {
        return tam.getKeyStore(TrustStoreDescriptor.createInstance());
    }

    private static final class TrustAnchorManager {
        private TrustStoreDescriptor descriptor = null;
        private WeakReference<KeyStore> ksRef = new WeakReference<Object>(null);
        private WeakReference<Set<X509Certificate>> csRef = new WeakReference<Object>(null);

        private TrustAnchorManager() {
        }

        synchronized KeyStore getKeyStore(TrustStoreDescriptor trustStoreDescriptor) throws Exception {
            TrustStoreDescriptor trustStoreDescriptor2 = this.descriptor;
            KeyStore keyStore = (KeyStore)this.ksRef.get();
            if (keyStore != null && trustStoreDescriptor.equals(trustStoreDescriptor2)) {
                return keyStore;
            }
            if (debug != null && Debug.isOn("trustmanager")) {
                System.out.println("Reload the trust store");
            }
            keyStore = TrustAnchorManager.loadKeyStore(trustStoreDescriptor);
            this.descriptor = trustStoreDescriptor;
            this.ksRef = new WeakReference<KeyStore>(keyStore);
            return keyStore;
        }

        synchronized Set<X509Certificate> getTrustedCerts(TrustStoreDescriptor trustStoreDescriptor) throws Exception {
            KeyStore keyStore = null;
            TrustStoreDescriptor trustStoreDescriptor2 = this.descriptor;
            Set<X509Certificate> set = (Set<X509Certificate>)this.csRef.get();
            if (set != null) {
                if (trustStoreDescriptor.equals(trustStoreDescriptor2)) {
                    return set;
                }
                this.descriptor = trustStoreDescriptor;
            } else if (trustStoreDescriptor.equals(trustStoreDescriptor2)) {
                keyStore = (KeyStore)this.ksRef.get();
            } else {
                this.descriptor = trustStoreDescriptor;
            }
            if (keyStore == null) {
                if (debug != null && Debug.isOn("trustmanager")) {
                    System.out.println("Reload the trust store");
                }
                keyStore = TrustAnchorManager.loadKeyStore(trustStoreDescriptor);
            }
            if (debug != null && Debug.isOn("trustmanager")) {
                System.out.println("Reload trust certs");
            }
            set = TrustAnchorManager.loadTrustedCerts(keyStore);
            if (debug != null && Debug.isOn("trustmanager")) {
                System.out.println("Reloaded " + set.size() + " trust certs");
            }
            this.csRef = new WeakReference<Set<X509Certificate>>(set);
            return set;
        }

        private static KeyStore loadKeyStore(TrustStoreDescriptor trustStoreDescriptor) throws Exception {
            KeyStore keyStore;
            block19: {
                if (!"NONE".equals(trustStoreDescriptor.storeName) && trustStoreDescriptor.storeFile == null) {
                    if (debug != null && Debug.isOn("trustmanager")) {
                        System.out.println("No available key store");
                    }
                    return null;
                }
                keyStore = trustStoreDescriptor.storeProvider.isEmpty() ? KeyStore.getInstance(trustStoreDescriptor.storeType) : KeyStore.getInstance(trustStoreDescriptor.storeType, trustStoreDescriptor.storeProvider);
                char[] cArray = null;
                if (!trustStoreDescriptor.storePassword.isEmpty()) {
                    cArray = trustStoreDescriptor.storePassword.toCharArray();
                }
                if (!"NONE".equals(trustStoreDescriptor.storeName)) {
                    try (FileInputStream fileInputStream = AccessController.doPrivileged(new OpenFileInputStreamAction(trustStoreDescriptor.storeFile));){
                        keyStore.load(fileInputStream, cArray);
                        break block19;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (debug != null && Debug.isOn("trustmanager")) {
                            System.out.println("Not available key store: " + trustStoreDescriptor.storeName);
                        }
                        return null;
                    }
                }
                keyStore.load(null, cArray);
            }
            return keyStore;
        }

        private static Set<X509Certificate> loadTrustedCerts(KeyStore keyStore) {
            if (keyStore == null) {
                return Collections.emptySet();
            }
            return TrustStoreUtil.getTrustedCerts(keyStore);
        }
    }

    private static final class TrustStoreDescriptor {
        private static final String fileSep = File.separator;
        private static final String defaultStorePath = GetPropertyAction.privilegedGetProperty("java.home") + fileSep + "lib" + fileSep + "security";
        private static final String defaultStore = defaultStorePath + fileSep + "cacerts";
        private static final String jsseDefaultStore = defaultStorePath + fileSep + "jssecacerts";
        private final String storeName;
        private final String storeType;
        private final String storeProvider;
        private final String storePassword;
        private final File storeFile;
        private final long lastModified;

        private TrustStoreDescriptor(String string, String string2, String string3, String string4, File file, long l) {
            this.storeName = string;
            this.storeType = string2;
            this.storeProvider = string3;
            this.storePassword = string4;
            this.storeFile = file;
            this.lastModified = l;
            if (debug != null && Debug.isOn("trustmanager")) {
                System.out.println("trustStore is: " + string + "\n" + "trustStore type is: " + string2 + "\n" + "trustStore provider is: " + string3 + "\n" + "the last modified time is: " + new Date(l));
            }
        }

        static TrustStoreDescriptor createInstance() {
            return AccessController.doPrivileged(new PrivilegedAction<TrustStoreDescriptor>(){

                @Override
                public TrustStoreDescriptor run() {
                    String string = System.getProperty("javax.net.ssl.trustStore", jsseDefaultStore);
                    String string2 = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                    String string3 = System.getProperty("javax.net.ssl.trustStoreProvider", "");
                    String string4 = System.getProperty("javax.net.ssl.trustStorePassword", "");
                    String string5 = "";
                    File file = null;
                    long l = 0L;
                    if (!"NONE".equals(string)) {
                        String[] stringArray;
                        for (String string6 : stringArray = new String[]{string, defaultStore}) {
                            File file2 = new File(string6);
                            if (file2.isFile() && file2.canRead()) {
                                string5 = string6;
                                file = file2;
                                l = file2.lastModified();
                                break;
                            }
                            if (debug == null || !Debug.isOn("trustmanager")) continue;
                            System.out.println("Inaccessible trust store: " + string);
                        }
                    } else {
                        string5 = string;
                    }
                    return new TrustStoreDescriptor(string5, string2, string3, string4, file, l);
                }
            });
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof TrustStoreDescriptor) {
                TrustStoreDescriptor trustStoreDescriptor = (TrustStoreDescriptor)object;
                return this.lastModified == trustStoreDescriptor.lastModified && Objects.equals(this.storeName, trustStoreDescriptor.storeName) && Objects.equals(this.storeType, trustStoreDescriptor.storeType) && Objects.equals(this.storeProvider, trustStoreDescriptor.storeProvider);
            }
            return false;
        }

        public int hashCode() {
            int n = 17;
            if (this.storeName != null && !this.storeName.isEmpty()) {
                n = 31 * n + this.storeName.hashCode();
            }
            if (this.storeType != null && !this.storeType.isEmpty()) {
                n = 31 * n + this.storeType.hashCode();
            }
            if (this.storeProvider != null && !this.storeProvider.isEmpty()) {
                n = 31 * n + this.storeProvider.hashCode();
            }
            if (this.storeFile != null) {
                n = 31 * n + this.storeFile.hashCode();
            }
            if (this.lastModified != 0L) {
                n = (int)((long)(31 * n) + this.lastModified);
            }
            return n;
        }
    }
}

