/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.CGraphicsConfig;
import sun.awt.CGraphicsDevice;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.Surface;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.java2d.opengl.CGLSurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.pipe.hw.AccelDeviceEventListener;
import sun.java2d.pipe.hw.AccelDeviceEventNotifier;
import sun.java2d.pipe.hw.AccelSurface;
import sun.java2d.pipe.hw.AccelTypedVolatileImage;
import sun.java2d.pipe.hw.ContextCapabilities;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.macosx.CPlatformView;

public final class CGLGraphicsConfig
extends CGraphicsConfig
implements OGLGraphicsConfig {
    private static final int kOpenGLSwapInterval = 0;
    private static boolean cglAvailable;
    private static ImageCapabilities imageCaps;
    private int pixfmt;
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private ContextCapabilities oglCaps;
    private OGLContext context;
    private final Object disposerReferent = new Object();
    private final int cachedMaxTextureSize;
    private static final Rectangle totalDisplayBounds;

    private static native boolean initCGL();

    private static native long getCGLConfigInfo(int var0, int var1, int var2);

    private static native int getOGLCapabilities(long var0);

    private static native int _getMaxTextureSize();

    private CGLGraphicsConfig(CGraphicsDevice cGraphicsDevice, int n, long l, ContextCapabilities contextCapabilities) {
        super(cGraphicsDevice);
        this.pixfmt = n;
        this.pConfigInfo = l;
        this.oglCaps = contextCapabilities;
        this.context = new OGLContext(OGLRenderQueue.getInstance(), this);
        Disposer.addRecord(this.disposerReferent, new CGLGCDisposerRecord(this.pConfigInfo));
        this.cachedMaxTextureSize = CGLGraphicsConfig._getMaxTextureSize();
    }

    @Override
    public Object getProxyKey() {
        return this;
    }

    @Override
    public SurfaceData createManagedSurface(int n, int n2, int n3) {
        return CGLSurfaceData.createData(this, n, n2, this.getColorModel(n3), null, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CGLGraphicsConfig getConfig(CGraphicsDevice cGraphicsDevice, int n) {
        if (!cglAvailable) {
            return null;
        }
        long l = 0L;
        final String[] stringArray = new String[1];
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.invalidateCurrentContext();
            l = CGLGraphicsConfig.getCGLConfigInfo(cGraphicsDevice.getCGDisplayID(), n, 0);
            if (l != 0L) {
                OGLContext.setScratchSurface(l);
                oGLRenderQueue.flushAndInvokeNow(new Runnable(){

                    @Override
                    public void run() {
                        stringArray[0] = OGLContext.getOGLIdString();
                    }
                });
            }
        }
        finally {
            oGLRenderQueue.unlock();
        }
        if (l == 0L) {
            return null;
        }
        int n2 = CGLGraphicsConfig.getOGLCapabilities(l);
        OGLContext.OGLContextCaps oGLContextCaps = new OGLContext.OGLContextCaps(n2, stringArray[0]);
        return new CGLGraphicsConfig(cGraphicsDevice, n, l, oGLContextCaps);
    }

    public static boolean isCGLAvailable() {
        return cglAvailable;
    }

    @Override
    public boolean isCapPresent(int n) {
        return (this.oglCaps.getCaps() & n) != 0;
    }

    @Override
    public long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    @Override
    public OGLContext getContext() {
        return this.context;
    }

    @Override
    public BufferedImage createCompatibleImage(int n, int n2) {
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster writableRaster = ((ColorModel)directColorModel).createCompatibleWritableRaster(n, n2);
        return new BufferedImage(directColorModel, writableRaster, directColorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public boolean isDoubleBuffered() {
        return this.isCapPresent(65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void displayChanged() {
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            OGLContext.invalidateCurrentContext();
        }
        finally {
            oGLRenderQueue.unlock();
        }
        CGLGraphicsConfig.updateTotalDisplayBounds();
    }

    public String toString() {
        int n = this.getDevice().getCGDisplayID();
        return "CGLGraphicsConfig[dev=" + n + ",pixfmt=" + this.pixfmt + "]";
    }

    @Override
    public SurfaceData createSurfaceData(CPlatformView cPlatformView) {
        return CGLSurfaceData.createData(cPlatformView);
    }

    @Override
    public SurfaceData createSurfaceData(CGLLayer cGLLayer) {
        return CGLSurfaceData.createData(cGLLayer);
    }

    @Override
    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new OffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    @Override
    public void assertOperationSupported(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n != 2) {
            throw new AWTException("Only double buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (bufferCapabilities.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
    }

    @Override
    public Image createBackBuffer(LWComponentPeer<?, ?> lWComponentPeer) {
        Rectangle rectangle = lWComponentPeer.getBounds();
        int n = Math.max(1, rectangle.width);
        int n2 = Math.max(1, rectangle.height);
        int n3 = lWComponentPeer.isTranslucent() ? 3 : 1;
        return new SunVolatileImage(this, n, n2, n3, null);
    }

    @Override
    public void destroyBackBuffer(Image image) {
        if (image != null) {
            image.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flip(LWComponentPeer<?, ?> lWComponentPeer, Image image, int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        Graphics graphics = lWComponentPeer.getGraphics();
        try {
            graphics.drawImage(image, n, n2, n3, n4, n, n2, n3, n4, null);
        }
        finally {
            graphics.dispose();
        }
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            try {
                graphics2D.setBackground(lWComponentPeer.getBackground());
                graphics2D.clearRect(0, 0, image.getWidth(null), image.getHeight(null));
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    @Override
    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new CGLBufferCaps(this.isDoubleBuffered());
        }
        return this.bufferCaps;
    }

    @Override
    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int n, int n2, int n3, int n4) {
        AccelTypedVolatileImage accelTypedVolatileImage;
        Surface surface;
        if (n4 == 4 || n4 == 1 || n4 == 0 || n3 == 2) {
            return null;
        }
        if (n4 == 5) {
            if (!this.isCapPresent(12)) {
                return null;
            }
        } else if (n4 == 2) {
            boolean bl;
            boolean bl2 = bl = n3 == 1;
            if (!bl && !this.isCapPresent(2)) {
                return null;
            }
        }
        if (!((surface = (accelTypedVolatileImage = new AccelTypedVolatileImage((GraphicsConfiguration)this, n, n2, n3, n4)).getDestSurface()) instanceof AccelSurface) || ((AccelSurface)surface).getType() != n4) {
            accelTypedVolatileImage.flush();
            accelTypedVolatileImage = null;
        }
        return accelTypedVolatileImage;
    }

    @Override
    public ContextCapabilities getContextCapabilities() {
        return this.oglCaps;
    }

    @Override
    public void addDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        int n = this.getDevice().getCGDisplayID();
        AccelDeviceEventNotifier.addListener(accelDeviceEventListener, n);
    }

    @Override
    public void removeDeviceEventListener(AccelDeviceEventListener accelDeviceEventListener) {
        AccelDeviceEventNotifier.removeListener(accelDeviceEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateTotalDisplayBounds() {
        Rectangle rectangle = totalDisplayBounds;
        synchronized (rectangle) {
            Rectangle rectangle2 = new Rectangle();
            for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                    rectangle2 = rectangle2.union(graphicsConfiguration.getBounds());
                }
            }
            totalDisplayBounds.setBounds(rectangle2);
        }
    }

    private int getMaxTextureSize() {
        return this.cachedMaxTextureSize;
    }

    @Override
    public int getMaxTextureWidth() {
        return this.getMaxTextureSize() / (this.getDevice().getScaleFactor() * 2);
    }

    @Override
    public int getMaxTextureHeight() {
        return this.getMaxTextureSize() / (this.getDevice().getScaleFactor() * 2);
    }

    static {
        imageCaps = new CGLImageCaps();
        cglAvailable = CGLGraphicsConfig.initCGL();
        totalDisplayBounds = new Rectangle();
    }

    private static class CGLImageCaps
    extends ImageCapabilities {
        private CGLImageCaps() {
            super(true);
        }

        @Override
        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class CGLBufferCaps
    extends BufferCapabilities {
        public CGLBufferCaps(boolean bl) {
            super(imageCaps, imageCaps, bl ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }

    private static class CGLGCDisposerRecord
    implements DisposerRecord {
        private long pCfgInfo;

        public CGLGCDisposerRecord(long l) {
            this.pCfgInfo = l;
        }

        @Override
        public void dispose() {
            if (this.pCfgInfo != 0L) {
                OGLRenderQueue.disposeGraphicsConfig(this.pCfgInfo);
                this.pCfgInfo = 0L;
            }
        }
    }
}

