/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.Arrays;
import java.util.List;
import sun.awt.image.MultiResolutionImage;
import sun.awt.image.ToolkitImage;
import sun.misc.SoftCache;

public class MultiResolutionToolkitImage
extends ToolkitImage
implements MultiResolutionImage {
    Image resolutionVariant;
    private static final int BITS_INFO = 56;

    public MultiResolutionToolkitImage(Image image, Image image2) {
        super(image.getSource());
        this.resolutionVariant = image2;
    }

    @Override
    public Image getResolutionVariant(int n, int n2) {
        return n <= this.getWidth() && n2 <= this.getHeight() ? this : this.resolutionVariant;
    }

    public Image getResolutionVariant() {
        return this.resolutionVariant;
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Arrays.asList(this, this.resolutionVariant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageObserver getResolutionVariantObserver(final Image image, final ImageObserver imageObserver, int n, int n2, int n3, int n4) {
        if (imageObserver == null) {
            return null;
        }
        SoftCache softCache = ObserverCache.INSTANCE;
        synchronized (softCache) {
            ImageObserver imageObserver2 = (ImageObserver)ObserverCache.INSTANCE.get(image);
            if (imageObserver2 == null) {
                imageObserver2 = new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image image2, int n, int n2, int n3, int n4, int n5) {
                        if ((n & 0x39) != 0) {
                            n4 = (n4 + 1) / 2;
                        }
                        if ((n & 0x3A) != 0) {
                            n5 = (n5 + 1) / 2;
                        }
                        if ((n & 0x38) != 0) {
                            n2 /= 2;
                            n3 /= 2;
                        }
                        return imageObserver.imageUpdate(image, n, n2, n3, n4, n5);
                    }
                };
                ObserverCache.INSTANCE.put(image, imageObserver2);
            }
            return imageObserver2;
        }
    }

    private static class ObserverCache {
        static final SoftCache INSTANCE = new SoftCache();

        private ObserverCache() {
        }
    }
}

