/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapIntBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class IntBuffer
extends Buffer
implements Comparable<IntBuffer> {
    final int[] hb;
    final int offset;
    boolean isReadOnly;

    IntBuffer(int n, int n2, int n3, int n4, int[] nArray, int n5) {
        super(n, n2, n3, n4);
        this.hb = nArray;
        this.offset = n5;
    }

    IntBuffer(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, 0);
    }

    public static IntBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapIntBuffer(n, n);
    }

    public static IntBuffer wrap(int[] nArray, int n, int n2) {
        try {
            return new HeapIntBuffer(nArray, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static IntBuffer wrap(int[] nArray) {
        return IntBuffer.wrap(nArray, 0, nArray.length);
    }

    public abstract IntBuffer slice();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public IntBuffer get(int[] nArray, int n, int n2) {
        IntBuffer.checkBounds(n, n2, nArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            nArray[i] = this.get();
        }
        return this;
    }

    public IntBuffer get(int[] nArray) {
        return this.get(nArray, 0, nArray.length);
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = intBuffer.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(intBuffer.get());
        }
        return this;
    }

    public IntBuffer put(int[] nArray, int n, int n2) {
        IntBuffer.checkBounds(n, n2, nArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.put(nArray[i]);
        }
        return this;
    }

    public final IntBuffer put(int[] nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final int[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract IntBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntBuffer)) {
            return false;
        }
        IntBuffer intBuffer = (IntBuffer)object;
        int n = this.position();
        int n2 = this.limit();
        int n3 = intBuffer.position();
        int n4 = intBuffer.limit();
        int n5 = n2 - n;
        int n6 = n4 - n3;
        if (n5 < 0 || n5 != n6) {
            return false;
        }
        int n7 = n2 - 1;
        int n8 = n4 - 1;
        while (n7 >= n) {
            if (!IntBuffer.equals(this.get(n7), intBuffer.get(n8))) {
                return false;
            }
            --n7;
            --n8;
        }
        return true;
    }

    private static boolean equals(int n, int n2) {
        return n == n2;
    }

    @Override
    public int compareTo(IntBuffer intBuffer) {
        int n = this.position();
        int n2 = this.limit() - n;
        int n3 = intBuffer.position();
        int n4 = intBuffer.limit() - n3;
        int n5 = Math.min(n2, n4);
        if (n5 < 0) {
            return -1;
        }
        int n6 = n + Math.min(n2, n4);
        int n7 = n;
        int n8 = n3;
        while (n7 < n6) {
            int n9 = IntBuffer.compare(this.get(n7), intBuffer.get(n8));
            if (n9 != 0) {
                return n9;
            }
            ++n7;
            ++n8;
        }
        return n2 - n4;
    }

    private static int compare(int n, int n2) {
        return Integer.compare(n, n2);
    }

    public abstract ByteOrder order();
}

