/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.DirectAudioDeviceProvider;
import com.sun.media.sound.EventDispatcher;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

final class DirectAudioDevice
extends AbstractMixer {
    private static final int CLIP_BUFFER_TIME = 1000;
    private static final int DEFAULT_LINE_BUFFER_TIME = 500;
    private int deviceCountOpened = 0;
    private int deviceCountStarted = 0;

    DirectAudioDevice(DirectAudioDeviceProvider.DirectAudioDeviceInfo directAudioDeviceInfo) {
        super(directAudioDeviceInfo, null, null, null);
        DirectDLI directDLI = this.createDataLineInfo(true);
        if (directDLI != null) {
            this.sourceLineInfo = new Line.Info[2];
            this.sourceLineInfo[0] = directDLI;
            this.sourceLineInfo[1] = new DirectDLI(Clip.class, directDLI.getFormats(), directDLI.getHardwareFormats(), 32, -1);
        } else {
            this.sourceLineInfo = new Line.Info[0];
        }
        DirectDLI directDLI2 = this.createDataLineInfo(false);
        if (directDLI2 != null) {
            this.targetLineInfo = new Line.Info[1];
            this.targetLineInfo[0] = directDLI2;
        } else {
            this.targetLineInfo = new Line.Info[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectDLI createDataLineInfo(boolean bl) {
        Vector vector = new Vector();
        AudioFormat[] audioFormatArray = null;
        AudioFormat[] audioFormatArray2 = null;
        Vector vector2 = vector;
        synchronized (vector2) {
            DirectAudioDevice.nGetFormats(this.getMixerIndex(), this.getDeviceID(), bl, vector);
            if (vector.size() > 0) {
                boolean bl2;
                int n;
                int n2;
                int n3;
                int n4 = n3 = vector.size();
                audioFormatArray = new AudioFormat[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    AudioFormat audioFormat;
                    audioFormatArray[n2] = audioFormat = (AudioFormat)vector.elementAt(n2);
                    int n5 = audioFormat.getSampleSizeInBits();
                    n = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                    bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
                    if (n == 0 && !bl2) continue;
                    ++n4;
                }
                audioFormatArray2 = new AudioFormat[n4];
                n2 = 0;
                for (int i = 0; i < n3; ++i) {
                    AudioFormat audioFormat = audioFormatArray[i];
                    audioFormatArray2[n2++] = audioFormat;
                    n = audioFormat.getSampleSizeInBits();
                    bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
                    boolean bl3 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
                    if (n == 8) {
                        if (bl2) {
                            audioFormatArray2[n2++] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat.getSampleRate(), n, audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getSampleRate(), audioFormat.isBigEndian());
                            continue;
                        }
                        if (!bl3) continue;
                        audioFormatArray2[n2++] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), n, audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getSampleRate(), audioFormat.isBigEndian());
                        continue;
                    }
                    if (n <= 8 || !bl2 && !bl3) continue;
                    audioFormatArray2[n2++] = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), n, audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getSampleRate(), !audioFormat.isBigEndian());
                }
            }
        }
        if (audioFormatArray2 != null) {
            return new DirectDLI(bl ? SourceDataLine.class : TargetDataLine.class, audioFormatArray2, audioFormatArray, 32, -1);
        }
        return null;
    }

    @Override
    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info2 instanceof DataLine.Info) {
            AudioFormat audioFormat;
            DataLine.Info info3 = (DataLine.Info)info2;
            int n = -1;
            AudioFormat[] audioFormatArray = null;
            if (info instanceof DataLine.Info) {
                audioFormatArray = ((DataLine.Info)info).getFormats();
                n = ((DataLine.Info)info).getMaxBufferSize();
            }
            if (audioFormatArray == null || audioFormatArray.length == 0) {
                audioFormat = null;
            } else {
                audioFormat = audioFormatArray[audioFormatArray.length - 1];
                if (!Toolkit.isFullySpecifiedPCMFormat(audioFormat)) {
                    audioFormat = null;
                }
            }
            if (info3.getLineClass().isAssignableFrom(DirectSDL.class)) {
                return new DirectSDL(info3, audioFormat, n, this);
            }
            if (info3.getLineClass().isAssignableFrom(DirectClip.class)) {
                return new DirectClip(info3, audioFormat, n, this);
            }
            if (info3.getLineClass().isAssignableFrom(DirectTDL.class)) {
                return new DirectTDL(info3, audioFormat, n, this);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    @Override
    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof DataLine.Info) {
            return this.getMaxSimulLines();
        }
        return 0;
    }

    @Override
    protected void implOpen() throws LineUnavailableException {
    }

    @Override
    protected void implClose() {
    }

    @Override
    protected void implStart() {
    }

    @Override
    protected void implStop() {
    }

    int getMixerIndex() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getIndex();
    }

    int getDeviceID() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getDeviceID();
    }

    int getMaxSimulLines() {
        return ((DirectAudioDeviceProvider.DirectAudioDeviceInfo)this.getMixerInfo()).getMaxSimulLines();
    }

    private static void addFormat(Vector vector, int n, int n2, int n3, float f, int n4, boolean bl, boolean bl2) {
        AudioFormat.Encoding encoding = null;
        switch (n4) {
            case 0: {
                encoding = bl ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
                break;
            }
            case 1: {
                encoding = AudioFormat.Encoding.ULAW;
                if (n == 8) break;
                n = 8;
                n2 = n3;
                break;
            }
            case 2: {
                encoding = AudioFormat.Encoding.ALAW;
                if (n == 8) break;
                n = 8;
                n2 = n3;
            }
        }
        if (encoding == null) {
            return;
        }
        if (n2 <= 0) {
            n2 = n3 > 0 ? (n + 7) / 8 * n3 : -1;
        }
        vector.add(new AudioFormat(encoding, f, n, n3, n2, f, bl2));
    }

    protected static AudioFormat getSignOrEndianChangedFormat(AudioFormat audioFormat) {
        boolean bl = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        boolean bl2 = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        if (audioFormat.getSampleSizeInBits() > 8 && bl) {
            return new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), !audioFormat.isBigEndian());
        }
        if (audioFormat.getSampleSizeInBits() == 8 && (bl || bl2)) {
            return new AudioFormat(bl ? AudioFormat.Encoding.PCM_UNSIGNED : AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
        }
        return null;
    }

    private static native void nGetFormats(int var0, int var1, boolean var2, Vector var3);

    private static native long nOpen(int var0, int var1, boolean var2, int var3, float var4, int var5, int var6, int var7, boolean var8, boolean var9, int var10) throws LineUnavailableException;

    private static native void nStart(long var0, boolean var2);

    private static native void nStop(long var0, boolean var2);

    private static native void nClose(long var0, boolean var2);

    private static native int nWrite(long var0, byte[] var2, int var3, int var4, int var5, float var6, float var7);

    private static native int nRead(long var0, byte[] var2, int var3, int var4, int var5);

    private static native int nGetBufferSize(long var0, boolean var2);

    private static native boolean nIsStillDraining(long var0, boolean var2);

    private static native void nFlush(long var0, boolean var2);

    private static native int nAvailable(long var0, boolean var2);

    private static native long nGetBytePosition(long var0, boolean var2, long var3);

    private static native void nSetBytePosition(long var0, boolean var2, long var3);

    private static native boolean nRequiresServicing(long var0, boolean var2);

    private static native void nService(long var0, boolean var2);

    private static class DirectBAOS
    extends ByteArrayOutputStream {
        DirectBAOS() {
        }

        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }

    private static final class DirectClip
    extends DirectDL
    implements Clip,
    Runnable,
    AutoClosingClip {
        private Thread thread;
        private byte[] audioData = null;
        private int frameSize;
        private int m_lengthInFrames;
        private int loopCount;
        private int clipBytePosition;
        private int newFramePosition;
        private int loopStartFrame;
        private int loopEndFrame;
        private boolean autoclosing = false;

        private DirectClip(DataLine.Info info, AudioFormat audioFormat, int n, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, audioFormat, n, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), true);
        }

        @Override
        public void open(AudioFormat audioFormat, byte[] byArray, int n, int n2) throws LineUnavailableException {
            Toolkit.isFullySpecifiedAudioFormat(audioFormat);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.open(audioFormat, byArray2, n2 / audioFormat.getFrameSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void open(AudioFormat audioFormat, byte[] byArray, int n) throws LineUnavailableException {
            Toolkit.isFullySpecifiedAudioFormat(audioFormat);
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
                }
                this.audioData = byArray;
                this.frameSize = audioFormat.getFrameSize();
                this.m_lengthInFrames = n;
                this.bytePosition = 0L;
                this.clipBytePosition = 0;
                this.newFramePosition = -1;
                this.loopStartFrame = 0;
                this.loopEndFrame = n - 1;
                this.loopCount = 0;
                try {
                    this.open(audioFormat, (int)Toolkit.millis2bytes(audioFormat, 1000L));
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.audioData = null;
                    throw lineUnavailableException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.audioData = null;
                    throw illegalArgumentException;
                }
                int n2 = 6;
                this.thread = JSSecurityManager.createThread(this, "Direct Clip", true, n2, false);
                this.thread.start();
            }
            if (this.isAutoClosing()) {
                this.getEventDispatcher().autoClosingClipOpened(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
            Toolkit.isFullySpecifiedAudioFormat(audioInputStream.getFormat());
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                byte[] byArray = null;
                if (this.isOpen()) {
                    throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
                }
                int n = (int)audioInputStream.getFrameLength();
                int n2 = 0;
                int n3 = audioInputStream.getFormat().getFrameSize();
                if (n != -1) {
                    int n4 = n * n3;
                    if (n4 < 0) {
                        throw new IllegalArgumentException("Audio data < 0");
                    }
                    try {
                        byArray = new byte[n4];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Audio data is too big");
                    }
                    int n5 = n4;
                    int n6 = 0;
                    while (n5 > 0 && n6 >= 0) {
                        n6 = audioInputStream.read(byArray, n2, n5);
                        if (n6 > 0) {
                            n2 += n6;
                            n5 -= n6;
                            continue;
                        }
                        if (n6 != 0) continue;
                        Thread.yield();
                    }
                } else {
                    byte[] byArray2;
                    int n7 = Math.max(16384, n3);
                    DirectBAOS directBAOS = new DirectBAOS();
                    try {
                        byArray2 = new byte[n7];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Audio data is too big");
                    }
                    int n8 = 0;
                    while (n8 >= 0) {
                        n8 = audioInputStream.read(byArray2, 0, byArray2.length);
                        if (n8 > 0) {
                            directBAOS.write(byArray2, 0, n8);
                            n2 += n8;
                            continue;
                        }
                        if (n8 != 0) continue;
                        Thread.yield();
                    }
                    byArray = directBAOS.getInternalBuffer();
                }
                n = n2 / n3;
                this.open(audioInputStream.getFormat(), byArray, n);
            }
        }

        @Override
        public int getFrameLength() {
            return this.m_lengthInFrames;
        }

        @Override
        public long getMicrosecondLength() {
            return Toolkit.frames2micros(this.getFormat(), this.getFrameLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFramePosition(int n) {
            if (n < 0) {
                n = 0;
            } else if (n >= this.getFrameLength()) {
                n = this.getFrameLength();
            }
            if (this.doIO) {
                this.newFramePosition = n;
            } else {
                this.clipBytePosition = n * this.frameSize;
                this.newFramePosition = -1;
            }
            this.bytePosition = n * this.frameSize;
            this.flush();
            Object object = this.lockNative;
            synchronized (object) {
                DirectAudioDevice.nSetBytePosition(this.id, this.isSource, n * this.frameSize);
            }
        }

        @Override
        public long getLongFramePosition() {
            return super.getLongFramePosition();
        }

        @Override
        public synchronized void setMicrosecondPosition(long l) {
            long l2 = Toolkit.micros2frames(this.getFormat(), l);
            this.setFramePosition((int)l2);
        }

        @Override
        public void setLoopPoints(int n, int n2) {
            if (n < 0 || n >= this.getFrameLength()) {
                throw new IllegalArgumentException("illegal value for start: " + n);
            }
            if (n2 >= this.getFrameLength()) {
                throw new IllegalArgumentException("illegal value for end: " + n2);
            }
            if (n2 == -1 && (n2 = this.getFrameLength() - 1) < 0) {
                n2 = 0;
            }
            if (n2 < n) {
                throw new IllegalArgumentException("End position " + n2 + "  preceeds start position " + n);
            }
            this.loopStartFrame = n;
            this.loopEndFrame = n2;
        }

        @Override
        public void loop(int n) {
            this.loopCount = n;
            this.start();
        }

        @Override
        void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
            if (this.audioData == null) {
                throw new IllegalArgumentException("illegal call to open() in interface Clip");
            }
            super.implOpen(audioFormat, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void implClose() {
            Thread thread = this.thread;
            this.thread = null;
            this.doIO = false;
            if (thread != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
                try {
                    thread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.implClose();
            this.audioData = null;
            this.newFramePosition = -1;
            this.getEventDispatcher().autoClosingClipClosed(this);
        }

        @Override
        void implStart() {
            super.implStart();
        }

        @Override
        void implStop() {
            super.implStop();
            this.loopCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.thread != null) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.doIO) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                while (this.doIO) {
                    long l;
                    int n;
                    int n2;
                    if (this.newFramePosition >= 0) {
                        this.clipBytePosition = this.newFramePosition * this.frameSize;
                        this.newFramePosition = -1;
                    }
                    int n3 = this.getFrameLength() - 1;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        n3 = this.loopEndFrame;
                    }
                    if ((n2 = (n = (int)((long)n3 - (l = (long)(this.clipBytePosition / this.frameSize)) + 1L)) * this.frameSize) > this.getBufferSize()) {
                        n2 = Toolkit.align(this.getBufferSize(), this.frameSize);
                    }
                    int n4 = this.write(this.audioData, this.clipBytePosition, n2);
                    this.clipBytePosition += n4;
                    if (!this.doIO || this.newFramePosition >= 0 || n4 < 0 || (l = (long)(this.clipBytePosition / this.frameSize)) <= (long)n3) continue;
                    if (this.loopCount > 0 || this.loopCount == -1) {
                        if (this.loopCount != -1) {
                            --this.loopCount;
                        }
                        this.newFramePosition = this.loopStartFrame;
                        continue;
                    }
                    this.drain();
                    this.stop();
                }
            }
        }

        @Override
        public boolean isAutoClosing() {
            return this.autoclosing;
        }

        @Override
        public void setAutoClosing(boolean bl) {
            if (bl != this.autoclosing) {
                if (this.isOpen()) {
                    if (bl) {
                        this.getEventDispatcher().autoClosingClipOpened(this);
                    } else {
                        this.getEventDispatcher().autoClosingClipClosed(this);
                    }
                }
                this.autoclosing = bl;
            }
        }

        @Override
        protected boolean requiresServicing() {
            return false;
        }
    }

    private static final class DirectTDL
    extends DirectDL
    implements TargetDataLine {
        private DirectTDL(DataLine.Info info, AudioFormat audioFormat, int n, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, audioFormat, n, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) {
            this.flushing = false;
            if (n2 == 0) {
                return 0;
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("illegal len: " + n2);
            }
            if (n2 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("illegal request to read non-integral number of frames (" + n2 + " bytes, " + "frameSize = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            if ((long)n + (long)n2 > (long)byArray.length) {
                throw new ArrayIndexOutOfBoundsException(byArray.length);
            }
            if (!this.isActive() && this.doIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int n3 = 0;
            while (this.doIO && !this.flushing) {
                int n4;
                Object object = this.lockNative;
                synchronized (object) {
                    n4 = DirectAudioDevice.nRead(this.id, byArray, n, n2, this.softwareConversionSize);
                    if (n4 < 0) {
                        break;
                    }
                    this.bytePosition += (long)n4;
                    if (n4 > 0) {
                        this.drained = false;
                    }
                }
                n3 += n4;
                if ((n2 -= n4) <= 0) break;
                n += n4;
                object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.flushing) {
                n3 = 0;
            }
            return n3;
        }
    }

    private static final class DirectSDL
    extends DirectDL
    implements SourceDataLine {
        private DirectSDL(DataLine.Info info, AudioFormat audioFormat, int n, DirectAudioDevice directAudioDevice) {
            super(info, directAudioDevice, audioFormat, n, directAudioDevice.getMixerIndex(), directAudioDevice.getDeviceID(), true);
        }
    }

    private static class DirectDL
    extends AbstractDataLine
    implements EventDispatcher.LineMonitor {
        protected final int mixerIndex;
        protected final int deviceID;
        protected long id;
        protected int waitTime;
        protected volatile boolean flushing = false;
        protected final boolean isSource;
        protected volatile long bytePosition;
        protected volatile boolean doIO = false;
        protected volatile boolean stoppedWritten = false;
        protected volatile boolean drained = false;
        protected boolean monitoring = false;
        protected int softwareConversionSize = 0;
        protected AudioFormat hardwareFormat;
        private final Gain gainControl = new Gain();
        private final Mute muteControl = new Mute();
        private final Balance balanceControl = new Balance();
        private final Pan panControl = new Pan();
        private float leftGain;
        private float rightGain;
        protected volatile boolean noService = false;
        protected final Object lockNative = new Object();

        protected DirectDL(DataLine.Info info, DirectAudioDevice directAudioDevice, AudioFormat audioFormat, int n, int n2, int n3, boolean bl) {
            super(info, directAudioDevice, null, audioFormat, n);
            this.mixerIndex = n2;
            this.deviceID = n3;
            this.waitTime = 10;
            this.isSource = bl;
        }

        @Override
        void implOpen(AudioFormat audioFormat, int n) throws LineUnavailableException {
            AudioFormat audioFormat2;
            Toolkit.isFullySpecifiedAudioFormat(audioFormat);
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            int n2 = 0;
            if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                n2 = 1;
            } else if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
                n2 = 2;
            }
            if (n <= -1) {
                n = (int)Toolkit.millis2bytes(audioFormat, 500L);
            }
            DirectDLI directDLI = null;
            if (this.info instanceof DirectDLI) {
                directDLI = (DirectDLI)this.info;
            }
            if (this.isSource) {
                if (!audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                    this.controls = new Control[0];
                } else if (audioFormat.getChannels() > 2 || audioFormat.getSampleSizeInBits() > 16) {
                    this.controls = new Control[0];
                } else {
                    if (audioFormat.getChannels() == 1) {
                        this.controls = new Control[2];
                    } else {
                        this.controls = new Control[4];
                        this.controls[2] = this.balanceControl;
                        this.controls[3] = this.panControl;
                    }
                    this.controls[0] = this.gainControl;
                    this.controls[1] = this.muteControl;
                }
            }
            this.hardwareFormat = audioFormat;
            this.softwareConversionSize = 0;
            if (directDLI != null && !directDLI.isFormatSupportedInHardware(audioFormat) && directDLI.isFormatSupportedInHardware(audioFormat2 = DirectAudioDevice.getSignOrEndianChangedFormat(audioFormat))) {
                this.hardwareFormat = audioFormat2;
                this.softwareConversionSize = audioFormat.getFrameSize() / audioFormat.getChannels();
            }
            n = n / audioFormat.getFrameSize() * audioFormat.getFrameSize();
            this.id = DirectAudioDevice.nOpen(this.mixerIndex, this.deviceID, this.isSource, n2, this.hardwareFormat.getSampleRate(), this.hardwareFormat.getSampleSizeInBits(), this.hardwareFormat.getFrameSize(), this.hardwareFormat.getChannels(), this.hardwareFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED), this.hardwareFormat.isBigEndian(), n);
            if (this.id == 0L) {
                throw new LineUnavailableException("line with format " + audioFormat + " not supported.");
            }
            this.bufferSize = DirectAudioDevice.nGetBufferSize(this.id, this.isSource);
            if (this.bufferSize < 1) {
                this.bufferSize = n;
            }
            this.format = audioFormat;
            this.waitTime = (int)Toolkit.bytes2millis(audioFormat, this.bufferSize) / 4;
            if (this.waitTime < 10) {
                this.waitTime = 1;
            } else if (this.waitTime > 1000) {
                this.waitTime = 1000;
            }
            this.bytePosition = 0L;
            this.stoppedWritten = false;
            this.doIO = false;
            this.calcVolume();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void implStart() {
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            Object object = this.lockNative;
            synchronized (object) {
                DirectAudioDevice.nStart(this.id, this.isSource);
            }
            this.monitoring = this.requiresServicing();
            if (this.monitoring) {
                this.getEventDispatcher().addLineMonitor(this);
            }
            this.doIO = true;
            if (this.isSource && this.stoppedWritten) {
                this.setStarted(true);
                this.setActive(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void implStop() {
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            if (this.monitoring) {
                this.getEventDispatcher().removeLineMonitor(this);
                this.monitoring = false;
            }
            Object object = this.lockNative;
            synchronized (object) {
                DirectAudioDevice.nStop(this.id, this.isSource);
            }
            object = this.lock;
            synchronized (object) {
                this.doIO = false;
                this.lock.notifyAll();
            }
            this.setActive(false);
            this.setStarted(false);
            this.stoppedWritten = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void implClose() {
            if (!this.isSource) {
                JSSecurityManager.checkRecordPermission();
            }
            if (this.monitoring) {
                this.getEventDispatcher().removeLineMonitor(this);
                this.monitoring = false;
            }
            this.doIO = false;
            long l = this.id;
            this.id = 0L;
            Object object = this.lockNative;
            synchronized (object) {
                DirectAudioDevice.nClose(l, this.isSource);
            }
            this.bytePosition = 0L;
            this.softwareConversionSize = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() {
            int n;
            if (this.id == 0L) {
                return 0;
            }
            Object object = this.lockNative;
            synchronized (object) {
                n = DirectAudioDevice.nAvailable(this.id, this.isSource);
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drain() {
            this.noService = true;
            int n = 0;
            long l = this.getLongFramePosition();
            boolean bl = false;
            while (!this.drained) {
                Object object = this.lockNative;
                synchronized (object) {
                    if (this.id == 0L || !this.doIO || !DirectAudioDevice.nIsStillDraining(this.id, this.isSource)) {
                        break;
                    }
                }
                if (n % 5 == 4) {
                    long l2 = this.getLongFramePosition();
                    bl |= l2 != l;
                    if (n % 50 > 45) {
                        if (!bl) break;
                        bl = false;
                        l = l2;
                    }
                }
                ++n;
                object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.doIO && this.id != 0L) {
                this.drained = true;
            }
            this.noService = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            if (this.id != 0L) {
                this.flushing = true;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
                object = this.lockNative;
                synchronized (object) {
                    if (this.id != 0L) {
                        DirectAudioDevice.nFlush(this.id, this.isSource);
                    }
                }
                this.drained = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getLongFramePosition() {
            long l;
            Object object = this.lockNative;
            synchronized (object) {
                l = DirectAudioDevice.nGetBytePosition(this.id, this.isSource, this.bytePosition);
            }
            if (l < 0L) {
                l = 0L;
            }
            return l / (long)this.getFormat().getFrameSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(byte[] byArray, int n, int n2) {
            this.flushing = false;
            if (n2 == 0) {
                return 0;
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("illegal len: " + n2);
            }
            if (n2 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("illegal request to write non-integral number of frames (" + n2 + " bytes, " + "frameSize = " + this.getFormat().getFrameSize() + " bytes)");
            }
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            if ((long)n + (long)n2 > (long)byArray.length) {
                throw new ArrayIndexOutOfBoundsException(byArray.length);
            }
            if (!this.isActive() && this.doIO) {
                this.setActive(true);
                this.setStarted(true);
            }
            int n3 = 0;
            while (!this.flushing) {
                int n4;
                Object object = this.lockNative;
                synchronized (object) {
                    n4 = DirectAudioDevice.nWrite(this.id, byArray, n, n2, this.softwareConversionSize, this.leftGain, this.rightGain);
                    if (n4 < 0) {
                        break;
                    }
                    this.bytePosition += (long)n4;
                    if (n4 > 0) {
                        this.drained = false;
                    }
                }
                n3 += n4;
                if (!this.doIO || (n2 -= n4) <= 0) break;
                n += n4;
                object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(this.waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (n3 > 0 && !this.doIO) {
                this.stoppedWritten = true;
            }
            return n3;
        }

        protected boolean requiresServicing() {
            return DirectAudioDevice.nRequiresServicing(this.id, this.isSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkLine() {
            Object object = this.lockNative;
            synchronized (object) {
                if (this.monitoring && this.doIO && this.id != 0L && !this.flushing && !this.noService) {
                    DirectAudioDevice.nService(this.id, this.isSource);
                }
            }
        }

        private void calcVolume() {
            if (this.getFormat() == null) {
                return;
            }
            if (this.muteControl.getValue()) {
                this.leftGain = 0.0f;
                this.rightGain = 0.0f;
                return;
            }
            float f = this.gainControl.getLinearGain();
            if (this.getFormat().getChannels() == 1) {
                this.leftGain = f;
                this.rightGain = f;
            } else {
                float f2 = this.balanceControl.getValue();
                if (f2 < 0.0f) {
                    this.leftGain = f;
                    this.rightGain = f * (f2 + 1.0f);
                } else {
                    this.leftGain = f * (1.0f - f2);
                    this.rightGain = f;
                }
            }
        }

        private final class Pan
        extends FloatControl {
            private Pan() {
                super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
            }

            @Override
            public void setValue(float f) {
                this.setValueImpl(f);
                DirectDL.this.balanceControl.setValueImpl(f);
                DirectDL.this.calcVolume();
            }

            void setValueImpl(float f) {
                super.setValue(f);
            }
        }

        private final class Balance
        extends FloatControl {
            private Balance() {
                super(FloatControl.Type.BALANCE, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
            }

            @Override
            public void setValue(float f) {
                this.setValueImpl(f);
                DirectDL.this.panControl.setValueImpl(f);
                DirectDL.this.calcVolume();
            }

            void setValueImpl(float f) {
                super.setValue(f);
            }
        }

        private final class Mute
        extends BooleanControl {
            private Mute() {
                super(BooleanControl.Type.MUTE, false, "True", "False");
            }

            @Override
            public void setValue(boolean bl) {
                super.setValue(bl);
                DirectDL.this.calcVolume();
            }
        }

        protected final class Gain
        extends FloatControl {
            private float linearGain;

            private Gain() {
                super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(2.0f), Math.abs(Toolkit.linearToDB(1.0f) - Toolkit.linearToDB(0.0f)) / 128.0f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
                this.linearGain = 1.0f;
            }

            @Override
            public void setValue(float f) {
                float f2 = Toolkit.dBToLinear(f);
                super.setValue(Toolkit.linearToDB(f2));
                this.linearGain = f2;
                DirectDL.this.calcVolume();
            }

            float getLinearGain() {
                return this.linearGain;
            }
        }
    }

    private static final class DirectDLI
    extends DataLine.Info {
        final AudioFormat[] hardwareFormats;

        private DirectDLI(Class clazz, AudioFormat[] audioFormatArray, AudioFormat[] audioFormatArray2, int n, int n2) {
            super(clazz, audioFormatArray, n, n2);
            this.hardwareFormats = audioFormatArray2;
        }

        public boolean isFormatSupportedInHardware(AudioFormat audioFormat) {
            if (audioFormat == null) {
                return false;
            }
            for (int i = 0; i < this.hardwareFormats.length; ++i) {
                if (!audioFormat.matches(this.hardwareFormats[i])) continue;
                return true;
            }
            return false;
        }

        private AudioFormat[] getHardwareFormats() {
            return this.hardwareFormats;
        }
    }
}

