/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.filter;

import java.util.regex.Pattern;
import org.fluentlenium.core.filter.matcher.ContainsMatcher;
import org.fluentlenium.core.filter.matcher.EndsWithMatcher;
import org.fluentlenium.core.filter.matcher.EqualMatcher;
import org.fluentlenium.core.filter.matcher.Matcher;
import org.fluentlenium.core.filter.matcher.NotContainsMatcher;
import org.fluentlenium.core.filter.matcher.NotEndsWithMatcher;
import org.fluentlenium.core.filter.matcher.NotStartsWithMatcher;
import org.fluentlenium.core.filter.matcher.StartsWithMatcher;

public final class MatcherConstructor {
    private MatcherConstructor() {
    }

    public static Matcher contains(String matcher) {
        return new ContainsMatcher(matcher);
    }

    public static Matcher contains(Pattern pattern) {
        return new ContainsMatcher(pattern);
    }

    public static Matcher notContains(String matcher) {
        return new NotContainsMatcher(matcher);
    }

    public static Matcher notContains(Pattern pattern) {
        return new NotContainsMatcher(pattern);
    }

    public static Matcher equal(String matcher) {
        return new EqualMatcher(matcher);
    }

    public static Pattern regex(String pattern) {
        return Pattern.compile(pattern);
    }

    public static Matcher startsWith(String matcher) {
        return new StartsWithMatcher(matcher);
    }

    public static Matcher startsWith(Pattern pattern) {
        return new StartsWithMatcher(pattern);
    }

    public static Matcher endsWith(String matcher) {
        return new EndsWithMatcher(matcher);
    }

    public static Matcher endsWith(Pattern pattern) {
        return new EndsWithMatcher(pattern);
    }

    public static Matcher notStartsWith(String matcher) {
        return new NotStartsWithMatcher(matcher);
    }

    public static Matcher notStartsWith(Pattern pattern) {
        return new NotStartsWithMatcher(pattern);
    }

    public static Matcher notEndsWith(String matcher) {
        return new NotEndsWithMatcher(matcher);
    }

    public static Matcher notEndsWith(Pattern pattern) {
        return new NotEndsWithMatcher(pattern);
    }
}

