/*
 * Decompiled with CFR 0.152.
 */
package play.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.cache.CacheApi;
import play.libs.Scala;
import scala.concurrent.duration.Duration;

@Singleton
public class DefaultCacheApi
implements CacheApi {
    private final play.api.cache.CacheApi cacheApi;

    @Inject
    public DefaultCacheApi(play.api.cache.CacheApi cacheApi) {
        this.cacheApi = cacheApi;
    }

    @Override
    public <T> T get(String string) {
        return (T)Scala.orNull(this.cacheApi.get(string, Scala.classTag()));
    }

    @Override
    public <T> T getOrElse(String string, Callable<T> callable, int n) {
        return (T)this.cacheApi.getOrElse(string, this.intToDuration(n), Scala.asScala(callable), Scala.classTag());
    }

    @Override
    public <T> T getOrElse(String string, Callable<T> callable) {
        return (T)this.cacheApi.getOrElse(string, (Duration)Duration.Inf(), Scala.asScala(callable), Scala.classTag());
    }

    @Override
    public void set(String string, Object object, int n) {
        this.cacheApi.set(string, object, this.intToDuration(n));
    }

    @Override
    public void set(String string, Object object) {
        this.cacheApi.set(string, object, (Duration)Duration.Inf());
    }

    @Override
    public void remove(String string) {
        this.cacheApi.remove(string);
    }

    private Duration intToDuration(int n) {
        return n == 0 ? Duration.Inf() : Duration.apply((long)n, (TimeUnit)TimeUnit.SECONDS);
    }
}

