/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.trace;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.SupervisorStrategy;
import akka.event.LoggingAdapter;
import com.typesafe.config.Config;
import com.typesafe.trace.Batch;
import com.typesafe.trace.circuitbreaker.CircuitBreaker$;
import com.typesafe.trace.circuitbreaker.CircuitBreakerConfiguration;
import com.typesafe.trace.circuitbreaker.CircuitBreakerHalfOpenException;
import com.typesafe.trace.circuitbreaker.CircuitBreakerOpenException;
import com.typesafe.trace.circuitbreaker.UsingCircuitBreaker;
import com.typesafe.trace.circuitbreaker.UsingCircuitBreaker$class;
import com.typesafe.trace.store.TraceStorageRepository;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4Q!\u0001\u0002\u0002\u0002%\u0011!\u0003\u0016:bG\u0016,e/\u001a8u\u0019&\u001cH/\u001a8fe*\u00111\u0001B\u0001\u0006iJ\f7-\u001a\u0006\u0003\u000b\u0019\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u000f\u0005\u00191m\\7\u0004\u0001M)\u0001A\u0003\t\u0019=A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001a\u0004\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003U\tA!Y6lC&\u0011qC\u0005\u0002\u0006\u0003\u000e$xN\u001d\t\u00033qi\u0011A\u0007\u0006\u00037\t\tabY5sGVLGO\u0019:fC.,'/\u0003\u0002\u001e5\t\u0019Rk]5oO\u000eK'oY;ji\n\u0013X-Y6feB\u0011\u0011cH\u0005\u0003AI\u0011A\"Q2u_JdunZ4j]\u001eDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000f\u001d\u0002\u0001\u0019!C\u0005Q\u0005Y!/\u001a;ss\n+hMZ3s+\u0005I\u0003c\u0001\u00160c5\t1F\u0003\u0002-[\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003]1\t!bY8mY\u0016\u001cG/[8o\u0013\t\u00014F\u0001\u0004WK\u000e$xN\u001d\t\u0003KIJ!a\r\u0002\u0003\u000b\t\u000bGo\u00195\t\u000fU\u0002\u0001\u0019!C\u0005m\u0005y!/\u001a;ss\n+hMZ3s?\u0012*\u0017\u000f\u0006\u00028uA\u00111\u0002O\u0005\u0003s1\u0011A!\u00168ji\"91\bNA\u0001\u0002\u0004I\u0013a\u0001=%c!1Q\b\u0001Q!\n%\nAB]3uef\u0014UO\u001a4fe\u0002BQa\u0010\u0001\u0007\u0002\u0001\u000b!B]3q_NLGo\u001c:z+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\u0003\u0003\u0015\u0019Ho\u001c:f\u0013\t15I\u0001\fUe\u0006\u001cWm\u0015;pe\u0006<WMU3q_NLGo\u001c:z\u0011\u001dA\u0005A1A\u0007\u0002%\u000baaY8oM&<W#\u0001&\u0011\u0005-kU\"\u0001'\u000b\u0005!#\u0011B\u0001(M\u0005\u0019\u0019uN\u001c4jO\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0016AE2je\u000e,\u0018\u000e\u001e\"sK\u0006\\WM\u001d(b[\u0016,\u0012A\u0015\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bA\u0001\\1oO*\tq+\u0001\u0003kCZ\f\u0017BA-U\u0005\u0019\u0019FO]5oO\"11\f\u0001Q\u0001\nI\u000b1cY5sGVLGO\u0011:fC.,'OT1nK\u0002Bq!\u0018\u0001C\u0002\u0013%a,A\bsKR\u0014\u0018PQ;gM\u0016\u00148+\u001b>f+\u0005y\u0006CA\u0006a\u0013\t\tGBA\u0002J]RDaa\u0019\u0001!\u0002\u0013y\u0016\u0001\u0005:fiJL()\u001e4gKJ\u001c\u0016N_3!\u0011\u0015)\u0007\u0001\"\u0001g\u0003\u001d\u0011XmY3jm\u0016,\u0012a\u001a\t\u0005\u0017!Tw'\u0003\u0002j\u0019\ty\u0001+\u0019:uS\u0006dg)\u001e8di&|g\u000e\u0005\u0002\fW&\u0011A\u000e\u0004\u0002\u0004\u0003:L\b\"\u00028\u0001\t\u0003y\u0017A\u00025b]\u0012dW\r\u0006\u00028a\")\u0011/\u001ca\u0001c\u0005)!-\u0019;dQ\")A\t\u0001C\tgR\u0011q\u0007\u001e\u0005\u0006cJ\u0004\r!\r\u0005\u0006m\u0002!\tb^\u0001\u000be\u0016$(/_*u_J,G#A\u001c\t\u000be\u0004A\u0011\u0003>\u0002!\u0005$G\rV8SKR\u0014\u0018PQ;gM\u0016\u0014HCA\u001c|\u0011\u0015\t\b\u00101\u00012\u0001")
public abstract class TraceEventListener
implements Actor,
UsingCircuitBreaker,
ActorLogging {
    private Vector<Batch> com$typesafe$trace$TraceEventListener$$retryBuffer;
    private final String circuitBreakerName;
    private final int retryBufferSize;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public LoggingAdapter log() {
        return ActorLogging.class.log((ActorLogging)this);
    }

    @Override
    public <T> T withCircuitBreaker(String name, Function0<T> f) {
        return (T)UsingCircuitBreaker$class.withCircuitBreaker(this, name, f);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public final ActorRef sender() {
        return Actor.class.sender((Actor)this);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
    }

    public void aroundPreStart() {
        Actor.class.aroundPreStart((Actor)this);
    }

    public void aroundPostStop() {
        Actor.class.aroundPostStop((Actor)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
    }

    public void aroundPostRestart(Throwable reason) {
        Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.class.supervisorStrategy((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.class.preStart((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.class.postStop((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.class.preRestart((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.class.postRestart((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.class.unhandled((Actor)this, (Object)message);
    }

    public Vector<Batch> com$typesafe$trace$TraceEventListener$$retryBuffer() {
        return this.com$typesafe$trace$TraceEventListener$$retryBuffer;
    }

    private void com$typesafe$trace$TraceEventListener$$retryBuffer_$eq(Vector<Batch> x$1) {
        this.com$typesafe$trace$TraceEventListener$$retryBuffer = x$1;
    }

    public abstract TraceStorageRepository repository();

    public abstract Config config();

    public String circuitBreakerName() {
        return this.circuitBreakerName;
    }

    private int retryBufferSize() {
        return this.retryBufferSize;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TraceEventListener $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Batch) {
                    Batch batch = (Batch)A1;
                    this.$outer.handle(batch);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof Batch;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void handle(Batch batch) {
        try {
            this.withCircuitBreaker(this.circuitBreakerName(), (Function0)new Serializable(this, batch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TraceEventListener $outer;
                private final Batch batch$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (!this.$outer.com$typesafe$trace$TraceEventListener$$retryBuffer().isEmpty()) {
                        this.$outer.retryStore();
                    }
                    this.$outer.store(this.batch$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batch$2 = batch$2;
                }
            });
        }
        catch (Exception exception) {
            this.addToRetryBuffer(batch);
            this.log().error((Throwable)exception, new StringOps(Predef$.MODULE$.augmentString("Trace event handler failed to store batch, reason: [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})));
        }
        catch (CircuitBreakerHalfOpenException circuitBreakerHalfOpenException) {
            this.addToRetryBuffer(batch);
            this.log().error((Throwable)circuitBreakerHalfOpenException, new StringOps(Predef$.MODULE$.augmentString("Trace event handler failing to store batch, reason: [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{circuitBreakerHalfOpenException.getMessage()})));
        }
        catch (CircuitBreakerOpenException circuitBreakerOpenException) {
            this.addToRetryBuffer(batch);
            this.log().debug(new StringOps(Predef$.MODULE$.augmentString("Trace event handler not available to store batch, reason: [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{circuitBreakerOpenException.getMessage()})));
        }
    }

    public void store(Batch batch) {
        if (!this.com$typesafe$trace$TraceEventListener$$retryBuffer().isEmpty()) {
            this.retryStore();
        }
        this.repository().store(batch);
    }

    public void retryStore() {
        try {
            this.com$typesafe$trace$TraceEventListener$$retryBuffer().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TraceEventListener $outer;

                public final void apply(Batch batch) {
                    this.$outer.repository().store(batch);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Stored [%s] retry batches")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.com$typesafe$trace$TraceEventListener$$retryBuffer().size())})));
            this.com$typesafe$trace$TraceEventListener$$retryBuffer_$eq((Vector<Batch>)((Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)));
        }
        catch (Exception exception) {
            this.log().error((Throwable)exception, new StringOps(Predef$.MODULE$.augmentString("Retry failed. %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})));
        }
    }

    public void addToRetryBuffer(Batch batch) {
        if (this.com$typesafe$trace$TraceEventListener$$retryBuffer().size() < this.retryBufferSize()) {
            this.com$typesafe$trace$TraceEventListener$$retryBuffer_$eq((Vector<Batch>)((Vector)this.com$typesafe$trace$TraceEventListener$$retryBuffer().$colon$plus((Object)batch, Vector$.MODULE$.canBuildFrom())));
        }
    }

    public TraceEventListener() {
        Actor.class.$init$((Actor)this);
        UsingCircuitBreaker$class.$init$(this);
        ActorLogging.class.$init$((ActorLogging)this);
        this.com$typesafe$trace$TraceEventListener$$retryBuffer = (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$);
        long timeoutMillis = this.config().getDuration("activator.trace.storage-circuit-breaker.timeout", TimeUnit.MILLISECONDS);
        int failureThreshold = this.config().getInt("activator.trace.storage-circuit-breaker.failure-threshold");
        CircuitBreakerConfiguration circuitBreakerConfiguration = new CircuitBreakerConfiguration(timeoutMillis, failureThreshold);
        String circuitBreakerName = "StorageCircuitBreaker";
        if (!CircuitBreaker$.MODULE$.hasCircuitBreaker(circuitBreakerName)) {
            CircuitBreaker$.MODULE$.addCircuitBreaker(circuitBreakerName, circuitBreakerConfiguration);
        }
        this.circuitBreakerName = circuitBreakerName;
        this.retryBufferSize = this.config().getInt("activator.trace.storage-retry-buffer-size");
    }
}

