/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.japi.function.Function2;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.Flow;
import akka.stream.javadsl.Sink;
import akka.util.ByteString;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.w3c.dom.Document;
import play.api.http.HttpConfiguration;
import play.api.http.Status$;
import play.api.libs.Files;
import play.api.mvc.BodyParsers$;
import play.api.mvc.MaxSizeNotExceeded$;
import play.api.mvc.MultipartFormData;
import play.api.mvc.RawBuffer;
import play.core.j.JavaParsers;
import play.core.parsers.FormUrlEncodedParser;
import play.core.parsers.Multipart;
import play.http.HttpErrorHandler;
import play.libs.F;
import play.libs.XML;
import play.libs.streams.Accumulator;
import play.mvc.BodyParsers;
import play.mvc.Http;
import play.mvc.Result;
import scala.Function1;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.OptionConverters;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.AbstractFunction1;

public interface BodyParser<A> {
    public Accumulator<ByteString, F.Either<Result, A>> apply(Http.RequestHeader var1);

    public static abstract class DelegatingMultipartFormDataBodyParser<A>
    implements BodyParser<Http.MultipartFormData<A>> {
        private final Materializer materializer;
        private final long maxLength;
        private final play.api.mvc.BodyParser<play.api.mvc.MultipartFormData<A>> delegate;

        public DelegatingMultipartFormDataBodyParser(Materializer materializer, long l) {
            this.maxLength = l;
            this.materializer = materializer;
            this.delegate = this.multipartParser();
        }

        public abstract Function<Multipart.FileInfo, Accumulator<ByteString, Http.MultipartFormData.FilePart<A>>> createFilePartHandler();

        private play.api.mvc.BodyParser<play.api.mvc.MultipartFormData<A>> multipartParser() {
            ScalaFilePartHandler scalaFilePartHandler = new ScalaFilePartHandler();
            return Multipart.multipartParser((int)this.maxLength, scalaFilePartHandler, this.materializer);
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, Http.MultipartFormData<A>>> apply(Http.RequestHeader requestHeader) {
            return ((play.api.libs.streams.Accumulator)this.delegate.apply(requestHeader._underlyingHeader())).asJava().map(either -> {
                if (either.isLeft()) {
                    return F.Either.Left(((play.api.mvc.Result)either.left().get()).asJava());
                }
                play.api.mvc.MultipartFormData multipartFormData2 = (play.api.mvc.MultipartFormData)either.right().get();
                return F.Either.Right(new DelegatingMultipartFormData(multipartFormData2));
            }, JavaParsers.trampoline());
        }

        private Http.MultipartFormData.FilePart<A> toJava(MultipartFormData.FilePart<A> filePart) {
            return new Http.MultipartFormData.FilePart<A>(filePart.key(), filePart.filename(), OptionConverters.toJava(filePart.contentType()).orElse(null), filePart.ref());
        }

        private MultipartFormData.FilePart<A> toScala(Http.MultipartFormData.FilePart<A> filePart) {
            return new MultipartFormData.FilePart<A>(filePart.getKey(), filePart.getFilename(), (Option<String>)Option.apply((Object)filePart.getContentType()), filePart.getFile());
        }

        private class DelegatingMultipartFormData
        extends Http.MultipartFormData<A> {
            private play.api.mvc.MultipartFormData<A> scalaFormData;

            DelegatingMultipartFormData(play.api.mvc.MultipartFormData<A> multipartFormData2) {
                this.scalaFormData = multipartFormData2;
            }

            @Override
            public java.util.Map<String, String[]> asFormUrlEncoded() {
                return (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)this.scalaFormData.asFormUrlEncoded().mapValues(this.arrayFunction())).asJava();
            }

            private Function1<Seq<String>, String[]> arrayFunction() {
                return new AbstractFunction1<Seq<String>, String[]>(){

                    public String[] apply(Seq<String> seq2) {
                        String[] stringArray = new String[seq2.size()];
                        seq2.copyToArray((Object)stringArray);
                        return stringArray;
                    }
                };
            }

            @Override
            public List<Http.MultipartFormData.FilePart<A>> getFiles() {
                return ((List)JavaConverters.seqAsJavaListConverter(this.scalaFormData.files()).asJava()).stream().map(filePart -> DelegatingMultipartFormDataBodyParser.this.toJava(filePart)).collect(Collectors.toList());
            }
        }

        private class JavaFilePartToScalaFilePart
        extends AbstractFunction1<Http.MultipartFormData.FilePart<A>, MultipartFormData.FilePart<A>> {
            private JavaFilePartToScalaFilePart() {
            }

            public MultipartFormData.FilePart<A> apply(Http.MultipartFormData.FilePart<A> filePart) {
                return DelegatingMultipartFormDataBodyParser.this.toScala(filePart);
            }
        }

        private class ScalaFilePartHandler
        extends AbstractFunction1<Multipart.FileInfo, play.api.libs.streams.Accumulator<ByteString, MultipartFormData.FilePart<A>>> {
            private ScalaFilePartHandler() {
            }

            public play.api.libs.streams.Accumulator<ByteString, MultipartFormData.FilePart<A>> apply(Multipart.FileInfo fileInfo) {
                return DelegatingMultipartFormDataBodyParser.this.createFilePartHandler().apply(fileInfo).asScala().map((Function1)new JavaFilePartToScalaFilePart(), (ExecutionContext)DelegatingMultipartFormDataBodyParser.this.materializer.executionContext());
            }
        }
    }

    public static abstract class DelegatingBodyParser<A, B>
    implements BodyParser<A> {
        private final play.api.mvc.BodyParser<B> delegate;
        private final Function<B, A> transform;

        public DelegatingBodyParser(play.api.mvc.BodyParser<B> bodyParser, Function<B, A> function) {
            this.delegate = bodyParser;
            this.transform = function;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, A>> apply(Http.RequestHeader requestHeader) {
            Accumulator accumulator = ((play.api.libs.streams.Accumulator)this.delegate.apply(requestHeader._underlyingHeader())).asJava();
            return accumulator.map(either -> {
                if (either.isLeft()) {
                    return F.Either.Left(((play.api.mvc.Result)either.left().get()).asJava());
                }
                return F.Either.Right(this.transform.apply(either.right().get()));
            }, JavaParsers.trampoline());
        }
    }

    public static abstract class BufferingBodyParser<A>
    extends MaxLengthBodyParser<A> {
        private final HttpErrorHandler errorHandler;
        private final String errorMessage;

        protected BufferingBodyParser(long l, HttpErrorHandler httpErrorHandler2, String string2) {
            super(l, httpErrorHandler2);
            this.errorHandler = httpErrorHandler2;
            this.errorMessage = string2;
        }

        protected BufferingBodyParser(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler2, String string2) {
            this(httpConfiguration.parser().maxMemoryBuffer(), httpErrorHandler2, string2);
        }

        @Override
        protected final Accumulator<ByteString, F.Either<Result, A>> apply1(Http.RequestHeader requestHeader) {
            return Accumulator.fromSink((Sink)Sink.fold((Object)ByteString.empty(), ByteString::concat)).mapFuture(byteString -> {
                try {
                    return CompletableFuture.completedFuture(F.Either.Right(this.parse(requestHeader, (ByteString)byteString)));
                }
                catch (Exception exception) {
                    return this.errorHandler.onClientError(requestHeader, Status$.MODULE$.BAD_REQUEST(), this.errorMessage + ": " + exception.getMessage()).thenApply(F.Either::Left);
                }
            }, JavaParsers.trampoline());
        }

        protected abstract A parse(Http.RequestHeader var1, ByteString var2) throws Exception;
    }

    public static abstract class MaxLengthBodyParser<A>
    implements BodyParser<A> {
        private final long maxLength;
        private final HttpErrorHandler errorHandler;

        protected MaxLengthBodyParser(long l, HttpErrorHandler httpErrorHandler2) {
            this.maxLength = l;
            this.errorHandler = httpErrorHandler2;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, A>> apply(Http.RequestHeader requestHeader) {
            Flow flow2 = Flow.fromGraph(BodyParsers$.MODULE$.takeUpTo(this.maxLength));
            Sink sink = this.apply1(requestHeader).toSink();
            return Accumulator.fromSink((Sink)flow2.toMat((Graph)sink, (Function2 & Serializable)(future, completionStage) -> FutureConverters.toJava((Future)future).thenCompose(maxSizeStatus -> {
                if (maxSizeStatus instanceof MaxSizeNotExceeded$) {
                    return completionStage;
                }
                return this.errorHandler.onClientError(requestHeader, Status$.MODULE$.REQUEST_ENTITY_TOO_LARGE(), "Request entity too large").thenApply(F.Either::Left);
            })));
        }

        protected abstract Accumulator<ByteString, F.Either<Result, A>> apply1(Http.RequestHeader var1);
    }

    public static class Empty
    implements BodyParser<Optional<Void>> {
        @Override
        public Accumulator<ByteString, F.Either<Result, Optional<Void>>> apply(Http.RequestHeader requestHeader) {
            return Accumulator.done(F.Either.Right(Optional.empty()));
        }
    }

    public static class MultipartFormData
    extends DelegatingBodyParser<Http.MultipartFormData<File>, play.api.mvc.MultipartFormData<Files.TemporaryFile>> {
        @Inject
        public MultipartFormData() {
            super(JavaParsers.parse().multipartFormData(), JavaParsers::toJavaMultipartFormData);
        }
    }

    public static class FormUrlEncoded
    extends BufferingBodyParser<java.util.Map<String, String[]>> {
        private final HttpErrorHandler errorHandler;

        public FormUrlEncoded(long l, HttpErrorHandler httpErrorHandler2) {
            super(l, httpErrorHandler2, "Error parsing form");
            this.errorHandler = httpErrorHandler2;
        }

        @Inject
        public FormUrlEncoded(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler2) {
            super(httpConfiguration, httpErrorHandler2, "Error parsing form");
            this.errorHandler = httpErrorHandler2;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, java.util.Map<String, String[]>>> apply(Http.RequestHeader requestHeader2) {
            return BodyParsers.validateContentType(this.errorHandler, requestHeader2, "Expected application/x-www-form-urlencoded", string2 -> string2.equalsIgnoreCase("application/x-www-form-urlencoded"), requestHeader -> super.apply((Http.RequestHeader)requestHeader));
        }

        @Override
        protected java.util.Map<String, String[]> parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            String string2 = requestHeader.charset().orElse("UTF-8");
            String string3 = byteString.decodeString("UTF-8");
            return FormUrlEncodedParser.parseAsJavaArrayValues(string3, string2);
        }
    }

    public static class Raw
    extends DelegatingBodyParser<Http.RawBuffer, RawBuffer> {
        @Inject
        public Raw() {
            super(JavaParsers.parse().raw(), JavaParsers::toJavaRaw);
        }
    }

    public static class Bytes
    extends BufferingBodyParser<ByteString> {
        public Bytes(long l, HttpErrorHandler httpErrorHandler2) {
            super(l, httpErrorHandler2, "Error decoding byte body");
        }

        @Inject
        public Bytes(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler2) {
            super(httpConfiguration, httpErrorHandler2, "Error decoding byte body");
        }

        @Override
        protected ByteString parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            return byteString;
        }
    }

    public static class TolerantText
    extends BufferingBodyParser<String> {
        public TolerantText(long l, HttpErrorHandler httpErrorHandler2) {
            super(l, httpErrorHandler2, "Error decoding text body");
        }

        @Inject
        public TolerantText(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler2) {
            super(httpConfiguration, httpErrorHandler2, "Error decoding text body");
        }

        @Override
        protected String parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            String string2 = requestHeader.charset().orElse("ISO-8859-1");
            return byteString.decodeString(string2);
        }
    }

    public static class Text
    extends TolerantText {
        private final HttpErrorHandler errorHandler;

        public Text(long l, HttpErrorHandler httpErrorHandler2) {
            super(l, httpErrorHandler2);
            this.errorHandler = httpErrorHandler2;
        }

        @Inject
        public Text(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler2) {
            super(httpConfiguration, httpErrorHandler2);
            this.errorHandler = httpErrorHandler2;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, String>> apply(Http.RequestHeader requestHeader2) {
            return BodyParsers.validateContentType(this.errorHandler, requestHeader2, "Expected text/plain", string2 -> string2.equalsIgnoreCase("text/plain"), requestHeader -> super.apply((Http.RequestHeader)requestHeader));
        }
    }

    public static class TolerantXml
    extends BufferingBodyParser<Document> {
        public TolerantXml(long l, HttpErrorHandler httpErrorHandler2) {
            super(l, httpErrorHandler2, "Error decoding xml body");
        }

        @Inject
        public TolerantXml(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler2) {
            super(httpConfiguration, httpErrorHandler2, "Error decoding xml body");
        }

        @Override
        protected Document parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            return XML.fromInputStream(byteString.iterator().asInputStream(), requestHeader.charset().orElse(null));
        }
    }

    public static class Xml
    extends TolerantXml {
        private final HttpErrorHandler errorHandler;

        public Xml(long l, HttpErrorHandler httpErrorHandler2) {
            super(l, httpErrorHandler2);
            this.errorHandler = httpErrorHandler2;
        }

        @Inject
        public Xml(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler2) {
            super(httpConfiguration, httpErrorHandler2);
            this.errorHandler = httpErrorHandler2;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, Document>> apply(Http.RequestHeader requestHeader2) {
            return BodyParsers.validateContentType(this.errorHandler, requestHeader2, "Expected XML", string2 -> string2.startsWith("text/xml") || string2.startsWith("application/xml") || JavaParsers.parse().ApplicationXmlMatcher().pattern().matcher((CharSequence)string2).matches(), requestHeader -> super.apply((Http.RequestHeader)requestHeader));
        }
    }

    public static class TolerantJson
    extends BufferingBodyParser<JsonNode> {
        public TolerantJson(long l, HttpErrorHandler httpErrorHandler2) {
            super(l, httpErrorHandler2, "Error decoding json body");
        }

        @Inject
        public TolerantJson(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler2) {
            super(httpConfiguration, httpErrorHandler2, "Error decoding json body");
        }

        @Override
        protected JsonNode parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            return play.libs.Json.parse((InputStream)byteString.iterator().asInputStream());
        }
    }

    public static class Json
    extends TolerantJson {
        private final HttpErrorHandler errorHandler;

        public Json(long l, HttpErrorHandler httpErrorHandler2) {
            super(l, httpErrorHandler2);
            this.errorHandler = httpErrorHandler2;
        }

        @Inject
        public Json(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler2) {
            super(httpConfiguration, httpErrorHandler2);
            this.errorHandler = httpErrorHandler2;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, JsonNode>> apply(Http.RequestHeader requestHeader2) {
            return BodyParsers.validateContentType(this.errorHandler, requestHeader2, "Expected application/json", string2 -> string2.equalsIgnoreCase("application/json") || string2.equalsIgnoreCase("text/json"), requestHeader -> super.apply((Http.RequestHeader)requestHeader));
        }
    }

    public static class AnyContent
    implements BodyParser<Object> {
        private final HttpErrorHandler errorHandler;
        private final HttpConfiguration httpConfiguration;

        @Inject
        public AnyContent(HttpErrorHandler httpErrorHandler2, HttpConfiguration httpConfiguration) {
            this.errorHandler = httpErrorHandler2;
            this.httpConfiguration = httpConfiguration;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, Object>> apply(Http.RequestHeader requestHeader) {
            String string3 = requestHeader.contentType().map(string2 -> string2.toLowerCase(Locale.ENGLISH)).orElse(null);
            BodyParser<Http.RawBuffer> bodyParser = string3 == null ? new Raw() : (string3.equals("text/plain") ? new TolerantText(this.httpConfiguration, this.errorHandler) : (string3.equals("text/xml") || string3.equals("application/xml") || JavaParsers.parse().ApplicationXmlMatcher().pattern().matcher(string3).matches() ? new TolerantXml(this.httpConfiguration, this.errorHandler) : (string3.equals("text/json") || string3.equals("application/json") ? new TolerantJson(this.httpConfiguration, this.errorHandler) : (string3.equals("application/x-www-form-urlencoded") ? new FormUrlEncoded(this.httpConfiguration, this.errorHandler) : (string3.equals("multipart/form-data") ? new MultipartFormData() : new Raw())))));
            return bodyParser.apply(requestHeader);
        }
    }

    public static class Default
    extends AnyContent {
        @Inject
        public Default(HttpErrorHandler httpErrorHandler2, HttpConfiguration httpConfiguration) {
            super(httpErrorHandler2, httpConfiguration);
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, Object>> apply(Http.RequestHeader requestHeader) {
            if (requestHeader.method().equals("POST") || requestHeader.method().equals("PUT") || requestHeader.method().equals("PATCH")) {
                return super.apply(requestHeader);
            }
            return new Empty().apply(requestHeader);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Of {
        public Class<? extends BodyParser> value();
    }
}

