/*
 * Decompiled with CFR 0.152.
 */
package play.libs.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import play.libs.F;

public class Futures {
    private static Timer timer = new Timer(true);

    public static <A> F.Promise<List<A>> sequence(Iterable<? extends CompletionStage<A>> iterable) {
        CompletionStage<ArrayList<Object>> completionStage = CompletableFuture.completedFuture(new ArrayList());
        for (CompletionStage<A> completionStage2 : iterable) {
            completionStage = completionStage.thenCombine(completionStage2, (list, object) -> {
                list.add(object);
                return list;
            });
        }
        return F.Promise.wrap(completionStage);
    }

    public static <A> F.Promise<List<A>> sequence(CompletionStage<A> ... completionStageArray) {
        return Futures.sequence(Arrays.asList(completionStageArray));
    }

    public static <A> F.Promise<A> timeout(final A a, long l, TimeUnit timeUnit) {
        final CompletableFuture completableFuture = new CompletableFuture();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                completableFuture.complete(a);
            }
        }, timeUnit.toMillis(l));
        return F.Promise.wrap(completableFuture);
    }

    public static F.Promise<Void> timeout(long l, TimeUnit timeUnit) {
        return Futures.timeout(null, l, timeUnit).thenApply(object -> {
            throw new F.PromiseTimeoutException("Timeout in promise");
        });
    }

    public static <A> F.Promise<A> delayed(final Supplier<A> supplier, long l, TimeUnit timeUnit, final Executor executor) {
        final CompletableFuture completableFuture = new CompletableFuture();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                executor.execute(() -> 2.lambda$run$34(completableFuture, (Supplier)supplier));
            }

            private static /* synthetic */ void lambda$run$34(CompletableFuture completableFuture2, Supplier supplier2) {
                completableFuture2.complete(supplier2.get());
            }
        }, timeUnit.toMillis(l));
        return F.Promise.wrap(completableFuture);
    }
}

