/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.crypto;

import java.security.SecureRandom;
import java.time.Clock;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Hex;
import play.api.libs.crypto.CSRFTokenSigner;
import play.api.libs.crypto.CSRFTokenSigner$;
import play.api.libs.crypto.CookieSigner;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u0017\t1B)\u001a4bk2$8i\u0015*G)>\\WM\\*jO:,'O\u0003\u0002\u0004\t\u000511M]=qi>T!!\u0002\u0004\u0002\t1L'm\u001d\u0006\u0003\u000f!\t1!\u00199j\u0015\u0005I\u0011\u0001\u00029mCf\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005=\u00195K\u0015$U_.,gnU5h]\u0016\u0014\b\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\rMLwM\\3s!\t\u0019\u0012$\u0003\u0002\u001b\u0005\ta1i\\8lS\u0016\u001c\u0016n\u001a8fe\"AA\u0004\u0001B\u0001B\u0003%Q$A\u0003dY>\u001c7\u000e\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!A/[7f\u0015\u0005\u0011\u0013\u0001\u00026bm\u0006L!\u0001J\u0010\u0003\u000b\rcwnY6\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\rA\u0013F\u000b\t\u0003'\u0001AQaF\u0013A\u0002aAQ\u0001H\u0013A\u0002uA#!\n\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014AB5oU\u0016\u001cGOC\u00012\u0003\u0015Q\u0017M^1y\u0013\t\u0019dF\u0001\u0004J]*,7\r\u001e\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0003\u0019\u0011\u0018M\u001c3p[V\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;C\u0005A1/Z2ve&$\u00180\u0003\u0002=s\ta1+Z2ve\u0016\u0014\u0016M\u001c3p[\"1a\b\u0001Q\u0001\n]\nqA]1oI>l\u0007\u0005C\u0003A\u0001\u0011\u0005\u0011)A\u0005tS\u001etGk\\6f]R\u0011!)\u0013\t\u0003\u0007\u001as!!\u0004#\n\u0005\u0015s\u0011A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\b\t\u000b){\u0004\u0019\u0001\"\u0002\u000bQ|7.\u001a8\t\u000b1\u0003A\u0011A'\u0002%\u0015DHO]1diNKwM\\3e)>\\WM\u001c\u000b\u0003\u001dF\u00032!D(C\u0013\t\u0001fB\u0001\u0004PaRLwN\u001c\u0005\u0006\u0015.\u0003\rA\u0011\u0005\u0006'\u0002!\t\u0001V\u0001\u000eO\u0016tWM]1uKR{7.\u001a8\u0016\u0003\tCQA\u0016\u0001\u0005\u0002Q\u000b1cZ3oKJ\fG/Z*jO:,G\rV8lK:DQ\u0001\u0017\u0001\u0005\u0002e\u000b1cY8na\u0006\u0014XmU5h]\u0016$Gk\\6f]N$2AW/`!\ti1,\u0003\u0002]\u001d\t9!i\\8mK\u0006t\u0007\"\u00020X\u0001\u0004\u0011\u0015A\u0002;pW\u0016t\u0017\tC\u0003a/\u0002\u0007!)\u0001\u0004u_.,gN\u0011\u0005\u0006E\u0002!\teY\u0001\u0013G>t7\u000f^1oiRKW.Z#rk\u0006d7\u000fF\u0002[I\u001aDQ!Z1A\u0002\t\u000b\u0011!\u0019\u0005\u0006O\u0006\u0004\rAQ\u0001\u0002E\u0002")
public class DefaultCSRFTokenSigner
implements CSRFTokenSigner {
    private final CookieSigner signer;
    private final Clock clock;
    private final SecureRandom random;

    private SecureRandom random() {
        return this.random;
    }

    @Override
    public String signToken(String token) {
        long nonce = this.clock.millis();
        String joined = new StringBuilder().append(nonce).append((Object)"-").append((Object)token).toString();
        return new StringBuilder().append((Object)this.signer.sign(joined)).append((Object)"-").append((Object)joined).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Option<String> extractSignedToken(String token) {
        String[] stringArray = token.split("-", 3);
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty()) return None$.MODULE$;
        if (option.get() == null) return None$.MODULE$;
        if (((SeqLike)option.get()).lengthCompare(3) != 0) return None$.MODULE$;
        String signature = (String)((SeqLike)option.get()).apply(0);
        String nonce = (String)((SeqLike)option.get()).apply(1);
        String raw2 = (String)((SeqLike)option.get()).apply(2);
        if (!this.constantTimeEquals(signature, this.signer.sign(new StringBuilder().append((Object)nonce).append((Object)"-").append((Object)raw2).toString()))) return None$.MODULE$;
        return new Some((Object)raw2);
    }

    @Override
    public String generateToken() {
        byte[] bytes = new byte[12];
        this.random().nextBytes(bytes);
        return new String(Hex.encodeHex((byte[])bytes));
    }

    @Override
    public String generateSignedToken() {
        return this.signToken(this.generateToken());
    }

    @Override
    public boolean compareSignedTokens(String tokenA, String tokenB) {
        return BoxesRunTime.unboxToBoolean((Object)this.extractSignedToken(tokenA).flatMap((Function1)new Serializable(this, tokenB){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultCSRFTokenSigner $outer;
            private final String tokenB$1;

            public final Option<Object> apply(String rawA) {
                return this.$outer.extractSignedToken(this.tokenB$1).map((Function1)new Serializable(this, rawA){
                    public static final long serialVersionUID = 0L;
                    private final String rawA$1;

                    public final boolean apply(String rawB) {
                        return CSRFTokenSigner$.MODULE$.constantTimeEquals(this.rawA$1, rawB);
                    }
                    {
                        this.rawA$1 = rawA$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tokenB$1 = tokenB$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    @Override
    public boolean constantTimeEquals(String a, String b) {
        return CSRFTokenSigner$.MODULE$.constantTimeEquals(a, b);
    }

    @Inject
    public DefaultCSRFTokenSigner(CookieSigner signer, Clock clock) {
        this.signer = signer;
        this.clock = clock;
        this.random = new SecureRandom();
        this.random().nextBytes(new byte[55]);
    }
}

