/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.Bases;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$Binary$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.BitVector;
import scodec.bits.BitVector$;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class BitVector$
implements Serializable {
    public static final BitVector$ MODULE$;
    private final BitVector empty;
    private final BitVector zero;
    private final BitVector one;
    private final BitVector lowByte;
    private final BitVector highByte;

    static {
        new BitVector$();
    }

    public BitVector empty() {
        return this.empty;
    }

    public BitVector zero() {
        return this.zero;
    }

    public BitVector one() {
        return this.one;
    }

    public BitVector lowByte() {
        return this.lowByte;
    }

    public BitVector highByte() {
        return this.highByte;
    }

    public BitVector bit(boolean high) {
        return high ? this.one() : this.zero();
    }

    public BitVector bits(Iterable<Object> b) {
        return (BitVector)b.iterator().zipWithIndex().foldLeft((Object)this.low(b.size()), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector acc, Tuple2<Object, Object> b) {
                return acc.update(b._2$mcI$sp(), b._1$mcZ$sp());
            }
        });
    }

    public BitVector high(long n) {
        return this.fill(n, true);
    }

    public BitVector low(long n) {
        return this.fill(n, false);
    }

    public BitVector apply(ByteVector bs) {
        return this.toBytes(bs, (long)bs.size() * 8L);
    }

    public BitVector apply(ByteBuffer buffer) {
        return this.apply(ByteVector$.MODULE$.apply(buffer));
    }

    public BitVector apply(byte[] bs) {
        return this.toBytes(ByteVector$.MODULE$.apply(bs), (long)Predef$.MODULE$.byteArrayOps(bs).size() * 8L);
    }

    public BitVector apply(GenTraversableOnce<Object> bs) {
        return this.apply(ByteVector$.MODULE$.apply(bs));
    }

    public <A> BitVector apply(Seq<A> bytes, Integral<A> evidence$1) {
        return this.apply(ByteVector$.MODULE$.apply(bytes, evidence$1));
    }

    public BitVector view(ByteBuffer buffer) {
        return this.toBytes(ByteVector$.MODULE$.view(buffer), (long)buffer.limit() * 8L);
    }

    public BitVector view(ByteBuffer buffer, long sizeInBits) {
        long l = sizeInBits;
        BitVector$ bitVector$ = this;
        Serializable serializable = new Serializable(sizeInBits){
            public static final long serialVersionUID = 0L;
            public final long sizeInBits$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Cannot have BitVector chunk larger than Int.MaxValue bytes: ").append((Object)BoxesRunTime.boxToLong((long)this.sizeInBits$1)).toString();
            }
            {
                this.sizeInBits$1 = sizeInBits$1;
            }
        };
        boolean bl = (sizeInBits + 7L) / 8L <= Integer.MAX_VALUE;
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            Serializable serializable2 = serializable;
            Serializable serializable3 = serializable;
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)new StringBuilder().append((Object)"Cannot have BitVector chunk larger than Int.MaxValue bytes: ").append((Object)BoxesRunTime.boxToLong((long)sizeInBits)).toString()).toString());
        }
        long l2 = sizeInBits;
        BitVector$ bitVector$2 = this;
        int n = (int)((sizeInBits + 7L) / 8L);
        Serializable serializable4 = new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;

            public final byte apply(int ind) {
                return this.buffer$1.get(ind);
            }
            {
                this.buffer$1 = buffer$1;
            }
        };
        ByteVector$ byteVector$ = ByteVector$.MODULE$;
        return this.toBytes(new ByteVector.Chunk(new ByteVector.View(new ByteVector.At((Function1)serializable4){
            private final Function1 f$1;

            public byte apply(int i) {
                return (byte)this.f$1.apply$mcII$sp(i);
            }
            {
                this.f$1 = f$1;
            }
        }, 0, n)), sizeInBits);
    }

    public BitVector view(byte[] bs) {
        return this.view(bs, (long)Predef$.MODULE$.byteArrayOps(bs).size() * 8L);
    }

    public BitVector view(byte[] bs, long sizeInBits) {
        return this.toBytes(ByteVector$.MODULE$.view(bs), sizeInBits);
    }

    public BitVector fill(long n, boolean high) {
        BitVector bitVector;
        long needed = this.scodec$bits$BitVector$$bytesNeededForBits(n);
        if (needed < Integer.MAX_VALUE) {
            ByteVector bs = ByteVector$.MODULE$.fill((int)needed, high ? BoxesRunTime.boxToInteger((int)-1) : BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$);
            bitVector = this.toBytes(bs, n);
        } else {
            bitVector = this.fill(n / 2L, high).$plus$plus(this.fill(n - n / 2L, high));
        }
        return bitVector;
    }

    public BitVector fromByte(byte b, int size) {
        Predef$.MODULE$.require(size <= 8);
        return ((BitVector)this.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{b}), (Integral)Numeric.ByteIsIntegral$.MODULE$).$less$less(BoxesRunTime.boxToLong((long)(8L - (long)size)))).take(size);
    }

    public int fromByte$default$2() {
        return 8;
    }

    public BitVector fromShort(short s, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 16);
        ByteBuffer buffer = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort(s);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(16L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        return !(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null) ? relevantBits : relevantBits.reverseByteOrder();
    }

    public int fromShort$default$2() {
        return 16;
    }

    public ByteOrdering fromShort$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public BitVector fromInt(int i, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 32);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(i);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(32L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        return !(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null) ? relevantBits : relevantBits.reverseByteOrder();
    }

    public int fromInt$default$2() {
        return 32;
    }

    public ByteOrdering fromInt$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public BitVector fromLong(long l, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 64);
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(l);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(64L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        return !(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null) ? relevantBits : relevantBits.reverseByteOrder();
    }

    public int fromLong$default$2() {
        return 64;
    }

    public ByteOrdering fromLong$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, BitVector> fromBinDescriptive(String str, Bases.BinaryAlphabet alphabet) {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(Tuple2<ByteVector, Object> x0$1) {
                Tuple2<ByteVector, Object> tuple2 = x0$1;
                if (x0$1 != null) {
                    int n;
                    int size;
                    ByteVector bytes = (ByteVector)x0$1._1();
                    int n2 = size = x0$1._2$mcI$sp();
                    switch (size) {
                        default: {
                            if (size % 8 == 0) {
                                n = 0;
                                break;
                            }
                            n = 8 - size % 8;
                            break;
                        }
                        case 0: {
                            n = 0;
                        }
                    }
                    int toDrop = n;
                    return bytes.toBitVector().drop(toDrop);
                }
                throw new MatchError(x0$1);
            }
        };
        Either either = ByteVector$.MODULE$.fromBinInternal(str, alphabet).right().e();
        if (!(either instanceof Left)) {
            int n;
            int size1;
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = right.b();
            Serializable serializable2 = serializable;
            Tuple2 tuple2 = (Tuple2)object;
            Serializable serializable3 = serializable;
            Tuple2 x11 = tuple2;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ByteVector bytes1 = (ByteVector)tuple2._1();
            int x12 = size1 = tuple2._2$mcI$sp();
            switch (size1) {
                default: {
                    if (size1 % 8 == 0) {
                        n = 0;
                        break;
                    }
                    n = 8 - size1 % 8;
                    break;
                }
                case 0: {
                    n = 0;
                }
            }
            int toDrop1 = n;
            return new Right((Object)bytes1.toBitVector().drop(toDrop1));
        }
        Left left = (Left)either;
        return new Left(left.a());
    }

    public Option<BitVector> fromBin(String str, Bases.BinaryAlphabet alphabet) {
        return this.fromBinDescriptive(str, alphabet).right().toOption();
    }

    public Bases.BinaryAlphabet fromBinDescriptive$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Bases.BinaryAlphabet fromBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public BitVector fromValidBin(String str, Bases.BinaryAlphabet alphabet) {
        return (BitVector)this.fromBinDescriptive(str, alphabet).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String msg) {
                throw new IllegalArgumentException(msg);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x) {
                return (BitVector)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public Bases.BinaryAlphabet fromValidBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, BitVector> fromHexDescriptive(String str, Bases.HexAlphabet alphabet) {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(Tuple2<ByteVector, Object> x0$2) {
                Tuple2<ByteVector, Object> tuple2 = x0$2;
                if (x0$2 != null) {
                    ByteVector bytes = (ByteVector)x0$2._1();
                    int count = x0$2._2$mcI$sp();
                    int toDrop = count % 2 == 0 ? 0 : 4;
                    return bytes.toBitVector().drop(toDrop);
                }
                throw new MatchError(x0$2);
            }
        };
        Either either = ByteVector$.MODULE$.fromHexInternal(str, alphabet).right().e();
        if (!(either instanceof Left)) {
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = right.b();
            Serializable serializable2 = serializable;
            Tuple2 tuple2 = (Tuple2)object;
            Serializable serializable3 = serializable;
            Tuple2 x11 = tuple2;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ByteVector bytes1 = (ByteVector)tuple2._1();
            int count1 = tuple2._2$mcI$sp();
            int toDrop1 = count1 % 2 == 0 ? 0 : 4;
            return new Right((Object)bytes1.toBitVector().drop(toDrop1));
        }
        Left left = (Left)either;
        return new Left(left.a());
    }

    public Option<BitVector> fromHex(String str, Bases.HexAlphabet alphabet) {
        return this.fromHexDescriptive(str, alphabet).right().toOption();
    }

    public Bases.HexAlphabet fromHexDescriptive$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Bases.HexAlphabet fromHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public BitVector fromValidHex(String str, Bases.HexAlphabet alphabet) {
        return (BitVector)this.fromHexDescriptive(str, alphabet).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String msg) {
                throw new IllegalArgumentException(msg);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x) {
                return (BitVector)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public Bases.HexAlphabet fromValidHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Either<String, BitVector> fromBase64Descriptive(String str, Bases.Base64Alphabet alphabet) {
        Left left;
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$30) {
                return x$30.toBitVector();
            }
        };
        Either either = ByteVector$.MODULE$.fromBase64Descriptive(str, alphabet).right().e();
        if (!(either instanceof Left)) {
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = right.b();
            Serializable serializable2 = serializable;
            ByteVector byteVector = (ByteVector)object;
            Serializable serializable3 = serializable;
            left = new Right((Object)byteVector.toBitVector());
        } else {
            Left left2 = (Left)either;
            left = new Left(left2.a());
        }
        return left;
    }

    public Option<BitVector> fromBase64(String str, Bases.Base64Alphabet alphabet) {
        return this.fromBase64Descriptive(str, alphabet).right().toOption();
    }

    public Bases.Base64Alphabet fromBase64Descriptive$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Bases.Base64Alphabet fromBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public BitVector fromValidBase64(String str, Bases.Base64Alphabet alphabet) {
        return (BitVector)this.fromBase64Descriptive(str, alphabet).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String msg) {
                throw new IllegalArgumentException(msg);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x) {
                return (BitVector)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public Bases.Base64Alphabet fromValidBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Either<CharacterCodingException, BitVector> encodeString(String str, Charset charset) {
        Left left;
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$31) {
                return x$31.bits();
            }
        };
        Either either = ByteVector$.MODULE$.encodeString(str, charset).right().e();
        if (!(either instanceof Left)) {
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = right.b();
            Serializable serializable2 = serializable;
            ByteVector byteVector = (ByteVector)object;
            Serializable serializable3 = serializable;
            left = new Right((Object)byteVector.bits());
        } else {
            Left left2 = (Left)either;
            left = new Left(left2.a());
        }
        return left;
    }

    public Either<CharacterCodingException, BitVector> encodeUtf8(String str) {
        Left left;
        String string = str;
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$32) {
                return x$32.bits();
            }
        };
        Either either = ByteVector$.MODULE$.encodeString(str, Charset.forName("UTF-8")).right().e();
        if (!(either instanceof Left)) {
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = right.b();
            Serializable serializable2 = serializable;
            ByteVector byteVector = (ByteVector)object;
            Serializable serializable3 = serializable;
            left = new Right((Object)byteVector.bits());
        } else {
            Left left2 = (Left)either;
            left = new Left(left2.a());
        }
        return left;
    }

    public Either<CharacterCodingException, BitVector> encodeAscii(String str) {
        Left left;
        String string = str;
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(ByteVector x$33) {
                return x$33.bits();
            }
        };
        Either either = ByteVector$.MODULE$.encodeString(str, Charset.forName("US-ASCII")).right().e();
        if (!(either instanceof Left)) {
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object = right.b();
            Serializable serializable2 = serializable;
            ByteVector byteVector = (ByteVector)object;
            Serializable serializable3 = serializable;
            left = new Right((Object)byteVector.bits());
        } else {
            Left left2 = (Left)either;
            left = new Left(left2.a());
        }
        return left;
    }

    public BitVector concat(GenTraversableOnce<BitVector> bvs) {
        return (BitVector)bvs.foldLeft((Object)this.empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x$34, BitVector x$35) {
                return x$34.$plus$plus(x$35);
            }
        });
    }

    public <S> BitVector unfold(S s, Function1<S, Option<Tuple2<BitVector, S>>> f) {
        return new BitVector.Suspend((Function0<BitVector>)new Serializable(s, f){
            public static final long serialVersionUID = 0L;
            private final Object s$1;
            public final Function1 f$2;

            public final BitVector apply() {
                Object object;
                None$ none$;
                Serializable serializable = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.unfold.1 $outer;

                    public final BitVector.Append apply(Tuple2<BitVector, S> x0$3) {
                        Tuple2<BitVector, S> tuple2 = x0$3;
                        if (x0$3 != null) {
                            BitVector h = (BitVector)x0$3._1();
                            Object t = x0$3._2();
                            return new BitVector.Append(h, BitVector$.MODULE$.unfold(t, this.$outer.f$2));
                        }
                        throw new MatchError(x0$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                };
                Option option = (Option)this.f$2.apply(this.s$1);
                if (!option.isEmpty()) {
                    Object object2 = option.get();
                    Serializable serializable2 = serializable;
                    Some some = new Some((Object)serializable.apply((Tuple2)object2));
                    none$ = some;
                } else {
                    none$ = None$.MODULE$;
                }
                Serializable serializable3 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BitVector apply() {
                        return BitVector$.MODULE$.empty();
                    }
                };
                None$ none$2 = none$;
                if (!none$.isEmpty()) {
                    object = none$2.get();
                } else {
                    Serializable serializable4 = serializable3;
                    Serializable serializable5 = serializable3;
                    object = BitVector$.MODULE$.empty();
                }
                return (BitVector)object;
            }
            {
                this.s$1 = s$1;
                this.f$2 = f$2;
            }
        });
    }

    public BitVector fromInputStream(InputStream in, int chunkSizeInBytes) {
        Serializable serializable = new Serializable(chunkSizeInBytes){
            public static final long serialVersionUID = 0L;
            private final int chunkSizeInBytes$1;

            public final Option<Tuple2<BitVector, InputStream>> apply(InputStream in) {
                byte[] buf = new byte[this.chunkSizeInBytes$1];
                int nRead = in.read(buf);
                return nRead == this.chunkSizeInBytes$1 ? new Some((Object)new Tuple2((Object)BitVector$.MODULE$.apply(buf), (Object)in)) : (nRead == -1 ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BitVector$.MODULE$.apply((byte[])Predef$.MODULE$.byteArrayOps(buf).take(nRead)), (Object)in)));
            }
            {
                this.chunkSizeInBytes$1 = chunkSizeInBytes$1;
            }
        };
        InputStream inputStream = in;
        BitVector$ bitVector$ = this;
        return new BitVector.Suspend((Function0<BitVector>)new /* invalid duplicate definition of identical inner class */);
    }

    public int fromInputStream$default$2() {
        return 0xFA0000;
    }

    public BitVector fromChannel(ReadableByteChannel in, int chunkSizeInBytes, boolean direct) {
        Serializable serializable = new Serializable(chunkSizeInBytes, direct){
            public static final long serialVersionUID = 0L;
            private final int chunkSizeInBytes$2;
            private final boolean direct$1;

            public final Option<Tuple2<BitVector, ReadableByteChannel>> apply(ReadableByteChannel in) {
                ByteBuffer buf = this.direct$1 ? ByteBuffer.allocateDirect(this.chunkSizeInBytes$2) : ByteBuffer.allocate(this.chunkSizeInBytes$2);
                int nRead = in.read(buf);
                buf.flip();
                return nRead != -1 ? new Some((Object)new Tuple2((Object)BitVector$.MODULE$.view(buf, (long)nRead * 8L), (Object)in)) : None$.MODULE$;
            }
            {
                this.chunkSizeInBytes$2 = chunkSizeInBytes$2;
                this.direct$1 = direct$1;
            }
        };
        ReadableByteChannel readableByteChannel = in;
        BitVector$ bitVector$ = this;
        return new BitVector.Suspend((Function0<BitVector>)new /* invalid duplicate definition of identical inner class */);
    }

    public int fromChannel$default$2() {
        return 0xFA0000;
    }

    public boolean fromChannel$default$3() {
        return false;
    }

    public BitVector fromMmap(FileChannel in, int chunkSizeInBytes) {
        FileChannel fileChannel = in;
        Predef$ predef$ = Predef$.MODULE$;
        Long l = BoxesRunTime.boxToLong((long)0L);
        FileChannel fileChannel2 = in;
        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
        Serializable serializable = new Serializable(chunkSizeInBytes){
            public static final long serialVersionUID = 0L;
            private final int chunkSizeInBytes$3;

            public final Option<Tuple2<BitVector, Tuple2<FileChannel, Object>>> apply(Tuple2<FileChannel, Object> x0$4) {
                Tuple2<FileChannel, Object> tuple2 = x0$4;
                if (x0$4 != null) {
                    None$ none$;
                    FileChannel in = (FileChannel)x0$4._1();
                    long pos = x0$4._2$mcJ$sp();
                    if (pos == in.size()) {
                        none$ = None$.MODULE$;
                    } else {
                        Predef$.MODULE$.require(pos < in.size());
                        long l = in.size() - pos;
                        Predef$ predef$ = Predef$.MODULE$;
                        long bytesToRead = BoxesRunTime.unboxToLong((Object)new RichLong(l).min((Object)BoxesRunTime.boxToLong((long)this.chunkSizeInBytes$3)));
                        MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, pos, bytesToRead);
                        Predef$.MODULE$.require((long)buf.limit() == bytesToRead);
                        FileChannel fileChannel = in;
                        Predef$ predef$2 = Predef$.MODULE$;
                        Long l2 = BoxesRunTime.boxToLong((long)(pos + bytesToRead));
                        FileChannel fileChannel2 = in;
                        Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                        Some some = new Some((Object)new Tuple2((Object)BitVector$.MODULE$.view(buf), (Object)new Tuple2((Object)in, (Object)l2)));
                        none$ = some;
                    }
                    return none$;
                }
                throw new MatchError(x0$4);
            }
            {
                this.chunkSizeInBytes$3 = chunkSizeInBytes$3;
            }
        };
        Tuple2 tuple2 = new Tuple2((Object)in, (Object)l);
        BitVector$ bitVector$ = this;
        return new BitVector.Suspend((Function0<BitVector>)new /* invalid duplicate definition of identical inner class */);
    }

    public int fromMmap$default$2() {
        return 0xFA0000;
    }

    public BitVector.Bytes toBytes(ByteVector bs, long sizeInBits) {
        long needed = this.scodec$bits$BitVector$$bytesNeededForBits(sizeInBits);
        Predef$.MODULE$.require(needed <= (long)bs.size());
        ByteVector b = (long)bs.size() > needed ? bs.take((int)needed) : bs;
        return new BitVector.Bytes(b, sizeInBits);
    }

    public BitVector concat(Vector<BitVector> vs) {
        return (BitVector)vs.foldLeft((Object)this.empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BitVector apply(BitVector x$37, BitVector x$38) {
                return x$37.$plus$plus(x$38);
            }
        });
    }

    public boolean scodec$bits$BitVector$$getBit(byte by, int n) {
        return (128 >> n & by) != 0;
    }

    public byte scodec$bits$BitVector$$setBit(byte by, int n, boolean high) {
        return (byte)(high ? 128 >> n | by : ~(128 >> n) & by);
    }

    public long scodec$bits$BitVector$$validBitsInLastByte(long size) {
        long mod = size % 8L;
        return mod == 0L ? 8L : mod;
    }

    public byte scodec$bits$BitVector$$topNBits(int n) {
        return (byte)(-1 << 8 - n);
    }

    public long scodec$bits$BitVector$$bytesNeededForBits(long size) {
        return (size + 7L) / 8L;
    }

    public byte scodec$bits$BitVector$$reverseBitsInBytes(byte b) {
        int x = (b & 0x55) << 1 | (b & 0xAA) >> 1;
        x = (x & 0x33) << 2 | (x & 0xCC) >> 2;
        return (byte)((x & 0xF) << 4 | (x & 0xF0) >> 4);
    }

    public ByteVector scodec$bits$BitVector$$clearUnneededBits(long size, ByteVector bytes) {
        ByteVector byteVector;
        int valid = (int)this.scodec$bits$BitVector$$validBitsInLastByte(size);
        if (bytes.nonEmpty() && valid < 8) {
            int idx = bytes.size() - 1;
            byte last = bytes.apply(idx);
            byteVector = bytes.update(idx, (byte)(last & this.scodec$bits$BitVector$$topNBits(valid)));
        } else {
            byteVector = bytes;
        }
        return byteVector;
    }

    public <A> A reduceBalanced(TraversableOnce<A> v, Function1<A, Object> size, Function2<A, A, A> f) {
        return (A)((LinearSeqOptimized)((List)v.foldLeft((Object)Nil$.MODULE$, (Function2)new Serializable(size, f){
            public static final long serialVersionUID = 0L;
            private final Function1 size$1;
            private final Function2 f$1;

            public final List<Tuple2<A, Object>> apply(List<Tuple2<A, Object>> stack, A a) {
                A a2 = a;
                Predef$ predef$ = Predef$.MODULE$;
                Object object = this.size$1.apply(a);
                A a3 = a;
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                Tuple2 tuple2 = new Tuple2(a, object);
                return BitVector$.MODULE$.scodec$bits$BitVector$$fixup$1(stack.$colon$colon((Object)tuple2), this.f$1);
            }
            {
                this.size$1 = size$1;
                this.f$1 = f$1;
            }
        })).reverse().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final A apply(Tuple2<A, Object> x$41) {
                return (A)x$41._1();
            }
        }, List$.MODULE$.canBuildFrom())).reduceLeft(f);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final List scodec$bits$BitVector$$fixup$1(List stack, Function2 f$1) {
        while (true) {
            List list = stack;
            if (!(stack instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)stack;
            Tuple2 tuple2 = (Tuple2)colon2.hd$1();
            List list2 = colon2.tl$1();
            if (tuple2 == null) break;
            Object h2 = tuple2._1();
            long n = tuple2._2$mcJ$sp();
            if (!(list2 instanceof .colon.colon)) break;
            .colon.colon colon3 = (.colon.colon)list2;
            Tuple2 tuple22 = (Tuple2)colon3.hd$1();
            List t = colon3.tl$1();
            if (tuple22 == null) break;
            Object h = tuple22._1();
            long m = tuple22._2$mcJ$sp();
            if (n <= m / 2L) break;
            Tuple2 tuple23 = new Tuple2(f$1.apply(h, h2), (Object)BoxesRunTime.boxToLong((long)(m + n)));
            stack = t.$colon$colon((Object)tuple23);
        }
        List list = stack;
        return stack;
    }

    private BitVector$() {
        MODULE$ = this;
        this.empty = this.toBytes(ByteVector$.MODULE$.empty(), 0L);
        this.zero = this.toBytes(ByteVector$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{0}), Numeric.IntIsIntegral$.MODULE$), 1L);
        this.one = this.toBytes(ByteVector$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{255}), Numeric.IntIsIntegral$.MODULE$), 1L);
        this.lowByte = this.toBytes(ByteVector$.MODULE$.fill(8, BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$), 8L);
        this.highByte = this.toBytes(ByteVector$.MODULE$.fill(8, BoxesRunTime.boxToInteger((int)1), Numeric.IntIsIntegral$.MODULE$), 8L);
    }
}

