/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import sbt.DotGraph$;
import sbt.IO$;
import sbt.Path$;
import sbt.Relation;
import sbt.inc.Relations;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class DotGraph$ {
    public static final DotGraph$ MODULE$;

    static {
        new DotGraph$();
    }

    private Function1<File, String> fToString(Iterable<File> roots) {
        return new Serializable(roots){
            public static final long serialVersionUID = 0L;
            private final Iterable roots$1;

            public final String apply(File x) {
                return DotGraph$.MODULE$.sourceToString((Iterable<File>)this.roots$1, x);
            }
            {
                this.roots$1 = roots$1;
            }
        };
    }

    public void sources(Relations relations, File outputDirectory, Iterable<File> sourceRoots) {
        Function1<File, String> toString = this.fToString(sourceRoots);
        this.apply(relations, outputDirectory, toString, toString);
    }

    public void packages(Relations relations, File outputDirectory, Iterable<File> sourceRoots) {
        Serializable packageOnly = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String path) {
                int last = path.lastIndexOf(File.separatorChar);
                String packagePath = (last > 0 ? path.substring(0, last) : path).trim();
                return packagePath.isEmpty() ? "" : packagePath.replace(File.separatorChar, '.');
            }
        };
        Function1 toString = packageOnly.compose(this.fToString(sourceRoots));
        this.apply(relations, outputDirectory, (Function1<File, String>)toString, (Function1<File, String>)toString);
    }

    public void apply(Relations relations, File outputDir, Function1<File, String> sourceToString, Function1<File, String> externalToString) {
        IO$.MODULE$.createDirectory(outputDir);
        this.generateGraph(this.file$1("int-source-deps", outputDir), "dependencies", relations.internalSrcDep(), sourceToString, sourceToString);
        this.generateGraph(this.file$1("binary-dependencies", outputDir), "externalDependencies", relations.binaryDep(), externalToString, sourceToString);
    }

    public <Key, Value> void generateGraph(File file, String graphName, Relation<Key, Value> relation, Function1<Key, String> keyToString, Function1<Value, String> valueToString) {
        HashMap mappedGraph = new HashMap();
        ((IterableLike)relation.forwardMap().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Key, Set<Value>> check$ifrefutable$1) {
                Tuple2<Key, Set<Value>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(keyToString){
            public static final long serialVersionUID = 0L;
            private final Function1 keyToString$1;

            public final Tuple2<Tuple2<Key, Set<Value>>, String> apply(Tuple2<Key, Set<Value>> x$2) {
                Tuple2<Key, Set<Value>> tuple2 = x$2;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    String keyString = (String)this.keyToString$1.apply(key);
                    Tuple2 tuple22 = new Tuple2(tuple2, (Object)keyString);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.keyToString$1 = keyToString$1;
            }
        }, Map$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(valueToString, mappedGraph){
            public static final long serialVersionUID = 0L;
            public final Function1 valueToString$1;
            public final HashMap mappedGraph$1;

            public final void apply(Tuple2<Tuple2<Key, Set<Value>>, String> x$3) {
                Tuple2<Tuple2<Key, Set<Value>>, String> tuple2 = x$3;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    String keyString = (String)tuple2._2();
                    if (tuple22 != null) {
                        Set values2 = (Set)tuple22._2();
                        values2.foreach((Function1)new Serializable(this, keyString){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.generateGraph.3 $outer;
                            private final String keyString$1;

                            public final HashSet<String> apply(Value value) {
                                return ((HashSet)this.$outer.mappedGraph$1.getOrElseUpdate((Object)this.keyString$1, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final HashSet<String> apply() {
                                        return new HashSet();
                                    }
                                })).$plus$eq(this.$outer.valueToString$1.apply(value));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.keyString$1 = keyString$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.valueToString$1 = valueToString$1;
                this.mappedGraph$1 = mappedGraph$1;
            }
        });
        Seq mappings = (Seq)mappedGraph.toSeq().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, HashSet<String>> check$ifrefutable$2) {
                Tuple2<String, HashSet<String>> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HashSet<String> apply(Tuple2<String, HashSet<String>> x$4) {
                Tuple2<String, HashSet<String>> tuple2 = x$4;
                if (tuple2 != null) {
                    String dependsOn = (String)tuple2._1();
                    HashSet dependants = (HashSet)tuple2._2();
                    HashSet hashSet = (HashSet)dependants.withFilter((Function1)new Serializable(this, dependsOn){
                        public static final long serialVersionUID = 0L;
                        private final String dependsOn$1;

                        public final boolean apply(String dependant) {
                            String string = dependant;
                            String string2 = this.dependsOn$1;
                            return (string == null ? string2 != null : !string.equals(string2)) && !this.dependsOn$1.isEmpty() && !dependant.isEmpty();
                        }
                        {
                            this.dependsOn$1 = dependsOn$1;
                        }
                    }).map((Function1)new Serializable(this, dependsOn){
                        public static final long serialVersionUID = 0L;
                        private final String dependsOn$1;

                        public final String apply(String dependant) {
                            return new StringBuilder().append((Object)"\"").append((Object)dependant).append((Object)"\" -> \"").append((Object)this.dependsOn$1).append((Object)"\"").toString();
                        }
                        {
                            this.dependsOn$1 = dependsOn$1;
                        }
                    }, HashSet$.MODULE$.canBuildFrom());
                    return hashSet;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        String string = new StringBuilder().append((Object)"digraph ").append((Object)graphName).append((Object)" {").toString();
        Seq lines = (Seq)((SeqLike)mappings.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)"}", Seq$.MODULE$.canBuildFrom());
        IO$.MODULE$.writeLines(file, lines, IO$.MODULE$.writeLines$default$3(), IO$.MODULE$.writeLines$default$4());
    }

    public String sourceToString(Iterable<File> roots, File source) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(this.relativized(roots, source).trim())).stripSuffix(".scala"))).stripSuffix(".java");
    }

    private String relativized(Iterable<File> roots, File path) {
        Iterable relativized2 = (Iterable)roots.flatMap((Function1)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final File path$1;

            public final Iterable<String> apply(File root) {
                return Option$.MODULE$.option2Iterable(Path$.MODULE$.relativize(root, this.path$1));
            }
            {
                this.path$1 = path$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        int n = Integer.MAX_VALUE;
        int shortest = BoxesRunTime.unboxToInt((Object)relativized2.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$7, String x$8) {
                return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(x$7), x$8.length());
            }
        }));
        return (String)relativized2.find((Function1)new Serializable(shortest){
            public static final long serialVersionUID = 0L;
            private final int shortest$1;

            public final boolean apply(String x$9) {
                return x$9.length() == this.shortest$1;
            }
            {
                this.shortest$1 = shortest$1;
            }
        }).getOrElse((Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final File path$1;

            public final String apply() {
                return this.path$1.getName();
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    private final File file$1(String name, File outputDir$1) {
        return new File(outputDir$1, name);
    }

    private DotGraph$() {
        MODULE$ = this;
    }
}

