/*
 * Decompiled with CFR 0.152.
 */
package play.filters.csrf;

import play.api.Configuration;
import play.api.Play$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Session$;
import play.core.j.JavaHelpers$;
import play.filters.csrf.CSRF;
import play.filters.csrf.CSRF$DefaultErrorHandler$;
import play.filters.csrf.CSRF$SignedTokenProvider$;
import play.filters.csrf.CSRF$UnsignedTokenProvider$;
import play.filters.csrf.CSRFErrorHandler;
import play.mvc.Http;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class CSRFConf$ {
    public static final CSRFConf$ MODULE$;
    private final Set<String> UnsafeMethods;
    private final Set<String> UnsafeContentTypes;
    private final String HeaderName;
    private final String HeaderNoCheck;

    static {
        new CSRFConf$();
    }

    public Configuration c() {
        return Play$.MODULE$.configuration(Play$.MODULE$.current());
    }

    public String TokenName() {
        Configuration qual$1 = this.c();
        String x$2 = "csrf.token.name";
        Option x$3 = qual$1.getString$default$2();
        return (String)qual$1.getString(x$2, x$3).getOrElse((Function0)new Serializable(){

            public final String apply() {
                return "csrfToken";
            }
        });
    }

    public Option<String> CookieName() {
        Configuration qual$2 = this.c();
        String x$4 = "csrf.cookie.name";
        Option x$5 = qual$2.getString$default$2();
        return qual$2.getString(x$4, x$5);
    }

    public boolean SecureCookie() {
        return BoxesRunTime.unboxToBoolean((Object)this.c().getBoolean("csrf.cookie.secure").getOrElse((Function0)new Serializable(){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return Session$.MODULE$.secure();
            }
        }));
    }

    public long PostBodyBuffer() {
        return BoxesRunTime.unboxToLong((Object)this.c().getBytes("csrf.body.bufferSize").getOrElse((Function0)new Serializable(){

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 102400L;
            }
        }));
    }

    public boolean SignTokens() {
        return BoxesRunTime.unboxToBoolean((Object)this.c().getBoolean("csrf.sign.tokens").getOrElse((Function0)new Serializable(){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
    }

    public Set<String> UnsafeMethods() {
        return this.UnsafeMethods;
    }

    public Set<String> UnsafeContentTypes() {
        return this.UnsafeContentTypes;
    }

    public String HeaderName() {
        return this.HeaderName;
    }

    public String HeaderNoCheck() {
        return this.HeaderNoCheck;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean defaultCreateIfNotFound(RequestHeader request) {
        String string = request.method();
        String string2 = "GET";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = request.method();
            String string4 = "HEAD";
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
        }
        if (request.accepts("text/html")) return true;
        if (!request.accepts("application/xml+xhtml")) return false;
        return true;
    }

    public CSRF.ErrorHandler defaultJavaErrorHandler() {
        Configuration qual$3 = this.c();
        String x$6 = "csrf.error.handler";
        Option x$7 = qual$3.getString$default$2();
        return (CSRF.ErrorHandler)qual$3.getString(x$6, x$7).map((Function1)new Serializable(){

            public final CSRF.ErrorHandler apply(String className) {
                block6: {
                    CSRF.ErrorHandler errorHandler;
                    block5: {
                        Class<?> clazz;
                        block4: {
                            try {
                                clazz = Play$.MODULE$.classloader(Play$.MODULE$.current()).loadClass(className);
                                if (!CSRFErrorHandler.class.isAssignableFrom(clazz)) break block4;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new RuntimeException(new StringBuilder().append((Object)"Could not find CSRF error handler ").append((Object)className).toString(), classNotFoundException);
                            }
                            CSRFErrorHandler errorHandler2 = (CSRFErrorHandler)clazz.newInstance();
                            errorHandler = new CSRF.ErrorHandler(this, errorHandler2){
                                private final CSRFErrorHandler errorHandler$1;

                                public Result handle(RequestHeader req, String msg) {
                                    Http.Context ctx = JavaHelpers$.MODULE$.createJavaContext(req);
                                    Http.Context.current.set(ctx);
                                    try {
                                        return this.errorHandler$1.handle(msg).toScala();
                                    }
                                    finally {
                                        Http.Context.current.remove();
                                    }
                                }
                                {
                                    this.errorHandler$1 = errorHandler$1;
                                }
                            };
                            break block5;
                        }
                        if (!CSRF.ErrorHandler.class.isAssignableFrom(clazz)) break block6;
                        errorHandler = (CSRF.ErrorHandler)clazz.newInstance();
                    }
                    return errorHandler;
                }
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error handler must implement ", " or ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CSRFErrorHandler.class, CSRF.ErrorHandler.class})));
            }
        }).getOrElse((Function0)new Serializable(){

            public final CSRF$DefaultErrorHandler$ apply() {
                return CSRF$DefaultErrorHandler$.MODULE$;
            }
        });
    }

    public CSRF$DefaultErrorHandler$ defaultErrorHandler() {
        return CSRF$DefaultErrorHandler$.MODULE$;
    }

    public CSRF.TokenProvider defaultTokenProvider() {
        return this.SignTokens() ? CSRF$SignedTokenProvider$.MODULE$ : CSRF$UnsignedTokenProvider$.MODULE$;
    }

    private CSRFConf$() {
        MODULE$ = this;
        this.UnsafeMethods = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POST"}));
        this.UnsafeContentTypes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"application/x-www-form-urlencoded", "text/plain", "multipart/form-data"}));
        this.HeaderName = "Csrf-Token";
        this.HeaderNoCheck = "nocheck";
    }
}

