/*
 * Decompiled with CFR 0.152.
 */
package play.twirl.sbt;

import java.io.File;
import play.twirl.compiler.GeneratedSource;
import play.twirl.compiler.TemplateCompilationError;
import play.twirl.compiler.TwirlCompiler$;
import play.twirl.sbt.TemplateCompiler$;
import play.twirl.sbt.TemplateProblem;
import play.twirl.sbt.TemplateProblem$;
import sbt.FileFilter;
import sbt.Logger;
import sbt.LoggerReporter;
import sbt.LoggerReporter$;
import sbt.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec;
import scala.runtime.Nothing$;
import xsbti.Problem;

public final class TemplateCompiler$ {
    public static final TemplateCompiler$ MODULE$;

    static {
        new TemplateCompiler$();
    }

    public Seq<File> compile(Seq<File> sourceDirectories, File targetDirectory, Map<String, String> templateFormats, Seq<String> templateImports, FileFilter includeFilter, FileFilter excludeFilter, Codec codec, boolean useOldParser, Logger log) {
        Throwable throwable2;
        block2: {
            Seq seq;
            try {
                this.syncGenerated(targetDirectory, codec);
                Seq<Tuple4<File, File, String, String>> templates = this.collectTemplates(sourceDirectories, templateFormats, includeFilter, excludeFilter);
                templates.withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple4<File, File, String, String> check$ifrefutable$1) {
                        Tuple4<File, File, String, String> tuple4 = check$ifrefutable$1;
                        boolean bl = tuple4 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(targetDirectory, templateImports, codec, useOldParser){
                    public static final long serialVersionUID = 0L;
                    private final File targetDirectory$1;
                    private final Seq templateImports$1;
                    private final Codec codec$1;
                    private final boolean useOldParser$1;

                    public final Option<File> apply(Tuple4<File, File, String, String> x$1) {
                        Tuple4<File, File, String, String> tuple4 = x$1;
                        if (tuple4 != null) {
                            File template = (File)tuple4._1();
                            File sourceDirectory = (File)tuple4._2();
                            String extension = (String)tuple4._3();
                            String format = (String)tuple4._4();
                            String imports = TemplateCompiler$.MODULE$.formatImports((Seq<String>)this.templateImports$1, extension);
                            Option option = TwirlCompiler$.MODULE$.compile(template, sourceDirectory, this.targetDirectory$1, format, imports, this.codec$1, false, this.useOldParser$1);
                            return option;
                        }
                        throw new MatchError(tuple4);
                    }
                    {
                        this.targetDirectory$1 = targetDirectory$1;
                        this.templateImports$1 = templateImports$1;
                        this.codec$1 = codec$1;
                        this.useOldParser$1 = useOldParser$1;
                    }
                });
                seq = (Seq)this.generatedFiles(targetDirectory).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final File apply(File x$2) {
                        return x$2.getAbsoluteFile();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            catch (Throwable throwable2) {
                PartialFunction<Throwable, Nothing$> catchExpr1 = this.handleError(log, codec);
                if (!catchExpr1.isDefinedAt((Object)throwable2)) break block2;
                seq = (Seq)catchExpr1.apply((Object)throwable2);
            }
            return seq;
        }
        throw throwable2;
    }

    public Seq<File> generatedFiles(File targetDirectory) {
        return package$.MODULE$.singleFileFinder(targetDirectory).$times$times((FileFilter)package$.MODULE$.globFilter("*.template.scala")).get();
    }

    public void syncGenerated(File targetDirectory, Codec codec) {
        ((IterableLike)this.generatedFiles(targetDirectory).map((Function1)new Serializable(codec){
            public static final long serialVersionUID = 0L;
            private final Codec codec$2;

            public final GeneratedSource apply(File x$3) {
                return new GeneratedSource(x$3, this.codec$2);
            }
            {
                this.codec$2 = codec$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(GeneratedSource x$4) {
                x$4.sync();
            }
        });
    }

    public Seq<Tuple4<File, File, String, String>> collectTemplates(Seq<File> sourceDirectories, Map<String, String> templateFormats, FileFilter includeFilter, FileFilter excludeFilter) {
        return (Seq)sourceDirectories.flatMap((Function1)new Serializable(templateFormats, includeFilter, excludeFilter){
            public static final long serialVersionUID = 0L;
            public final Map templateFormats$1;
            private final FileFilter includeFilter$1;
            public final FileFilter excludeFilter$1;

            public final Seq<Tuple4<File, File, String, String>> apply(File sourceDirectory) {
                return (Seq)package$.MODULE$.singleFileFinder(sourceDirectory).$times$times(this.includeFilter$1).get().flatMap((Function1)new Serializable(this, sourceDirectory){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.collectTemplates.1 $outer;
                    private final File sourceDirectory$1;

                    public final Iterable<Tuple4<File, File, String, String>> apply(File file) {
                        String ext = (String)Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(package$.MODULE$.richFile(file).name())).split('.')).last();
                        return !this.$outer.excludeFilter$1.accept(file) && this.$outer.templateFormats$1.contains((Object)ext) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple4((Object)file, (Object)this.sourceDirectory$1, (Object)ext, this.$outer.templateFormats$1.apply((Object)ext)))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.sourceDirectory$1 = sourceDirectory$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.templateFormats$1 = templateFormats$1;
                this.includeFilter$1 = includeFilter$1;
                this.excludeFilter$1 = excludeFilter$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String formatImports(Seq<String> templateImports, String extension) {
        return ((TraversableOnce)templateImports.map((Function1)new Serializable(extension){
            public static final long serialVersionUID = 0L;
            private final String extension$1;

            public final String apply(String x$5) {
                return new StringBuilder().append((Object)"import ").append((Object)x$5.replace("%format%", this.extension$1)).toString();
            }
            {
                this.extension$1 = extension$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public PartialFunction<Throwable, Nothing$> handleError(Logger log, Codec codec) {
        return new Serializable(log, codec){
            public static final long serialVersionUID = 0L;
            private final Logger log$1;
            private final Codec codec$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof TemplateCompilationError) {
                    TemplateCompilationError templateCompilationError = (TemplateCompilationError)A1;
                    File source = templateCompilationError.source();
                    String message = templateCompilationError.message();
                    int line = templateCompilationError.line();
                    int column = templateCompilationError.column();
                    TemplateProblem.ProblemException exception = TemplateProblem$.MODULE$.exception(source, this.codec$3, message, line, column);
                    LoggerReporter reporter = new LoggerReporter(10, this.log$1, LoggerReporter$.MODULE$.$lessinit$greater$default$3());
                    Predef$.MODULE$.refArrayOps((Object[])exception.problems()).foreach((Function1)new Serializable(this, reporter){
                        public static final long serialVersionUID = 0L;
                        private final LoggerReporter reporter$1;

                        public final void apply(Problem p) {
                            this.reporter$1.display(p.position(), p.message(), p.severity());
                        }
                        {
                            this.reporter$1 = reporter$1;
                        }
                    });
                    throw exception;
                }
                throw A1;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof TemplateCompilationError ? true : true;
                return bl;
            }
            {
                this.log$1 = log$1;
                this.codec$3 = codec$3;
            }
        };
    }

    private TemplateCompiler$() {
        MODULE$ = this;
    }
}

