/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.modules.Buffer;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;

public class MacImpl
extends ScriptableObject {
    public static final String CLASS_NAME = "Hmac";
    public static final HashMap<String, String> MAC_ALGORITHMS = new HashMap();
    private Mac digest;

    public String getClassName() {
        return CLASS_NAME;
    }

    @JSFunction
    public static void init(Context cx, Scriptable thisObj, Object[] args, Function func) {
        String nodeAlgorithm = ArgUtils.stringArg(args, 0);
        Buffer.BufferImpl buf = ArgUtils.objArg(args, 1, Buffer.BufferImpl.class, true);
        MacImpl self = (MacImpl)thisObj;
        String jceAlgorithm = MAC_ALGORITHMS.get(nodeAlgorithm);
        if (jceAlgorithm == null) {
            jceAlgorithm = nodeAlgorithm;
        }
        try {
            self.digest = Mac.getInstance(jceAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw Utils.makeError(cx, thisObj, "Digest method not supported: \"" + jceAlgorithm + '\"');
        }
        if (buf != null && buf.getLength() > 0) {
            SecretKeySpec key = new SecretKeySpec(buf.getArray(), buf.getArrayOffset(), buf.getLength(), jceAlgorithm);
            try {
                self.digest.init(key);
            }
            catch (InvalidKeyException e) {
                throw Utils.makeError(cx, thisObj, "Error initializing key: " + e);
            }
        }
    }

    @JSFunction
    public static void update(Context cx, Scriptable thisObj, Object[] args, Function func) {
        MacImpl thisClass = (MacImpl)thisObj;
        ArgUtils.ensureArg(args, 0);
        String encoding = ArgUtils.stringArg(args, 1, null);
        if (args[0] instanceof String) {
            ByteBuffer bb = Utils.stringToBuffer(ArgUtils.stringArg(args, 0), Charsets.get().resolveCharset(encoding));
            thisClass.digest.update(bb.array(), bb.arrayOffset(), bb.limit());
        } else {
            Buffer.BufferImpl buf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
            thisClass.digest.update(buf.getArray(), buf.getArrayOffset(), buf.getLength());
        }
    }

    @JSFunction
    public static Object digest(Context cx, Scriptable thisObj, Object[] args, Function func) {
        MacImpl thisClass = (MacImpl)thisObj;
        String encoding = ArgUtils.stringArg(args, 0, null);
        byte[] digest = thisClass.digest.doFinal();
        if (encoding == null || "buffer".equals(encoding)) {
            return Buffer.BufferImpl.newBuffer(cx, thisObj, digest);
        }
        ByteBuffer bb = ByteBuffer.wrap(digest);
        return Utils.bufferToString(bb, Charsets.get().resolveCharset(encoding));
    }

    static {
        MAC_ALGORITHMS.put("md5", "HmacMD5");
        MAC_ALGORITHMS.put("sha1", "HmacSHA1");
        MAC_ALGORITHMS.put("sha256", "HmacSHA256");
        MAC_ALGORITHMS.put("sha384", "HmacSHA384");
        MAC_ALGORITHMS.put("sha512", "HmacSHA512");
    }
}

